/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.trino.execution.scheduler.faulttolerant.SplitsMapping;
import io.trino.execution.scheduler.faulttolerant.TestingConnectorSplit;
import io.trino.metadata.Split;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import org.assertj.guava.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSplitsMapping {
    @Test
    public void testNewSplitMappingBuilder() {
        SplitsMapping.Builder newBuilder = SplitsMapping.builder();
        newBuilder.addSplit(new PlanNodeId("N1"), 0, TestSplitsMapping.createSplit(1));
        newBuilder.addSplit(new PlanNodeId("N1"), 1, TestSplitsMapping.createSplit(2));
        newBuilder.addSplits(new PlanNodeId("N1"), 1, (List)ImmutableList.of((Object)TestSplitsMapping.createSplit(3), (Object)TestSplitsMapping.createSplit(4)));
        newBuilder.addSplits(new PlanNodeId("N1"), 2, (List)ImmutableList.of((Object)TestSplitsMapping.createSplit(5), (Object)TestSplitsMapping.createSplit(6)));
        newBuilder.addSplits(new PlanNodeId("N1"), (ListMultimap)ImmutableListMultimap.of((Object)0, (Object)TestSplitsMapping.createSplit(7), (Object)1, (Object)TestSplitsMapping.createSplit(8), (Object)3, (Object)TestSplitsMapping.createSplit(9)));
        newBuilder.addSplit(new PlanNodeId("N2"), 0, TestSplitsMapping.createSplit(10));
        newBuilder.addSplit(new PlanNodeId("N2"), 3, TestSplitsMapping.createSplit(11));
        newBuilder.addMapping(SplitsMapping.builder().addSplit(new PlanNodeId("N1"), 0, TestSplitsMapping.createSplit(20)).addSplit(new PlanNodeId("N1"), 4, TestSplitsMapping.createSplit(21)).addSplit(new PlanNodeId("N3"), 0, TestSplitsMapping.createSplit(22)).build());
        SplitsMapping splitsMapping1 = newBuilder.build();
        org.assertj.core.api.Assertions.assertThat((Collection)splitsMapping1.getPlanNodeIds()).containsExactlyInAnyOrder((Object[])new PlanNodeId[]{new PlanNodeId("N1"), new PlanNodeId("N2"), new PlanNodeId("N3")});
        Assertions.assertThat(this.splitIds(splitsMapping1, "N1")).isEqualTo((Object)ImmutableListMultimap.builder().putAll((Object)0, new Object[]{1, 7, 20}).putAll((Object)1, new Object[]{2, 3, 4, 8}).putAll((Object)2, new Object[]{5, 6}).putAll((Object)3, new Object[]{9}).put((Object)4, (Object)21).build());
        Assertions.assertThat(this.splitIds(splitsMapping1, "N2")).isEqualTo((Object)ImmutableListMultimap.builder().put((Object)0, (Object)10).put((Object)3, (Object)11).build());
        Assertions.assertThat(this.splitIds(splitsMapping1, "N3")).isEqualTo((Object)ImmutableListMultimap.builder().put((Object)0, (Object)22).build());
    }

    @Test
    public void testUpdatingSplitMappingBuilder() {
        SplitsMapping.Builder newBuilder = SplitsMapping.builder((SplitsMapping)SplitsMapping.builder().addSplit(new PlanNodeId("N1"), 0, TestSplitsMapping.createSplit(20)).addSplit(new PlanNodeId("N1"), 4, TestSplitsMapping.createSplit(21)).addSplit(new PlanNodeId("N3"), 0, TestSplitsMapping.createSplit(22)).build());
        newBuilder.addSplit(new PlanNodeId("N1"), 0, TestSplitsMapping.createSplit(1));
        newBuilder.addSplit(new PlanNodeId("N1"), 1, TestSplitsMapping.createSplit(2));
        newBuilder.addSplits(new PlanNodeId("N1"), 1, (List)ImmutableList.of((Object)TestSplitsMapping.createSplit(3), (Object)TestSplitsMapping.createSplit(4)));
        newBuilder.addSplits(new PlanNodeId("N1"), 2, (List)ImmutableList.of((Object)TestSplitsMapping.createSplit(5), (Object)TestSplitsMapping.createSplit(6)));
        newBuilder.addSplits(new PlanNodeId("N1"), (ListMultimap)ImmutableListMultimap.of((Object)0, (Object)TestSplitsMapping.createSplit(7), (Object)1, (Object)TestSplitsMapping.createSplit(8), (Object)3, (Object)TestSplitsMapping.createSplit(9)));
        newBuilder.addSplit(new PlanNodeId("N2"), 0, TestSplitsMapping.createSplit(10));
        newBuilder.addSplit(new PlanNodeId("N2"), 3, TestSplitsMapping.createSplit(11));
        SplitsMapping splitsMapping1 = newBuilder.build();
        org.assertj.core.api.Assertions.assertThat((Collection)splitsMapping1.getPlanNodeIds()).containsExactlyInAnyOrder((Object[])new PlanNodeId[]{new PlanNodeId("N1"), new PlanNodeId("N2"), new PlanNodeId("N3")});
        Assertions.assertThat(this.splitIds(splitsMapping1, "N1")).isEqualTo((Object)ImmutableListMultimap.builder().putAll((Object)0, new Object[]{20, 1, 7}).putAll((Object)1, new Object[]{2, 3, 4, 8}).putAll((Object)2, new Object[]{5, 6}).putAll((Object)3, new Object[]{9}).put((Object)4, (Object)21).build());
        Assertions.assertThat(this.splitIds(splitsMapping1, "N2")).isEqualTo((Object)ImmutableListMultimap.builder().put((Object)0, (Object)10).put((Object)3, (Object)11).build());
        Assertions.assertThat(this.splitIds(splitsMapping1, "N3")).isEqualTo((Object)ImmutableListMultimap.builder().put((Object)0, (Object)22).build());
    }

    private ListMultimap<Integer, Integer> splitIds(SplitsMapping splitsMapping, String planNodeId) {
        return (ListMultimap)splitsMapping.getSplits(new PlanNodeId(planNodeId)).entries().stream().collect(ImmutableListMultimap.toImmutableListMultimap(Map.Entry::getKey, entry -> ((TestingConnectorSplit)((Split)entry.getValue()).getConnectorSplit()).getId()));
    }

    private static Split createSplit(int id) {
        return new Split(TestingHandles.TEST_CATALOG_HANDLE, (ConnectorSplit)new TestingConnectorSplit(id, OptionalInt.empty(), Optional.empty()));
    }
}

