/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.OutputSpoolingController;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class TestOutputSpoolingController {
    TestOutputSpoolingController() {
    }

    @Test
    public void testInlineFirstRowsUntilThresholdThenSpooling() {
        OutputSpoolingControllerAssertions assertion = new OutputSpoolingControllerAssertions(new OutputSpoolingController(true, 100L, 1000L, 900L, 16000L));
        assertion.verifyNextMode(10, 100, OutputSpoolingController.Mode.INLINE).verifyInlined(1, 10, 100).verifyNextMode(10, 100, OutputSpoolingController.Mode.INLINE).verifyInlined(2, 20, 200).verifyNextMode(50, 400, OutputSpoolingController.Mode.INLINE).verifyInlined(3, 70, 600).verifyNextMode(50, 400, OutputSpoolingController.Mode.BUFFER).verifyBuffered(50, 400).verifyNextMode(50, 400, OutputSpoolingController.Mode.BUFFER).verifyBuffered(100, 800).verifyNextMode(50, 400, OutputSpoolingController.Mode.SPOOL).verifySpooled(1, 150, 1200).verifyEmptyBuffer().verifyNextMode(39, 399, OutputSpoolingController.Mode.BUFFER).verifyBuffered(39, 399);
    }

    @Test
    public void testSpoolingTargetSize() {
        OutputSpoolingControllerAssertions assertion = new OutputSpoolingControllerAssertions(new OutputSpoolingController(false, 0L, 0L, 512L, 2048L));
        assertion.verifyNextMode(100, 511, OutputSpoolingController.Mode.BUFFER).verifySpooledSegmentTarget(512L).verifyBuffered(100, 511).verifyNextMode(100, 1, OutputSpoolingController.Mode.SPOOL).verifySpooled(1, 200, 512).verifySpooledSegmentTarget(1024L).verifyEmptyBuffer().verifyNextMode(1, 333, OutputSpoolingController.Mode.BUFFER).verifyNextMode(1, 333, OutputSpoolingController.Mode.BUFFER).verifyNextMode(1, 333, OutputSpoolingController.Mode.BUFFER).verifyNextMode(1, 333, OutputSpoolingController.Mode.SPOOL).verifySpooled(2, 204, 1844).verifyEmptyBuffer().verifySpooledSegmentTarget(2048L).verifyNextMode(100, 2047, OutputSpoolingController.Mode.BUFFER).verifyNextMode(100, 2047, OutputSpoolingController.Mode.SPOOL).verifyEmptyBuffer().verifySpooledSegmentTarget(2048L).verifySpooled(3, 404, 5938);
    }

    @Test
    public void testSpoolingEncoderEfficiency() {
        OutputSpoolingControllerAssertions assertion = new OutputSpoolingControllerAssertions(new OutputSpoolingController(false, 0L, 0L, 32L, 100L));
        assertion.verifyNextMode(1000, 31, OutputSpoolingController.Mode.BUFFER).verifyBuffered(1000, 31).verifyNextMode(1000, 31, OutputSpoolingController.Mode.SPOOL).verifySpooled(1, 2000, 62).recordEncodedSize(31L).verifyEmptyBuffer().verifySpooledSegmentTarget(64L).verifyNextMode(100, 80, OutputSpoolingController.Mode.SPOOL).verifyNextMode(100, 47, OutputSpoolingController.Mode.BUFFER).verifySpooled(2, 2100, 142).verifyBuffered(100, 47).verifyNextMode(54, 1, OutputSpoolingController.Mode.BUFFER).recordEncodedSize(121L).verifySpooledSegmentTarget(100L).verifyNextMode(100, 80, OutputSpoolingController.Mode.SPOOL).verifyNextMode(100, 43, OutputSpoolingController.Mode.BUFFER).verifyNextMode(1, 1, OutputSpoolingController.Mode.BUFFER).verifyNextMode(100, 1, OutputSpoolingController.Mode.BUFFER).verifyNextMode(100, 80, OutputSpoolingController.Mode.SPOOL).verifyEmptyBuffer().verifySpooled(4, 2655, 395);
    }

    private record OutputSpoolingControllerAssertions(OutputSpoolingController controller) {
        public OutputSpoolingControllerAssertions verifyNextMode(int positionCount, int rawSizeInBytes, OutputSpoolingController.Mode expected) {
            AssertionsForClassTypes.assertThat((Object)this.controller.getNextMode(positionCount, (long)rawSizeInBytes)).isEqualTo((Object)expected);
            return this;
        }

        private OutputSpoolingControllerAssertions verifyInlined(int inlinedPages, int inlinedPositions, int inlinedRawBytes) {
            ((AbstractLongAssert)AssertionsForClassTypes.assertThat((long)this.controller.getInlinedPages()).describedAs("Inlined pages", new Object[0])).isEqualTo((long)inlinedPages);
            ((AbstractLongAssert)AssertionsForClassTypes.assertThat((long)this.controller.getInlinedPositions()).describedAs("Inlined positions", new Object[0])).isEqualTo((long)inlinedPositions);
            ((AbstractLongAssert)AssertionsForClassTypes.assertThat((long)this.controller.getInlinedRawBytes()).describedAs("Inlined raw bytes", new Object[0])).isEqualTo((long)inlinedRawBytes);
            return this;
        }

        private OutputSpoolingControllerAssertions verifySpooled(int spooledPages, int spooledPositions, int spooledRawBytes) {
            ((AbstractLongAssert)AssertionsForClassTypes.assertThat((long)this.controller.getSpooledPages()).describedAs("Spooled pages", new Object[0])).isEqualTo((long)spooledPages);
            ((AbstractLongAssert)AssertionsForClassTypes.assertThat((long)this.controller.getSpooledPositions()).describedAs("Spooled spooledPositions", new Object[0])).isEqualTo((long)spooledPositions);
            ((AbstractLongAssert)AssertionsForClassTypes.assertThat((long)this.controller.getSpooledRawBytes()).describedAs("Spooled raw bytes", new Object[0])).isEqualTo((long)spooledRawBytes);
            return this;
        }

        private OutputSpoolingControllerAssertions verifyBuffered(int bufferedPositions, int bufferSize) {
            ((AbstractLongAssert)AssertionsForClassTypes.assertThat((long)this.controller.getBufferedPositions()).describedAs("Buffered positions", new Object[0])).isEqualTo((long)bufferedPositions);
            ((AbstractLongAssert)AssertionsForClassTypes.assertThat((long)this.controller.getBufferedRawSize()).describedAs("Buffered size", new Object[0])).isEqualTo((long)bufferSize);
            return this;
        }

        private OutputSpoolingControllerAssertions verifySpooledSegmentTarget(long size) {
            ((AbstractLongAssert)AssertionsForClassTypes.assertThat((long)this.controller.getCurrentSpooledSegmentTarget()).describedAs("Spooled segment target", new Object[0])).isEqualTo(size);
            return this;
        }

        private OutputSpoolingControllerAssertions recordEncodedSize(long encodedSize) {
            this.controller.recordEncoded(encodedSize);
            return this;
        }

        private OutputSpoolingControllerAssertions verifyEmptyBuffer() {
            return this.verifyBuffered(0, 0);
        }
    }
}

