/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import io.trino.operator.RowIdComparisonStrategy;
import io.trino.operator.RowIdHashStrategy;
import io.trino.operator.RowReference;
import io.trino.operator.TopNPeerGroupLookup;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTopNPeerGroupLookup {
    private static final RowIdHashStrategy HASH_STRATEGY = new RowIdHashStrategy(){

        public boolean equals(long leftRowId, long rightRowId) {
            return leftRowId == rightRowId;
        }

        public long hashCode(long rowId) {
            return rowId;
        }
    };
    private static final long UNMAPPED_GROUP_ID = Long.MIN_VALUE;
    private static final long DEFAULT_RETURN_VALUE = -1L;

    @Test
    public void testCombinations() {
        for (int expectedSize : Arrays.asList(0, 1, 2, 3, 1000)) {
            for (float fillFactor : Arrays.asList(Float.valueOf(0.1f), Float.valueOf(0.9f), Float.valueOf(1.0f))) {
                this.testCombinations(expectedSize, fillFactor, 1L, 1L);
                this.testCombinations(expectedSize, fillFactor, 10L, 1L);
                this.testCombinations(expectedSize, fillFactor, 1L, 1000L);
                this.testCombinations(expectedSize, fillFactor, 10L, 1000L);
            }
        }
    }

    private void testCombinations(int expectedSize, float fillFactor, long totalGroupIds, long totalRowIds) {
        int rowId;
        TopNPeerGroupLookup lookup = new TopNPeerGroupLookup((long)expectedSize, fillFactor, HASH_STRATEGY, Long.MIN_VALUE, -1L);
        Assertions.assertThat((long)lookup.size()).isEqualTo(0L);
        Assertions.assertThat((boolean)lookup.isEmpty()).isTrue();
        int count = 0;
        int groupId = 0;
        while ((long)groupId < totalGroupIds) {
            int rowId2 = 0;
            while ((long)rowId2 < totalRowIds) {
                Assertions.assertThat((long)lookup.get((long)groupId, (long)rowId2)).isEqualTo(-1L);
                Assertions.assertThat((long)lookup.get((long)groupId, TestTopNPeerGroupLookup.toRowReference(rowId2))).isEqualTo(-1L);
                Assertions.assertThat((long)lookup.remove((long)groupId, (long)rowId2)).isEqualTo(-1L);
                Assertions.assertThat((long)lookup.put((long)groupId, (long)rowId2, (long)count)).isEqualTo(-1L);
                Assertions.assertThat((boolean)lookup.isEmpty()).isFalse();
                Assertions.assertThat((long)lookup.size()).isEqualTo((long)(++count));
                ++rowId2;
            }
            ++groupId;
        }
        count = 0;
        long totalEntries = totalGroupIds * totalRowIds;
        int groupId2 = 0;
        while ((long)groupId2 < totalGroupIds) {
            rowId = 0;
            while ((long)rowId < totalRowIds) {
                Assertions.assertThat((long)lookup.get((long)groupId2, (long)rowId)).isEqualTo((long)count);
                Assertions.assertThat((long)lookup.get((long)groupId2, TestTopNPeerGroupLookup.toRowReference(rowId))).isEqualTo((long)count);
                ++count;
                Assertions.assertThat((boolean)lookup.isEmpty()).isFalse();
                Assertions.assertThat((long)lookup.size()).isEqualTo(totalEntries);
                ++rowId;
            }
            ++groupId2;
        }
        count = 0;
        groupId2 = 0;
        while ((long)groupId2 < totalGroupIds) {
            rowId = 0;
            while ((long)rowId < totalRowIds) {
                Assertions.assertThat((long)lookup.put((long)groupId2, (long)rowId, (long)(count + 1))).isEqualTo((long)count);
                ++count;
                Assertions.assertThat((boolean)lookup.isEmpty()).isFalse();
                Assertions.assertThat((long)lookup.size()).isEqualTo(totalEntries);
                ++rowId;
            }
            ++groupId2;
        }
        count = 0;
        groupId2 = 0;
        while ((long)groupId2 < totalGroupIds) {
            rowId = 0;
            while ((long)rowId < totalRowIds) {
                Assertions.assertThat((boolean)lookup.isEmpty()).isFalse();
                Assertions.assertThat((long)lookup.size()).isEqualTo(totalEntries - (long)count);
                Assertions.assertThat((long)lookup.remove((long)groupId2, (long)rowId)).isEqualTo((long)(count + 1));
                ++count;
                ++rowId;
            }
            ++groupId2;
        }
        Assertions.assertThat((boolean)lookup.isEmpty()).isTrue();
        Assertions.assertThat((long)lookup.size()).isEqualTo(0L);
    }

    private static RowReference toRowReference(final long rowId) {
        return new RowReference(){

            public int compareTo(RowIdComparisonStrategy strategy, long otherRowId) {
                return strategy.compare(rowId, otherRowId);
            }

            public boolean equals(RowIdHashStrategy strategy, long otherRowId) {
                return strategy.equals(rowId, otherRowId);
            }

            public long hash(RowIdHashStrategy strategy) {
                return strategy.hashCode(rowId);
            }

            public long allocateRowId() {
                return rowId;
            }
        };
    }
}

