/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Splitter;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.http.client.testing.TestingResponse;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.trino.execution.TaskId;
import io.trino.execution.buffer.PagesSerdeFactory;
import io.trino.execution.buffer.PagesSerdeUtil;
import io.trino.operator.TestingTaskBuffer;
import io.trino.spi.Page;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.Assertions;

public class TestingExchangeHttpClientHandler
implements TestingHttpClient.Processor {
    private final LoadingCache<TaskId, TestingTaskBuffer> taskBuffers;
    private final PagesSerdeFactory serdeFactory;

    public TestingExchangeHttpClientHandler(LoadingCache<TaskId, TestingTaskBuffer> taskBuffers, PagesSerdeFactory serdeFactory) {
        this.taskBuffers = Objects.requireNonNull(taskBuffers, "taskBuffers is null");
        this.serdeFactory = Objects.requireNonNull(serdeFactory, "serdeFactory is null");
    }

    public Response handle(Request request) {
        ImmutableList parts = ImmutableList.copyOf((Iterable)Splitter.on((String)"/").omitEmptyStrings().split((CharSequence)request.getUri().getPath()));
        if (request.getMethod().equals("DELETE")) {
            Assertions.assertThat((List)parts).hasSize(1);
            return new TestingResponse(HttpStatus.NO_CONTENT, (ListMultimap)ImmutableListMultimap.of(), new byte[0]);
        }
        Assertions.assertThat((List)parts).hasSize(2);
        TaskId taskId = TaskId.valueOf((String)((String)parts.get(0)));
        int pageToken = Integer.parseInt((String)parts.get(1));
        ImmutableListMultimap.Builder headers = ImmutableListMultimap.builder();
        headers.put((Object)"X-Trino-Task-Instance-Id", (Object)"task-instance-id");
        headers.put((Object)"X-Trino-Page-Sequence-Id", (Object)String.valueOf(pageToken));
        headers.put((Object)"X-Trino-Task-Failed", (Object)"false");
        TestingTaskBuffer taskBuffer = (TestingTaskBuffer)this.taskBuffers.getUnchecked((Object)taskId);
        Page page = taskBuffer.getPage(pageToken);
        headers.put((Object)"Content-Type", (Object)"application/x-trino-pages");
        if (page != null) {
            headers.put((Object)"X-Trino-Page-End-Sequence-Id", (Object)String.valueOf(pageToken + 1));
            headers.put((Object)"X-Trino-Buffer-Complete", (Object)String.valueOf(false));
            Slice serializedPage = this.serdeFactory.createSerializer(Optional.empty()).serialize(page);
            DynamicSliceOutput output = new DynamicSliceOutput(256);
            output.writeInt(-22745087);
            output.writeLong(PagesSerdeUtil.calculateChecksum((List)ImmutableList.of((Object)serializedPage)));
            output.writeInt(1);
            output.writeBytes(serializedPage);
            return new TestingResponse(HttpStatus.OK, (ListMultimap)headers.build(), (InputStream)output.slice().getInput());
        }
        if (taskBuffer.isFinished()) {
            headers.put((Object)"X-Trino-Page-End-Sequence-Id", (Object)String.valueOf(pageToken));
            headers.put((Object)"X-Trino-Buffer-Complete", (Object)String.valueOf(true));
            DynamicSliceOutput output = new DynamicSliceOutput(8);
            output.writeInt(-22745087);
            output.writeLong(PagesSerdeUtil.calculateChecksum((List)ImmutableList.of()));
            output.writeInt(0);
            return new TestingResponse(HttpStatus.OK, (ListMultimap)headers.build(), (InputStream)output.slice().getInput());
        }
        headers.put((Object)"X-Trino-Page-End-Sequence-Id", (Object)String.valueOf(pageToken));
        headers.put((Object)"X-Trino-Buffer-Complete", (Object)String.valueOf(false));
        return new TestingResponse(HttpStatus.NO_CONTENT, (ListMultimap)headers.build(), new byte[0]);
    }
}

