/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.project;

import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.testing.TestingTicker;
import io.airlift.units.Duration;
import io.trino.block.BlockAssertions;
import io.trino.execution.executor.timesharing.PrioritizedSplitRunner;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.CompletedWork;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.PageAssertions;
import io.trino.operator.Work;
import io.trino.operator.project.InputChannels;
import io.trino.operator.project.InputPageProjection;
import io.trino.operator.project.PageFilter;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.project.PageProjection;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.gen.ExpressionProfiler;
import io.trino.sql.gen.PageFunctionCompiler;
import io.trino.sql.gen.columnar.PageFilterEvaluator;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.RowExpression;
import io.trino.testing.TestingConnectorSession;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestPageProcessor {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testProjectNoColumns() {
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), Optional.empty(), (List)ImmutableList.of(), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assertions.assertThat((List)outputPages).hasSize(1);
        Page outputPage = ((Optional)outputPages.get(0)).orElse(null);
        Assertions.assertThat((int)outputPage.getChannelCount()).isEqualTo(0);
        Assertions.assertThat((int)outputPage.getPositionCount()).isEqualTo(inputPage.getPositionCount());
    }

    @Test
    public void testFilterNoColumns() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new PageFilterEvaluator((PageFilter)new TestingPageFilter(SelectedPositions.positionsRange((int)0, (int)50)))), (List)ImmutableList.of());
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), memoryContext, inputPage);
        Assertions.assertThat((long)memoryContext.getBytes()).isEqualTo(0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assertions.assertThat((List)outputPages).hasSize(1);
        Page outputPage = ((Optional)outputPages.get(0)).orElse(null);
        Assertions.assertThat((int)outputPage.getChannelCount()).isEqualTo(0);
        Assertions.assertThat((int)outputPage.getPositionCount()).isEqualTo(50);
    }

    @Test
    public void testPartialFilter() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new PageFilterEvaluator((PageFilter)new TestingPageFilter(SelectedPositions.positionsRange((int)25, (int)50)))), Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assertions.assertThat((List)outputPages).hasSize(1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{BlockAssertions.createLongSequenceBlock(25, 75)}));
    }

    @Test
    public void testSelectAllFilter() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new PageFilterEvaluator((PageFilter)new SelectAllFilter())), Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assertions.assertThat((List)outputPages).hasSize(1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)}));
    }

    @Test
    public void testSelectNoneFilter() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new PageFilterEvaluator((PageFilter)new SelectNoneFilter())), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), memoryContext, inputPage);
        Assertions.assertThat((long)memoryContext.getBytes()).isEqualTo(0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assertions.assertThat((List)outputPages).isEmpty();
    }

    @Test
    public void testProjectEmptyPage() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new PageFilterEvaluator((PageFilter)new SelectAllFilter())), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 0)});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), memoryContext, inputPage);
        Assertions.assertThat((long)memoryContext.getBytes()).isEqualTo(0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assertions.assertThat((List)outputPages).isEmpty();
    }

    @Test
    public void testSelectNoneFilterLazyLoad() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new PageFilterEvaluator((PageFilter)new SelectNoneFilter())), (List)ImmutableList.of((Object)new InputPageProjection(1, (Type)BigintType.BIGINT)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100), new LazyBlock(100, () -> {
            throw new AssertionError((Object)"Lazy block should not be loaded");
        })});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), memoryContext, inputPage);
        Assertions.assertThat((long)memoryContext.getBytes()).isEqualTo(0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assertions.assertThat((List)outputPages).isEmpty();
    }

    @Test
    public void testProjectLazyLoad() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new PageFilterEvaluator((PageFilter)new SelectAllFilter())), Optional.empty(), (List)ImmutableList.of((Object)new LazyPagePageProjection()), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100), new LazyBlock(100, () -> {
            throw new AssertionError((Object)"Lazy block should not be loaded");
        })});
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName());
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), memoryContext, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assertions.assertThat((List)outputPages).hasSize(1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)}));
    }

    @Test
    public void testBatchedOutput() {
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)), OptionalInt.of(8192));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 20480)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        Assertions.assertThat((List)outputPages).hasSize(3);
        for (int i = 0; i < outputPages.size(); ++i) {
            Page actualPage = ((Optional)outputPages.get(i)).orElse(null);
            int offset = i * 8192;
            Page expectedPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(offset, offset + Math.min(inputPage.getPositionCount() - offset, 8192))});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), actualPage, expectedPage);
        }
    }

    @Test
    public void testAdaptiveBatchSize() {
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)VarcharType.VARCHAR)), OptionalInt.of(8192));
        Object[] slices = new Slice[20480];
        Arrays.fill(slices, Slices.allocate((int)4096));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, new DriverYieldSignal(), inputPage);
        ImmutableList outputPages = ImmutableList.copyOf(output);
        int batchSize = 8192;
        for (Optional actualPage : outputPages) {
            Page expectedPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, batchSize))});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), actualPage.orElse(null), expectedPage);
            if (((Page)actualPage.orElseThrow(() -> new AssertionError((Object)"page is not present"))).getSizeInBytes() <= 0x1000000L) continue;
            batchSize /= 2;
        }
        Arrays.fill(slices, Slices.allocate((int)128));
        inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        output = this.processAndAssertRetainedPageSize(pageProcessor, new DriverYieldSignal(), inputPage);
        outputPages = ImmutableList.copyOf(output);
        int offset = 0;
        for (Optional actualPage : outputPages) {
            Page expectedPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, Math.min(inputPage.getPositionCount() - offset, batchSize)))});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), actualPage.orElse(null), expectedPage);
            offset += ((Page)actualPage.orElseThrow(() -> new AssertionError((Object)"page is not present"))).getPositionCount();
            if (((Page)actualPage.orElseThrow(() -> new AssertionError((Object)"page is not present"))).getSizeInBytes() >= 0x400000L) continue;
            batchSize *= 2;
        }
    }

    @Test
    public void testOptimisticProcessing() {
        InvocationCountPageProjection firstProjection = new InvocationCountPageProjection((PageProjection)new InputPageProjection(0, (Type)VarcharType.VARCHAR));
        InvocationCountPageProjection secondProjection = new InvocationCountPageProjection((PageProjection)new InputPageProjection(0, (Type)VarcharType.VARCHAR));
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)firstProjection, (Object)secondProjection), OptionalInt.of(8192));
        Object[] slices = new Slice[20480];
        Arrays.fill(slices, Slices.allocate((int)4096));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        int batchSize = 8192;
        while (inputPage.getBlock(0).getRegionSizeInBytes(0, batchSize) > 0x1000000L) {
            batchSize /= 2;
        }
        int pageCount = 0;
        while (output.hasNext()) {
            Page actualPage = output.next().orElse(null);
            ValueBlock sliceBlock = BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, batchSize));
            Page expectedPage = new Page(new Block[]{sliceBlock, sliceBlock});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), actualPage, expectedPage);
            ++pageCount;
            if (actualPage.getSizeInBytes() <= 0x1000000L) continue;
            batchSize /= 2;
        }
        Assertions.assertThat((int)secondProjection.getInvocationCount()).isEqualTo(pageCount);
        Assertions.assertThat((firstProjection.getInvocationCount() < secondProjection.getInvocationCount() ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testRetainedSize() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new PageFilterEvaluator((PageFilter)new SelectAllFilter())), Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)VarcharType.VARCHAR), (Object)new InputPageProjection(1, (Type)VarcharType.VARCHAR)), OptionalInt.of(8192));
        String value = String.join((CharSequence)"", Collections.nCopies(30000, "a"));
        List<String> values = Collections.nCopies(800, value);
        Page inputPage = new Page(new Block[]{BlockAssertions.createStringsBlock(values), BlockAssertions.createStringsBlock(values)});
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, new DriverYieldSignal(), memoryContext, inputPage);
        Assertions.assertThat((boolean)output.hasNext()).isTrue();
        Assertions.assertThat((long)(memoryContext.getBytes() - (long)SizeOf.instanceSize(VariableWidthBlock.class))).isEqualTo(inputPage.getRetainedSizeInBytes());
    }

    @Test
    public void testYieldProjection() {
        int rows = 128;
        int columns = 20;
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), Optional.empty(), Collections.nCopies(columns, new YieldPageProjection((PageProjection)new InputPageProjection(0, (Type)VarcharType.VARCHAR))), OptionalInt.of(8192));
        Object[] slices = new Slice[rows];
        Arrays.fill(slices, Slices.allocate((int)rows));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, yieldSignal, inputPage);
        for (int i = 0; i < columns - 1; ++i) {
            Assertions.assertThat((boolean)output.hasNext()).isTrue();
            Assertions.assertThat((Object)output.next().orElse(null)).isNull();
            Assertions.assertThat((boolean)yieldSignal.isSet()).isTrue();
            yieldSignal.reset();
        }
        Assertions.assertThat((boolean)output.hasNext()).isTrue();
        Page actualPage = output.next().orElse(null);
        Assertions.assertThat((Object)actualPage).isNotNull();
        Assertions.assertThat((boolean)yieldSignal.isSet()).isTrue();
        yieldSignal.reset();
        Object[] blocks = new Block[columns];
        Arrays.fill(blocks, BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, rows)));
        Page expectedPage = new Page((Block[])blocks);
        PageAssertions.assertPageEquals(Collections.nCopies(columns, VarcharType.VARCHAR), actualPage, expectedPage);
        Assertions.assertThat((boolean)output.hasNext()).isFalse();
    }

    @Test
    public void testExpressionProfiler() {
        TestingFunctionResolution functionResolution = new TestingFunctionResolution();
        CallExpression add10Expression = Expressions.call((ResolvedFunction)functionResolution.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT)), (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
        TestingTicker testingTicker = new TestingTicker();
        PageFunctionCompiler functionCompiler = functionResolution.getPageFunctionCompiler();
        Supplier projectionSupplier = functionCompiler.compileProjection((RowExpression)add10Expression, Optional.empty());
        PageProjection projection = (PageProjection)projectionSupplier.get();
        Page page = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(1, 11)});
        ExpressionProfiler profiler = new ExpressionProfiler((Ticker)testingTicker, PrioritizedSplitRunner.SPLIT_RUN_QUANTA);
        for (int i = 0; i < 100; ++i) {
            profiler.start();
            Work work = projection.project(TestingConnectorSession.SESSION, new DriverYieldSignal(), page, SelectedPositions.positionsRange((int)0, (int)page.getPositionCount()));
            if (i < 10) {
                testingTicker.increment(10L, TimeUnit.SECONDS);
                profiler.stop(page.getPositionCount());
                Assertions.assertThat((boolean)profiler.isExpressionExpensive()).isTrue();
            } else {
                testingTicker.increment(0L, TimeUnit.NANOSECONDS);
                profiler.stop(page.getPositionCount());
                Assertions.assertThat((boolean)profiler.isExpressionExpensive()).isFalse();
            }
            work.process();
        }
    }

    @Test
    public void testIncreasingBatchSize() {
        int rows = 1024;
        TestingTicker testingTicker = new TestingTicker();
        ExpressionProfiler profiler = new ExpressionProfiler((Ticker)testingTicker, PrioritizedSplitRunner.SPLIT_RUN_QUANTA);
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)), OptionalInt.of(1), profiler);
        Object[] slices = new Slice[rows];
        Arrays.fill(slices, Slices.allocate((int)rows));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        long previousPositionCount = 1L;
        long totalPositionCount = 0L;
        while (totalPositionCount < (long)rows) {
            Optional<Page> page = output.next();
            Assertions.assertThat(page).isPresent();
            long positionCount = page.get().getPositionCount();
            if (positionCount > 1L && (totalPositionCount += positionCount) != (long)rows) {
                Assertions.assertThat((long)positionCount).isEqualTo(previousPositionCount * 2L);
            }
            previousPositionCount = positionCount;
        }
    }

    @Test
    public void testDecreasingBatchSize() {
        int rows = 1024;
        TestingTicker testingTicker = new TestingTicker();
        ExpressionProfiler profiler = new ExpressionProfiler((Ticker)testingTicker, new Duration(0.0, TimeUnit.MILLISECONDS));
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)), OptionalInt.of(512), profiler);
        Object[] slices = new Slice[rows];
        Arrays.fill(slices, Slices.allocate((int)rows));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        Iterator<Optional<Page>> output = this.processAndAssertRetainedPageSize(pageProcessor, inputPage);
        long previousPositionCount = 1L;
        long totalPositionCount = 0L;
        while (totalPositionCount < (long)rows) {
            Optional<Page> page = output.next();
            Assertions.assertThat(page).isPresent();
            long positionCount = page.get().getPositionCount();
            totalPositionCount += positionCount;
            if (positionCount > 1L && previousPositionCount != 1L) {
                Assertions.assertThat((long)positionCount).isEqualTo(previousPositionCount / 2L);
            }
            previousPositionCount = positionCount;
        }
    }

    private Iterator<Optional<Page>> processAndAssertRetainedPageSize(PageProcessor pageProcessor, Page inputPage) {
        return this.processAndAssertRetainedPageSize(pageProcessor, new DriverYieldSignal(), inputPage);
    }

    private Iterator<Optional<Page>> processAndAssertRetainedPageSize(PageProcessor pageProcessor, DriverYieldSignal yieldSignal, Page inputPage) {
        return this.processAndAssertRetainedPageSize(pageProcessor, yieldSignal, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), inputPage);
    }

    private Iterator<Optional<Page>> processAndAssertRetainedPageSize(PageProcessor pageProcessor, DriverYieldSignal yieldSignal, AggregatedMemoryContext memoryContext, Page inputPage) {
        Iterator output = pageProcessor.process(TestingConnectorSession.SESSION, yieldSignal, memoryContext.newLocalMemoryContext(PageProcessor.class.getSimpleName()), inputPage);
        Assertions.assertThat((long)memoryContext.getBytes()).isEqualTo(0L);
        return output;
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), () -> ((Block)block).getLoadedBlock());
    }

    private static class TestingPageFilter
    implements PageFilter {
        private final SelectedPositions selectedPositions;

        public TestingPageFilter(SelectedPositions selectedPositions) {
            this.selectedPositions = selectedPositions;
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0});
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            return this.selectedPositions;
        }
    }

    public static class SelectAllFilter
    implements PageFilter {
        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0});
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            return SelectedPositions.positionsRange((int)0, (int)page.getPositionCount());
        }
    }

    private static class SelectNoneFilter
    implements PageFilter {
        private SelectNoneFilter() {
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0});
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            return SelectedPositions.positionsRange((int)0, (int)0);
        }
    }

    public static class LazyPagePageProjection
    implements PageProjection {
        public Type getType() {
            return BigintType.BIGINT;
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0, 1});
        }

        public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            return new CompletedWork((Object)page.getBlock(0).getLoadedBlock());
        }
    }

    private static class InvocationCountPageProjection
    implements PageProjection {
        protected final PageProjection delegate;
        private int invocationCount;

        public InvocationCountPageProjection(PageProjection delegate) {
            this.delegate = delegate;
        }

        public Type getType() {
            return this.delegate.getType();
        }

        public boolean isDeterministic() {
            return this.delegate.isDeterministic();
        }

        public InputChannels getInputChannels() {
            return this.delegate.getInputChannels();
        }

        public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            this.setInvocationCount(this.getInvocationCount() + 1);
            return this.delegate.project(session, yieldSignal, page, selectedPositions);
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }

        public void setInvocationCount(int invocationCount) {
            this.invocationCount = invocationCount;
        }
    }

    private class YieldPageProjection
    extends InvocationCountPageProjection {
        public YieldPageProjection(PageProjection delegate) {
            super(delegate);
        }

        @Override
        public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            return new YieldPageProjectionWork(session, yieldSignal, page, selectedPositions);
        }

        private class YieldPageProjectionWork
        implements Work<Block> {
            private final DriverYieldSignal yieldSignal;
            private final Work<Block> work;

            public YieldPageProjectionWork(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
                this.yieldSignal = yieldSignal;
                this.work = YieldPageProjection.this.delegate.project(session, yieldSignal, page, selectedPositions);
            }

            public boolean process() {
                Assertions.assertThat((boolean)this.work.process()).isTrue();
                this.yieldSignal.setWithDelay(1L, TestPageProcessor.this.executor);
                this.yieldSignal.forceYieldForTesting();
                return true;
            }

            public Block getResult() {
                return (Block)this.work.getResult();
            }
        }
    }
}

