/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Base64;
import java.util.Random;

final class TypeOperatorBenchmarkUtil {
    private static final TypeOperators TYPE_OPERATORS = new TypeOperators();
    private static final MethodHandle EQUAL_BLOCK;
    private static final MethodHandle HASH_CODE_BLOCK;

    private TypeOperatorBenchmarkUtil() {
    }

    public static Type toType(String type) {
        return switch (type) {
            case "BIGINT" -> BigintType.BIGINT;
            case "VARCHAR" -> VarcharType.VARCHAR;
            case "DOUBLE" -> DoubleType.DOUBLE;
            case "BOOLEAN" -> BooleanType.BOOLEAN;
            default -> throw new UnsupportedOperationException();
        };
    }

    public static MethodHandle getEqualBlockMethod(Type type) {
        MethodHandle equalOperator = TYPE_OPERATORS.getEqualOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));
        return EQUAL_BLOCK.bindTo(equalOperator);
    }

    public static MethodHandle getHashCodeBlockMethod(Type type) {
        MethodHandle hashCodeOperator = TYPE_OPERATORS.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));
        return HASH_CODE_BLOCK.bindTo(hashCodeOperator);
    }

    private static long equalBlock(MethodHandle equalOperator, Block left, Block right) throws Throwable {
        int positionCount = left.getPositionCount();
        long count = 0L;
        for (int position = 0; position < positionCount; ++position) {
            if (equalOperator.invokeExact(left, position, right, position) != Boolean.TRUE) continue;
            ++count;
        }
        return count;
    }

    private static long hashBlock(MethodHandle hashOperator, Block block) throws Throwable {
        int positionCount = block.getPositionCount();
        long hash = 0L;
        for (int position = 0; position < positionCount; ++position) {
            hash += hashOperator.invokeExact(block, position);
        }
        return hash;
    }

    public static void addElement(Type type, Random random, BlockBuilder builder) {
        if (type.getJavaType() == Long.TYPE) {
            type.writeLong(builder, random.nextLong());
        } else if (type.getJavaType() == Double.TYPE) {
            type.writeDouble(builder, random.nextDouble());
        } else if (type.getJavaType() == Boolean.TYPE) {
            type.writeBoolean(builder, random.nextBoolean());
        } else if (type.equals((Object)VarcharType.VARCHAR)) {
            type.writeSlice(builder, TypeOperatorBenchmarkUtil.randomSlice(random));
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static void addElement(Type type, Random random, BlockBuilder leftBuilder, BlockBuilder rightBuilder, boolean equal) {
        if (type.getJavaType() == Long.TYPE) {
            long value = random.nextLong();
            type.writeLong(leftBuilder, value);
            if (equal) {
                type.writeLong(rightBuilder, value);
            } else {
                type.writeLong(rightBuilder, random.nextLong());
            }
        } else if (type.getJavaType() == Double.TYPE) {
            double value = random.nextDouble();
            type.writeDouble(leftBuilder, value);
            if (equal) {
                type.writeDouble(rightBuilder, value);
            } else {
                type.writeDouble(rightBuilder, random.nextDouble());
            }
        } else if (type.getJavaType() == Boolean.TYPE) {
            boolean value = random.nextBoolean();
            type.writeBoolean(leftBuilder, value);
            if (equal) {
                type.writeBoolean(rightBuilder, value);
            } else {
                type.writeBoolean(rightBuilder, random.nextBoolean());
            }
        } else if (type.equals((Object)VarcharType.VARCHAR)) {
            Slice testString = TypeOperatorBenchmarkUtil.randomSlice(random);
            type.writeSlice(leftBuilder, testString);
            if (equal) {
                type.writeSlice(rightBuilder, testString);
            } else {
                type.writeSlice(rightBuilder, TypeOperatorBenchmarkUtil.randomSlice(random));
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private static Slice randomSlice(Random random) {
        byte[] bytes = new byte[6 + random.nextInt(6)];
        random.nextBytes(bytes);
        byte[] base64 = Base64.getEncoder().encode(bytes);
        return Slices.wrappedBuffer((byte[])base64);
    }

    static {
        try {
            HASH_CODE_BLOCK = MethodHandles.lookup().findStatic(TypeOperatorBenchmarkUtil.class, "hashBlock", MethodType.methodType(Long.TYPE, MethodHandle.class, Block.class));
            EQUAL_BLOCK = MethodHandles.lookup().findStatic(TypeOperatorBenchmarkUtil.class, "equalBlock", MethodType.methodType(Long.TYPE, MethodHandle.class, Block.class, Block.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

