/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.jwt;

import com.google.common.io.Resources;
import io.airlift.security.pem.PemReader;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Locator;
import io.jsonwebtoken.LocatorAdapter;
import io.trino.server.security.jwt.EcCurve;
import io.trino.server.security.jwt.JwkDecoder;
import io.trino.server.security.jwt.JwtUtil;
import java.io.File;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJwkDecoder {
    @Test
    public void testReadRsaKeys() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"e\": \"AQAB\",\n      \"n\": \"mvj-0waJ2owQlFWrlC06goLs9PcNehIzCF0QrkdsYZJXOsipcHCFlXBsgQIdTdLvlCzNI07jSYA-zggycYi96lfDX-FYv_CqC8dRLf9TBOPvUgCyFMCFNUTC69hsrEYMR_J79Wj0MIOffiVr6eX-AaCG3KhBMZMh15KCdn3uVrl9coQivy7bk2Uw-aUJ_b26C0gWYj1DnpO4UEEKBk1X-lpeUMh0B_XorqWeq0NYK2pN6CoEIh0UrzYKlGfdnMU1pJJCsNxMiha-Vw3qqxez6oytOV_AswlWvQc7TkSX6cHfqepNskQb7pGxpgQpy9sA34oIxB_S-O7VS7_h0Qh4vQ\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\",\n      \"kid\": \"example-rsa\"\n    },\n    {\n      \"kty\": \"EC\",\n      \"use\": \"sig\",\n      \"crv\": \"P-256\",\n      \"kid\": \"example-ec\",\n      \"x\": \"W9pnAHwUz81LldKjL3BzxO1iHe1Pc0fO6rHkrybVy6Y\",\n      \"y\": \"XKSNmn_xajgOvWuAiJnWx5I46IwPVJJYPaEpsX3NPZg\",\n      \"alg\": \"ES256\"\n    }\n  ]\n}");
        Assertions.assertThat((Map)keys).hasSize(2);
        Assertions.assertThat((Object)((PublicKey)keys.get("example-rsa"))).isInstanceOf(JwkDecoder.JwkRsaPublicKey.class);
        Assertions.assertThat((Object)((PublicKey)keys.get("example-ec"))).isInstanceOf(JwkDecoder.JwkEcPublicKey.class);
    }

    @Test
    public void testNoKeyId() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"e\": \"AQAB\",\n      \"n\": \"mvj-0waJ2owQlFWrlC06goLs9PcNehIzCF0QrkdsYZJXOsipcHCFlXBsgQIdTdLvlCzNI07jSYA-zggycYi96lfDX-FYv_CqC8dRLf9TBOPvUgCyFMCFNUTC69hsrEYMR_J79Wj0MIOffiVr6eX-AaCG3KhBMZMh15KCdn3uVrl9coQivy7bk2Uw-aUJ_b26C0gWYj1DnpO4UEEKBk1X-lpeUMh0B_XorqWeq0NYK2pN6CoEIh0UrzYKlGfdnMU1pJJCsNxMiha-Vw3qqxez6oytOV_AswlWvQc7TkSX6cHfqepNskQb7pGxpgQpy9sA34oIxB_S-O7VS7_h0Qh4vQ\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\"\n    },\n    {\n      \"kty\": \"EC\",\n      \"use\": \"sig\",\n      \"crv\": \"P-256\",\n      \"x\": \"W9pnAHwUz81LldKjL3BzxO1iHe1Pc0fO6rHkrybVy6Y\",\n      \"y\": \"XKSNmn_xajgOvWuAiJnWx5I46IwPVJJYPaEpsX3NPZg\",\n      \"alg\": \"ES256\"\n    }\n  ]\n}");
        Assertions.assertThat((Map)keys).isEmpty();
    }

    @Test
    public void testRsaNoModulus() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"e\": \"AQAB\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\",\n      \"kid\": \"2c6fa6f5950a7ce465fcf247aa0b094828ac952c\"\n    }\n  ]\n}");
        Assertions.assertThat((Map)keys).isEmpty();
    }

    @Test
    public void testRsaNoExponent() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"n\": \"mvj-0waJ2owQlFWrlC06goLs9PcNehIzCF0QrkdsYZJXOsipcHCFlXBsgQIdTdLvlCzNI07jSYA-zggycYi96lfDX-FYv_CqC8dRLf9TBOPvUgCyFMCFNUTC69hsrEYMR_J79Wj0MIOffiVr6eX-AaCG3KhBMZMh15KCdn3uVrl9coQivy7bk2Uw-aUJ_b26C0gWYj1DnpO4UEEKBk1X-lpeUMh0B_XorqWeq0NYK2pN6CoEIh0UrzYKlGfdnMU1pJJCsNxMiha-Vw3qqxez6oytOV_AswlWvQc7TkSX6cHfqepNskQb7pGxpgQpy9sA34oIxB_S-O7VS7_h0Qh4vQ\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\",\n      \"kid\": \"2c6fa6f5950a7ce465fcf247aa0b094828ac952c\"\n    }\n  ]\n}");
        Assertions.assertThat((Map)keys).isEmpty();
    }

    @Test
    public void testRsaInvalidModulus() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"e\": \"AQAB\",\n      \"n\": \"!!INVALID!!\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\",\n      \"kid\": \"2c6fa6f5950a7ce465fcf247aa0b094828ac952c\"\n    }\n  ]\n}");
        Assertions.assertThat((Map)keys).isEmpty();
    }

    @Test
    public void testRsaInvalidExponent() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"e\": \"!!INVALID!!\",\n      \"n\": \"mvj-0waJ2owQlFWrlC06goLs9PcNehIzCF0QrkdsYZJXOsipcHCFlXBsgQIdTdLvlCzNI07jSYA-zggycYi96lfDX-FYv_CqC8dRLf9TBOPvUgCyFMCFNUTC69hsrEYMR_J79Wj0MIOffiVr6eX-AaCG3KhBMZMh15KCdn3uVrl9coQivy7bk2Uw-aUJ_b26C0gWYj1DnpO4UEEKBk1X-lpeUMh0B_XorqWeq0NYK2pN6CoEIh0UrzYKlGfdnMU1pJJCsNxMiha-Vw3qqxez6oytOV_AswlWvQc7TkSX6cHfqepNskQb7pGxpgQpy9sA34oIxB_S-O7VS7_h0Qh4vQ\",\n      \"alg\": \"RS256\",\n      \"use\": \"sig\",\n      \"kty\": \"RSA\",\n      \"kid\": \"2c6fa6f5950a7ce465fcf247aa0b094828ac952c\"\n    }\n  ]\n}");
        Assertions.assertThat((Map)keys).isEmpty();
    }

    @Test
    public void testJwtRsa() throws Exception {
        String jwkKeys = Resources.toString((URL)Resources.getResource((String)"jwk/jwk-public.json"), (Charset)StandardCharsets.UTF_8);
        Map keys = JwkDecoder.decodeKeys((String)jwkKeys);
        final RSAPublicKey publicKey = (RSAPublicKey)keys.get("test-rsa");
        Assertions.assertThat((Object)publicKey).isNotNull();
        RSAPublicKey expectedPublicKey = (RSAPublicKey)PemReader.loadPublicKey((File)new File(Resources.getResource((String)"jwk/jwk-rsa-public.pem").toURI()));
        Assertions.assertThat((BigInteger)publicKey.getPublicExponent()).isEqualTo((Object)expectedPublicKey.getPublicExponent());
        Assertions.assertThat((BigInteger)publicKey.getModulus()).isEqualTo((Object)expectedPublicKey.getModulus());
        PrivateKey privateKey = PemReader.loadPrivateKey((File)new File(Resources.getResource((String)"jwk/jwk-rsa-private.pem").toURI()), Optional.empty());
        String jwt = ((JwtBuilder)((JwtBuilder.BuilderHeader)JwtUtil.newJwtBuilder().signWith((Key)privateKey).header().keyId("test-rsa")).and()).subject("test-user").expiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
        Jws claimsJws = JwtUtil.newJwtParserBuilder().keyLocator((Locator)new LocatorAdapter<Key>(this){

            protected Key locate(JwsHeader header) {
                String keyId = header.getKeyId();
                Assertions.assertThat((String)keyId).isEqualTo("test-rsa");
                return publicKey;
            }
        }).build().parseSignedClaims((CharSequence)jwt);
        Assertions.assertThat((String)((Claims)claimsJws.getPayload()).getSubject()).isEqualTo("test-user");
    }

    @Test
    public void testEcKey() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"kid\": \"test-ec\",\n      \"kty\": \"EC\",\n      \"crv\": \"P-256\",\n      \"x\": \"W9pnAHwUz81LldKjL3BzxO1iHe1Pc0fO6rHkrybVy6Y\",\n      \"y\": \"XKSNmn_xajgOvWuAiJnWx5I46IwPVJJYPaEpsX3NPZg\"\n    }\n  ]\n}");
        Assertions.assertThat((Map)keys).hasSize(1);
        Assertions.assertThat((Object)((PublicKey)keys.get("test-ec"))).isInstanceOf(JwkDecoder.JwkEcPublicKey.class);
    }

    @Test
    public void testEcInvalidCurve() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"kid\": \"test-ec\",\n      \"kty\": \"EC\",\n      \"crv\": \"taco\",\n      \"x\": \"W9pnAHwUz81LldKjL3BzxO1iHe1Pc0fO6rHkrybVy6Y\",\n      \"y\": \"XKSNmn_xajgOvWuAiJnWx5I46IwPVJJYPaEpsX3NPZg\"\n    }\n  ]\n}");
        Assertions.assertThat((Map)keys).isEmpty();
    }

    @Test
    public void testEcInvalidX() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"kid\": \"test-ec\",\n      \"kty\": \"EC\",\n      \"crv\": \"P-256\",\n      \"x\": \"!!INVALID!!\",\n      \"y\": \"XKSNmn_xajgOvWuAiJnWx5I46IwPVJJYPaEpsX3NPZg\"\n    }\n  ]\n}");
        Assertions.assertThat((Map)keys).isEmpty();
    }

    @Test
    public void testEcInvalidY() {
        Map keys = JwkDecoder.decodeKeys((String)"{\n  \"keys\": [\n    {\n      \"kid\": \"test-ec\",\n      \"kty\": \"EC\",\n      \"crv\": \"P-256\",\n      \"x\": \"W9pnAHwUz81LldKjL3BzxO1iHe1Pc0fO6rHkrybVy6Y\",\n      \"y\": \"!!INVALID!!\"\n    }\n  ]\n}");
        Assertions.assertThat((Map)keys).isEmpty();
    }

    @Test
    public void testJwtEc() throws Exception {
        TestJwkDecoder.assertJwtEc("jwk-ec-p256", EcCurve.P_256);
        TestJwkDecoder.assertJwtEc("jwk-ec-p384", EcCurve.P_384);
        TestJwkDecoder.assertJwtEc("jwk-ec-p512", EcCurve.P_521);
    }

    private static void assertJwtEc(final String keyName, ECParameterSpec expectedSpec) throws Exception {
        String jwkKeys = Resources.toString((URL)Resources.getResource((String)"jwk/jwk-public.json"), (Charset)StandardCharsets.UTF_8);
        Map keys = JwkDecoder.decodeKeys((String)jwkKeys);
        final ECPublicKey publicKey = (ECPublicKey)keys.get(keyName);
        Assertions.assertThat((Object)publicKey).isNotNull();
        Assertions.assertThat((Object)publicKey.getParams()).isSameAs((Object)expectedSpec);
        ECPublicKey expectedPublicKey = (ECPublicKey)PemReader.loadPublicKey((File)new File(Resources.getResource((String)("jwk/" + keyName + "-public.pem")).toURI()));
        Assertions.assertThat((Object)publicKey.getW()).isEqualTo((Object)expectedPublicKey.getW());
        Assertions.assertThat((Object)publicKey.getParams().getCurve()).isEqualTo((Object)expectedPublicKey.getParams().getCurve());
        Assertions.assertThat((Object)publicKey.getParams().getGenerator()).isEqualTo((Object)expectedPublicKey.getParams().getGenerator());
        Assertions.assertThat((BigInteger)publicKey.getParams().getOrder()).isEqualTo((Object)expectedPublicKey.getParams().getOrder());
        Assertions.assertThat((int)publicKey.getParams().getCofactor()).isEqualTo(expectedPublicKey.getParams().getCofactor());
        PrivateKey privateKey = PemReader.loadPrivateKey((File)new File(Resources.getResource((String)("jwk/" + keyName + "-private.pem")).toURI()), Optional.empty());
        String jwt = ((JwtBuilder)((JwtBuilder.BuilderHeader)JwtUtil.newJwtBuilder().signWith((Key)privateKey).header().keyId(keyName)).and()).subject("test-user").expiration(Date.from(ZonedDateTime.now().plusMinutes(5L).toInstant())).compact();
        Jws claimsJws = JwtUtil.newJwtParserBuilder().keyLocator((Locator)new LocatorAdapter<Key>(){

            protected Key locate(JwsHeader header) {
                String keyId = header.getKeyId();
                Assertions.assertThat((String)keyId).isEqualTo(keyName);
                return publicKey;
            }
        }).build().parseSignedClaims((CharSequence)jwt);
        Assertions.assertThat((String)((Claims)claimsJws.getPayload()).getSubject()).isEqualTo("test-user");
    }
}

