/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import io.trino.spi.connector.CatalogSchemaName;
import io.trino.sql.SqlPath;
import io.trino.sql.parser.ParsingException;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestSqlPath {
    private static final CatalogSchemaName INLINE_SCHEMA_NAME = new CatalogSchemaName("system", "$query");
    private static final CatalogSchemaName BUILTIN_SCHEMA_NAME = new CatalogSchemaName("system", "builtin");

    TestSqlPath() {
    }

    @Test
    void empty() {
        Assertions.assertThat((String)SqlPath.EMPTY_PATH.getRawPath()).isEmpty();
        Assertions.assertThat((List)SqlPath.EMPTY_PATH.getPath()).containsExactly((Object[])new CatalogSchemaName[]{INLINE_SCHEMA_NAME, BUILTIN_SCHEMA_NAME});
    }

    @Test
    void parsing() {
        Assertions.assertThat((List)SqlPath.buildPath((String)"a.b", Optional.empty()).getPath()).containsExactly((Object[])new CatalogSchemaName[]{INLINE_SCHEMA_NAME, BUILTIN_SCHEMA_NAME, new CatalogSchemaName("a", "b")});
        Assertions.assertThat((List)SqlPath.buildPath((String)"a.b, c.d", Optional.empty()).getPath()).containsExactly((Object[])new CatalogSchemaName[]{INLINE_SCHEMA_NAME, BUILTIN_SCHEMA_NAME, new CatalogSchemaName("a", "b"), new CatalogSchemaName("c", "d")});
        Assertions.assertThat((List)SqlPath.buildPath((String)"y", Optional.of("x")).getPath()).containsExactly((Object[])new CatalogSchemaName[]{INLINE_SCHEMA_NAME, BUILTIN_SCHEMA_NAME, new CatalogSchemaName("x", "y")});
        Assertions.assertThat((List)SqlPath.buildPath((String)"y, z", Optional.of("x")).getPath()).containsExactly((Object[])new CatalogSchemaName[]{INLINE_SCHEMA_NAME, BUILTIN_SCHEMA_NAME, new CatalogSchemaName("x", "y"), new CatalogSchemaName("x", "z")});
        Assertions.assertThat((List)SqlPath.buildPath((String)"a.b, c.d", Optional.of("x")).getPath()).containsExactly((Object[])new CatalogSchemaName[]{INLINE_SCHEMA_NAME, BUILTIN_SCHEMA_NAME, new CatalogSchemaName("a", "b"), new CatalogSchemaName("c", "d")});
        Assertions.assertThat((List)SqlPath.buildPath((String)"a.b, y", Optional.of("x")).getPath()).containsExactly((Object[])new CatalogSchemaName[]{INLINE_SCHEMA_NAME, BUILTIN_SCHEMA_NAME, new CatalogSchemaName("a", "b"), new CatalogSchemaName("x", "y")});
        Assertions.assertThat((String)SqlPath.buildPath((String)"a.b,   c.d", Optional.empty()).getRawPath()).isEqualTo("a.b,   c.d");
    }

    @Test
    void invalidPath() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlPath.buildPath((String)"too.many.qualifiers", Optional.empty())).isInstanceOf(ParsingException.class)).hasMessageMatching("\\Qline 1:9: mismatched input '.'. Expecting: ',', <EOF>\\E");
    }
}

