/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.scalar.ApplyFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Lambda;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.EvaluateCall;
import io.trino.sql.planner.Symbol;
import io.trino.testing.TestingSession;
import io.trino.type.FunctionType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestEvaluateCall {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution((FunctionBundle)new InternalFunctionBundle(new SqlFunction[]{ApplyFunction.APPLY_FUNCTION}));
    private static final ResolvedFunction ADD_DOUBLE = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE));
    private static final ResolvedFunction DIVIDE_BIGINT = FUNCTIONS.resolveOperator(OperatorType.DIVIDE, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", (List<TypeSignatureProvider>)ImmutableList.of());
    private static final ResolvedFunction APPLY = FUNCTIONS.resolveFunction("apply", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT, new FunctionType((List)ImmutableList.of((Object)BigintType.BIGINT), (Type)BooleanType.BOOLEAN)}));

    @Test
    void test() {
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Call(ADD_DOUBLE, (List)ImmutableList.of((Object)new Reference((Type)DoubleType.DOUBLE, "x"), (Object)new Reference((Type)DoubleType.DOUBLE, "y"))))).describedAs("non-constant arguments", new Object[0])).isEmpty();
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Call(ADD_DOUBLE, (List)ImmutableList.of((Object)new Call(RANDOM, (List)ImmutableList.of()), (Object)new Call(RANDOM, (List)ImmutableList.of()))))).describedAs("non-deterministic arguments", new Object[0])).isEmpty();
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Call(ADD_DOUBLE, (List)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.0), (Object)new Constant((Type)DoubleType.DOUBLE, (Object)2.0))))).describedAs("non-deterministic arguments", new Object[0])).isEqualTo(Optional.of(new Constant((Type)DoubleType.DOUBLE, (Object)3.0)));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Call(APPLY, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Lambda((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "x")), (Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))))))).describedAs("higher-order function", new Object[0])).isEqualTo(Optional.of(Booleans.TRUE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Call(DIVIDE_BIGINT, (List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Constant((Type)BigintType.BIGINT, (Object)0L))))).describedAs("expression that fails", new Object[0])).isEmpty();
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateCall(FUNCTIONS.getPlannerContext()).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

