/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.EvaluateComparison;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestEvaluateComparison {
    @Test
    void testIdentical() {
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).describedAs("equal constants", new Object[0])).isEqualTo(Optional.of(Booleans.TRUE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))).describedAs("different constants", new Object[0])).isEqualTo(Optional.of(Booleans.FALSE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.FALSE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.FALSE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("both null", new Object[0])).isEqualTo(Optional.of(Booleans.TRUE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "x"))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Reference((Type)BigintType.BIGINT, "x")))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "x"))));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")))).describedAs("non-constants", new Object[0])).isEqualTo(Optional.empty());
    }

    @Test
    void testEqual() {
        Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).isEqualTo(Optional.of(Booleans.TRUE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("both null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Reference((Type)BigintType.BIGINT, "x")))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")))).describedAs("non-constants", new Object[0])).isEqualTo(Optional.empty());
    }

    @Test
    void testNotEqual() {
        Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))).isEqualTo(Optional.of(Booleans.TRUE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("both null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Reference((Type)BigintType.BIGINT, "x")))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.NOT_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")))).describedAs("non-constants", new Object[0])).isEqualTo(Optional.empty());
    }

    @Test
    void testLessThan() {
        Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))).isEqualTo(Optional.of(Booleans.TRUE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("both null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Reference((Type)BigintType.BIGINT, "x")))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")))).describedAs("non-constants", new Object[0])).isEqualTo(Optional.empty());
    }

    @Test
    void testLessThanOrEqual() {
        Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).isEqualTo(Optional.of(Booleans.TRUE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("both null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Reference((Type)BigintType.BIGINT, "x")))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")))).describedAs("non-constants", new Object[0])).isEqualTo(Optional.empty());
    }

    @Test
    void testGreaterThan() {
        Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).isEqualTo(Optional.of(Booleans.TRUE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("both null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Reference((Type)BigintType.BIGINT, "x")))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")))).describedAs("non-constants", new Object[0])).isEqualTo(Optional.empty());
    }

    @Test
    void testGreaterThanOrEqual() {
        Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).isEqualTo(Optional.of(Booleans.TRUE));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).describedAs("constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("both null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Reference((Type)BigintType.BIGINT, "x")))).describedAs("non-constant vs null", new Object[0])).isEqualTo(Optional.of(Booleans.NULL_BOOLEAN));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")))).describedAs("non-constants", new Object[0])).isEqualTo(Optional.empty());
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateComparison(TestingPlannerContext.PLANNER_CONTEXT).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

