/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.Metadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.ir.optimizer.rule.EvaluateIsNull;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEvaluateIsNull {
    @Test
    void test() {
        Assertions.assertThat(this.optimize((Expression)new IsNull((Expression)new Constant((Type)BigintType.BIGINT, null)))).isEqualTo(Optional.of(Booleans.TRUE));
        Assertions.assertThat(this.optimize((Expression)new IsNull((Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new IsNull((Expression)new Cast((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Type)IntegerType.INTEGER)))).isEqualTo(Optional.empty());
        Assertions.assertThat(this.optimize((Expression)new IsNull(IrExpressions.not((Metadata)TestingPlannerContext.PLANNER_CONTEXT.getMetadata(), (Expression)new Reference((Type)BooleanType.BOOLEAN, "a"))))).isEqualTo(Optional.of(new IsNull((Expression)new Reference((Type)BooleanType.BOOLEAN, "a"))));
        Assertions.assertThat(this.optimize((Expression)new IsNull((Expression)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "a"))))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new IsNull((Expression)new Row((List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a")))))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new IsNull((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isEqualTo(Optional.of(new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "b"))))));
        Assertions.assertThat(this.optimize((Expression)new IsNull((Expression)new Comparison(Comparison.Operator.IDENTICAL, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"))))).isEqualTo(Optional.of(Booleans.FALSE));
        Assertions.assertThat(this.optimize((Expression)new IsNull((Expression)new Reference((Type)BigintType.BIGINT, "a")))).isEqualTo(Optional.empty());
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateIsNull().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

