/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.NullIf;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.EvaluateNullIf;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;

public class TestEvaluateNullIf {
    @Test
    void test() {
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new NullIf((Expression)new Constant((Type)BigintType.BIGINT, null), (Expression)new Reference((Type)BigintType.BIGINT, "x")))).describedAs("first is null", new Object[0])).isEqualTo(Optional.of(new Constant((Type)BigintType.BIGINT, null)));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new NullIf((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Constant((Type)BigintType.BIGINT, null)))).describedAs("second is null", new Object[0])).isEqualTo(Optional.of(new Reference((Type)BigintType.BIGINT, "x")));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new NullIf((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "x")))).describedAs("equal deterministic expressions", new Object[0])).isEqualTo(Optional.empty());
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new NullIf((Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)))).describedAs("equal constants of different types", new Object[0])).isEqualTo(Optional.of(new Constant((Type)BigintType.BIGINT, null)));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new NullIf((Expression)new Constant((Type)BigintType.BIGINT, (Object)1L), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))).describedAs("different constants", new Object[0])).isEqualTo(Optional.of(new Constant((Type)BigintType.BIGINT, (Object)1L)));
        ((OptionalAssert)Assertions.assertThat(this.optimize((Expression)new NullIf((Expression)new Reference((Type)BigintType.BIGINT, "x"), (Expression)new Reference((Type)BigintType.BIGINT, "y")))).describedAs("different non-constants", new Object[0])).isEqualTo(Optional.empty());
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateNullIf(TestingPlannerContext.PLANNER_CONTEXT).apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

