/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.FlattenCoalesce;
import io.trino.testing.TestingSession;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFlattenCoalesce {
    @Test
    void test() {
        Assertions.assertThat(this.optimize((Expression)new Coalesce((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"), new Expression[0]), (Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Reference((Type)BigintType.BIGINT, "d"), new Expression[0]), new Expression[0]))).isEqualTo(Optional.of(new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"), new Expression[]{new Reference((Type)BigintType.BIGINT, "c"), new Reference((Type)BigintType.BIGINT, "d")})));
        Assertions.assertThat(this.optimize((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b"), new Expression[]{new Reference((Type)BigintType.BIGINT, "c"), new Reference((Type)BigintType.BIGINT, "d")}))).isEqualTo(Optional.empty());
    }

    private Optional<Expression> optimize(Expression expression) {
        return new FlattenCoalesce().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

