/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSymbolAllocator {
    @Test
    public void testUnique() {
        SymbolAllocator allocator = new SymbolAllocator();
        ImmutableSet symbols = ImmutableSet.builder().add((Object)allocator.newSymbol("foo_1_0", (Type)BigintType.BIGINT)).add((Object)allocator.newSymbol("foo", (Type)BigintType.BIGINT)).add((Object)allocator.newSymbol("foo", (Type)BigintType.BIGINT)).add((Object)allocator.newSymbol("foo", (Type)BigintType.BIGINT)).build();
        Assertions.assertThat((Collection)symbols).hasSize(4);
    }

    @Test
    public void testNonAscii() {
        SymbolAllocator allocator = new SymbolAllocator();
        ImmutableSet symbols = ImmutableSet.builder().add((Object)allocator.newSymbol("\u30ab\u30e9\u30e0", (Type)BigintType.BIGINT)).add((Object)allocator.newSymbol("col", (Type)BigintType.BIGINT)).build();
        Assertions.assertThat((Collection)symbols).containsExactlyInAnyOrder((Object[])new Symbol[]{new Symbol((Type)BigintType.BIGINT, "col"), new Symbol((Type)BigintType.BIGINT, "col_0")});
    }
}

