/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Between;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.IrExpressions;
import io.trino.sql.ir.IsNull;
import io.trino.sql.ir.Logical;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.rule.UnwrapYearInComparison;
import io.trino.type.DateTimes;
import io.trino.util.DateTimeUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUnwrapYearInComparison
extends BasePlanTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction RANDOM = FUNCTIONS.resolveFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
    private static final ResolvedFunction YEAR_DATE = FUNCTIONS.resolveFunction("year", TypeSignatureProvider.fromTypes((Type[])new Type[]{DateType.DATE}));
    private static final ResolvedFunction YEAR_TIMESTAMP_3 = FUNCTIONS.resolveFunction("year", TypeSignatureProvider.fromTypes((Type[])new Type[]{TimestampType.createTimestampType((int)3)}));

    @Test
    public void testEquals() {
        this.testUnwrap("date", "year(a) = -0001", (Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"-0001-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"-0001-12-31"))));
        this.testUnwrap("date", "year(a) = 1960", (Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1960-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1960-12-31"))));
        this.testUnwrap("date", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-12-31"))));
        this.testUnwrap("date", "year(a) = 9999", (Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"9999-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"9999-12-31"))));
        this.testUnwrap("timestamp", "year(a) = -0001", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"-0001-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"-0001-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp", "year(a) = 1960", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1960-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1960-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp", "year(a) = 9999", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"9999-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"9999-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp(0)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)0), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)0), DateTimes.parseTimestamp((int)0, (String)"2022-01-01 00:00:00")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)0), DateTimes.parseTimestamp((int)0, (String)"2022-12-31 23:59:59"))));
        this.testUnwrap("timestamp(1)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)1), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)1), DateTimes.parseTimestamp((int)1, (String)"2022-01-01 00:00:00.0")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)1), DateTimes.parseTimestamp((int)1, (String)"2022-12-31 23:59:59.9"))));
        this.testUnwrap("timestamp(2)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)2), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)2), DateTimes.parseTimestamp((int)2, (String)"2022-01-01 00:00:00.00")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)2), DateTimes.parseTimestamp((int)2, (String)"2022-12-31 23:59:59.99"))));
        this.testUnwrap("timestamp(3)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp(4)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)4), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)4), DateTimes.parseTimestamp((int)4, (String)"2022-01-01 00:00:00.0000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)4), DateTimes.parseTimestamp((int)4, (String)"2022-12-31 23:59:59.9999"))));
        this.testUnwrap("timestamp(5)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)5), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)5), DateTimes.parseTimestamp((int)5, (String)"2022-01-01 00:00:00.00000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)5), DateTimes.parseTimestamp((int)5, (String)"2022-12-31 23:59:59.99999"))));
        this.testUnwrap("timestamp(6)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)6), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)6), DateTimes.parseTimestamp((int)6, (String)"2022-01-01 00:00:00.000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)6), DateTimes.parseTimestamp((int)6, (String)"2022-12-31 23:59:59.999999"))));
        this.testUnwrap("timestamp(7)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)7), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)7), DateTimes.parseTimestamp((int)7, (String)"2022-01-01 00:00:00.0000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)7), DateTimes.parseTimestamp((int)7, (String)"2022-12-31 23:59:59.9999999"))));
        this.testUnwrap("timestamp(8)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)8), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)8), DateTimes.parseTimestamp((int)8, (String)"2022-01-01 00:00:00.00000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)8), DateTimes.parseTimestamp((int)8, (String)"2022-12-31 23:59:59.99999999"))));
        this.testUnwrap("timestamp(9)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)9), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2022-01-01 00:00:00.000000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2022-12-31 23:59:59.999999999"))));
        this.testUnwrap("timestamp(10)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)10), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)10), DateTimes.parseTimestamp((int)10, (String)"2022-01-01 00:00:00.0000000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)10), DateTimes.parseTimestamp((int)10, (String)"2022-12-31 23:59:59.9999999999"))));
        this.testUnwrap("timestamp(11)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)11), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)11), DateTimes.parseTimestamp((int)11, (String)"2022-01-01 00:00:00.00000000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)11), DateTimes.parseTimestamp((int)11, (String)"2022-12-31 23:59:59.99999999999"))));
        this.testUnwrap("timestamp(12)", "year(a) = 2022", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)12), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)12), DateTimes.parseTimestamp((int)12, (String)"2022-01-01 00:00:00.000000000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)12), DateTimes.parseTimestamp((int)12, (String)"2022-12-31 23:59:59.999999999999"))));
    }

    @Test
    public void testInPredicate() {
        this.testUnwrap("date", "year(a) IN (1000, 1400, 1800)", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1000-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1000-12-31"))), (Object)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1400-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1400-12-31"))), (Object)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1800-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1800-12-31"))))));
        this.testUnwrap("timestamp", "year(a) IN (1000, 1400, 1800)", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1000-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1000-12-31 23:59:59.999"))), (Object)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1400-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1400-12-31 23:59:59.999"))), (Object)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1800-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1800-12-31 23:59:59.999"))))));
    }

    @Test
    public void testNotEquals() {
        this.testUnwrap("date", "year(a) <> -0001", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"-0001-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"-0001-12-31")))));
        this.testUnwrap("date", "year(a) <> 1960", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1960-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1960-12-31")))));
        this.testUnwrap("date", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-12-31")))));
        this.testUnwrap("date", "year(a) <> 9999", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"9999-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"9999-12-31")))));
        this.testUnwrap("timestamp", "year(a) <> -0001", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"-0001-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"-0001-12-31 23:59:59.999")))));
        this.testUnwrap("timestamp", "year(a) <> 1960", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1960-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1960-12-31 23:59:59.999")))));
        this.testUnwrap("timestamp", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-12-31 23:59:59.999")))));
        this.testUnwrap("timestamp", "year(a) <> 9999", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"9999-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"9999-12-31 23:59:59.999")))));
        this.testUnwrap("timestamp(0)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)0), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)0), DateTimes.parseTimestamp((int)0, (String)"2022-01-01 00:00:00")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)0), DateTimes.parseTimestamp((int)0, (String)"2022-12-31 23:59:59")))));
        this.testUnwrap("timestamp(1)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)1), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)1), DateTimes.parseTimestamp((int)1, (String)"2022-01-01 00:00:00.0")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)1), DateTimes.parseTimestamp((int)1, (String)"2022-12-31 23:59:59.9")))));
        this.testUnwrap("timestamp(2)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)2), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)2), DateTimes.parseTimestamp((int)2, (String)"2022-01-01 00:00:00.00")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)2), DateTimes.parseTimestamp((int)2, (String)"2022-12-31 23:59:59.99")))));
        this.testUnwrap("timestamp(3)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-12-31 23:59:59.999")))));
        this.testUnwrap("timestamp(4)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)4), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)4), DateTimes.parseTimestamp((int)4, (String)"2022-01-01 00:00:00.0000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)4), DateTimes.parseTimestamp((int)4, (String)"2022-12-31 23:59:59.9999")))));
        this.testUnwrap("timestamp(5)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)5), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)5), DateTimes.parseTimestamp((int)5, (String)"2022-01-01 00:00:00.00000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)5), DateTimes.parseTimestamp((int)5, (String)"2022-12-31 23:59:59.99999")))));
        this.testUnwrap("timestamp(6)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)6), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)6), DateTimes.parseTimestamp((int)6, (String)"2022-01-01 00:00:00.000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)6), DateTimes.parseTimestamp((int)6, (String)"2022-12-31 23:59:59.999999")))));
        this.testUnwrap("timestamp(7)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)7), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)7), DateTimes.parseTimestamp((int)7, (String)"2022-01-01 00:00:00.0000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)7), DateTimes.parseTimestamp((int)7, (String)"2022-12-31 23:59:59.9999999")))));
        this.testUnwrap("timestamp(8)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)8), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)8), DateTimes.parseTimestamp((int)8, (String)"2022-01-01 00:00:00.00000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)8), DateTimes.parseTimestamp((int)8, (String)"2022-12-31 23:59:59.99999999")))));
        this.testUnwrap("timestamp(9)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)9), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2022-01-01 00:00:00.000000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2022-12-31 23:59:59.999999999")))));
        this.testUnwrap("timestamp(10)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)10), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)10), DateTimes.parseTimestamp((int)10, (String)"2022-01-01 00:00:00.0000000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)10), DateTimes.parseTimestamp((int)10, (String)"2022-12-31 23:59:59.9999999999")))));
        this.testUnwrap("timestamp(11)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)11), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)11), DateTimes.parseTimestamp((int)11, (String)"2022-01-01 00:00:00.00000000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)11), DateTimes.parseTimestamp((int)11, (String)"2022-12-31 23:59:59.99999999999")))));
        this.testUnwrap("timestamp(12)", "year(a) <> 2022", TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)12), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)12), DateTimes.parseTimestamp((int)12, (String)"2022-01-01 00:00:00.000000000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)12), DateTimes.parseTimestamp((int)12, (String)"2022-12-31 23:59:59.999999999999")))));
    }

    @Test
    public void testLessThan() {
        this.testUnwrap("date", "year(a) < -0001", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"-0001-01-01"))));
        this.testUnwrap("date", "year(a) < 1960", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1960-01-01"))));
        this.testUnwrap("date", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-01-01"))));
        this.testUnwrap("date", "year(a) < 9999", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"9999-01-01"))));
        this.testUnwrap("timestamp", "year(a) < -0001", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"-0001-01-01 00:00:00.000"))));
        this.testUnwrap("timestamp", "year(a) < 1960", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1960-01-01 00:00:00.000"))));
        this.testUnwrap("timestamp", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-01-01 00:00:00.000"))));
        this.testUnwrap("timestamp", "year(a) < 9999", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"9999-01-01 00:00:00.000"))));
        this.testUnwrap("timestamp(0)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)0), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)0), DateTimes.parseTimestamp((int)0, (String)"2022-01-01 00:00:00"))));
        this.testUnwrap("timestamp(1)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)1), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)1), DateTimes.parseTimestamp((int)1, (String)"2022-01-01 00:00:00.0"))));
        this.testUnwrap("timestamp(2)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)2), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)2), DateTimes.parseTimestamp((int)2, (String)"2022-01-01 00:00:00.00"))));
        this.testUnwrap("timestamp(3)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-01-01 00:00:00.000"))));
        this.testUnwrap("timestamp(4)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)4), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)4), DateTimes.parseTimestamp((int)4, (String)"2022-01-01 00:00:00.0000"))));
        this.testUnwrap("timestamp(5)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)5), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)5), DateTimes.parseTimestamp((int)5, (String)"2022-01-01 00:00:00.00000"))));
        this.testUnwrap("timestamp(6)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)6), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)6), DateTimes.parseTimestamp((int)6, (String)"2022-01-01 00:00:00.000000"))));
        this.testUnwrap("timestamp(7)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)7), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)7), DateTimes.parseTimestamp((int)7, (String)"2022-01-01 00:00:00.0000000"))));
        this.testUnwrap("timestamp(8)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)8), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)8), DateTimes.parseTimestamp((int)8, (String)"2022-01-01 00:00:00.00000000"))));
        this.testUnwrap("timestamp(9)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)9), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2022-01-01 00:00:00.000000000"))));
        this.testUnwrap("timestamp(10)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)10), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)10), DateTimes.parseTimestamp((int)10, (String)"2022-01-01 00:00:00.0000000000"))));
        this.testUnwrap("timestamp(11)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)11), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)11), DateTimes.parseTimestamp((int)11, (String)"2022-01-01 00:00:00.00000000000"))));
        this.testUnwrap("timestamp(12)", "year(a) < 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)12), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)12), DateTimes.parseTimestamp((int)12, (String)"2022-01-01 00:00:00.000000000000"))));
    }

    @Test
    public void testLessThanOrEqual() {
        this.testUnwrap("date", "year(a) <= -0001", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"-0001-12-31"))));
        this.testUnwrap("date", "year(a) <= 1960", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1960-12-31"))));
        this.testUnwrap("date", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-12-31"))));
        this.testUnwrap("date", "year(a) <= 9999", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"9999-12-31"))));
        this.testUnwrap("timestamp", "year(a) <= -0001", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"-0001-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp", "year(a) <= 1960", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1960-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp", "year(a) <= 9999", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"9999-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp(0)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)0), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)0), DateTimes.parseTimestamp((int)0, (String)"2022-12-31 23:59:59"))));
        this.testUnwrap("timestamp(1)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)1), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)1), DateTimes.parseTimestamp((int)1, (String)"2022-12-31 23:59:59.9"))));
        this.testUnwrap("timestamp(2)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)2), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)2), DateTimes.parseTimestamp((int)2, (String)"2022-12-31 23:59:59.99"))));
        this.testUnwrap("timestamp(3)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp(4)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)4), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)4), DateTimes.parseTimestamp((int)4, (String)"2022-12-31 23:59:59.9999"))));
        this.testUnwrap("timestamp(5)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)5), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)5), DateTimes.parseTimestamp((int)5, (String)"2022-12-31 23:59:59.99999"))));
        this.testUnwrap("timestamp(6)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)6), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)6), DateTimes.parseTimestamp((int)6, (String)"2022-12-31 23:59:59.999999"))));
        this.testUnwrap("timestamp(7)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)7), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)7), DateTimes.parseTimestamp((int)7, (String)"2022-12-31 23:59:59.9999999"))));
        this.testUnwrap("timestamp(8)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)8), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)8), DateTimes.parseTimestamp((int)8, (String)"2022-12-31 23:59:59.99999999"))));
        this.testUnwrap("timestamp(9)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)9), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2022-12-31 23:59:59.999999999"))));
        this.testUnwrap("timestamp(10)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)10), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)10), DateTimes.parseTimestamp((int)10, (String)"2022-12-31 23:59:59.9999999999"))));
        this.testUnwrap("timestamp(11)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)11), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)11), DateTimes.parseTimestamp((int)11, (String)"2022-12-31 23:59:59.99999999999"))));
        this.testUnwrap("timestamp(12)", "year(a) <= 2022", (Expression)new Comparison(Comparison.Operator.LESS_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)12), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)12), DateTimes.parseTimestamp((int)12, (String)"2022-12-31 23:59:59.999999999999"))));
    }

    @Test
    public void testGreaterThan() {
        this.testUnwrap("date", "year(a) > -0001", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"-0001-12-31"))));
        this.testUnwrap("date", "year(a) > 1960", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1960-12-31"))));
        this.testUnwrap("date", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-12-31"))));
        this.testUnwrap("date", "year(a) > 9999", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"9999-12-31"))));
        this.testUnwrap("timestamp", "year(a) > -0001", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"-0001-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp", "year(a) > 1960", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1960-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp", "year(a) > 9999", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"9999-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp(0)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)0), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)0), DateTimes.parseTimestamp((int)0, (String)"2022-12-31 23:59:59"))));
        this.testUnwrap("timestamp(1)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)1), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)1), DateTimes.parseTimestamp((int)1, (String)"2022-12-31 23:59:59.9"))));
        this.testUnwrap("timestamp(2)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)2), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)2), DateTimes.parseTimestamp((int)2, (String)"2022-12-31 23:59:59.99"))));
        this.testUnwrap("timestamp(3)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-12-31 23:59:59.999"))));
        this.testUnwrap("timestamp(4)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)4), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)4), DateTimes.parseTimestamp((int)4, (String)"2022-12-31 23:59:59.9999"))));
        this.testUnwrap("timestamp(5)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)5), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)5), DateTimes.parseTimestamp((int)5, (String)"2022-12-31 23:59:59.99999"))));
        this.testUnwrap("timestamp(6)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)6), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)6), DateTimes.parseTimestamp((int)6, (String)"2022-12-31 23:59:59.999999"))));
        this.testUnwrap("timestamp(7)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)7), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)7), DateTimes.parseTimestamp((int)7, (String)"2022-12-31 23:59:59.9999999"))));
        this.testUnwrap("timestamp(8)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)8), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)8), DateTimes.parseTimestamp((int)8, (String)"2022-12-31 23:59:59.99999999"))));
        this.testUnwrap("timestamp(9)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)9), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2022-12-31 23:59:59.999999999"))));
        this.testUnwrap("timestamp(10)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)10), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)10), DateTimes.parseTimestamp((int)10, (String)"2022-12-31 23:59:59.9999999999"))));
        this.testUnwrap("timestamp(11)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)11), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)11), DateTimes.parseTimestamp((int)11, (String)"2022-12-31 23:59:59.99999999999"))));
        this.testUnwrap("timestamp(12)", "year(a) > 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)TimestampType.createTimestampType((int)12), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)12), DateTimes.parseTimestamp((int)12, (String)"2022-12-31 23:59:59.999999999999"))));
    }

    @Test
    public void testGreaterThanOrEqual() {
        this.testUnwrap("date", "year(a) >= -0001", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"-0001-01-01"))));
        this.testUnwrap("date", "year(a) >= 1960", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1960-01-01"))));
        this.testUnwrap("date", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-01-01"))));
        this.testUnwrap("date", "year(a) >= 9999", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"9999-01-01"))));
        this.testUnwrap("timestamp", "year(a) >= -0001", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"-0001-01-01 00:00:00.000"))));
        this.testUnwrap("timestamp", "year(a) >= 1960", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1960-01-01 00:00:00.000"))));
        this.testUnwrap("timestamp", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-01-01 00:00:00.000"))));
        this.testUnwrap("timestamp", "year(a) >= 9999", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"9999-01-01 00:00:00.000"))));
        this.testUnwrap("timestamp(0)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)0), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)0), DateTimes.parseTimestamp((int)0, (String)"2022-01-01 00:00:00"))));
        this.testUnwrap("timestamp(1)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)1), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)1), DateTimes.parseTimestamp((int)1, (String)"2022-01-01 00:00:00.0"))));
        this.testUnwrap("timestamp(2)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)2), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)2), DateTimes.parseTimestamp((int)2, (String)"2022-01-01 00:00:00.00"))));
        this.testUnwrap("timestamp(3)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-01-01 00:00:00.000"))));
        this.testUnwrap("timestamp(4)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)4), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)4), DateTimes.parseTimestamp((int)4, (String)"2022-01-01 00:00:00.0000"))));
        this.testUnwrap("timestamp(5)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)5), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)5), DateTimes.parseTimestamp((int)5, (String)"2022-01-01 00:00:00.00000"))));
        this.testUnwrap("timestamp(6)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)6), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)6), DateTimes.parseTimestamp((int)6, (String)"2022-01-01 00:00:00.000000"))));
        this.testUnwrap("timestamp(7)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)7), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)7), DateTimes.parseTimestamp((int)7, (String)"2022-01-01 00:00:00.0000000"))));
        this.testUnwrap("timestamp(8)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)8), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)8), DateTimes.parseTimestamp((int)8, (String)"2022-01-01 00:00:00.00000000"))));
        this.testUnwrap("timestamp(9)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)9), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2022-01-01 00:00:00.000000000"))));
        this.testUnwrap("timestamp(10)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)10), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)10), DateTimes.parseTimestamp((int)10, (String)"2022-01-01 00:00:00.0000000000"))));
        this.testUnwrap("timestamp(11)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)11), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)11), DateTimes.parseTimestamp((int)11, (String)"2022-01-01 00:00:00.00000000000"))));
        this.testUnwrap("timestamp(12)", "year(a) >= 2022", (Expression)new Comparison(Comparison.Operator.GREATER_THAN_OR_EQUAL, (Expression)new Reference((Type)TimestampType.createTimestampType((int)12), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)12), DateTimes.parseTimestamp((int)12, (String)"2022-01-01 00:00:00.000000000000"))));
    }

    @Test
    public void testDistinctFrom() {
        this.testUnwrap("date", "year(a) IS DISTINCT FROM -0001", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)DateType.DATE, "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"-0001-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"-0001-12-31")))))));
        this.testUnwrap("date", "year(a) IS DISTINCT FROM 1960", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)DateType.DATE, "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1960-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"1960-12-31")))))));
        this.testUnwrap("date", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)DateType.DATE, "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-12-31")))))));
        this.testUnwrap("date", "year(a) IS DISTINCT FROM 9999", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)DateType.DATE, "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"9999-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"9999-12-31")))))));
        this.testUnwrap("timestamp", "year(a) IS DISTINCT FROM -0001", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"-0001-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"-0001-12-31 23:59:59.999")))))));
        this.testUnwrap("timestamp", "year(a) IS DISTINCT FROM 1960", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1960-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"1960-12-31 23:59:59.999")))))));
        this.testUnwrap("timestamp", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-12-31 23:59:59.999")))))));
        this.testUnwrap("timestamp", "year(a) IS DISTINCT FROM 9999", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"9999-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"9999-12-31 23:59:59.999")))))));
        this.testUnwrap("timestamp(0)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)0), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)0), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)0), DateTimes.parseTimestamp((int)0, (String)"2022-01-01 00:00:00")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)0), DateTimes.parseTimestamp((int)0, (String)"2022-12-31 23:59:59")))))));
        this.testUnwrap("timestamp(1)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)1), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)1), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)1), DateTimes.parseTimestamp((int)1, (String)"2022-01-01 00:00:00.0")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)1), DateTimes.parseTimestamp((int)1, (String)"2022-12-31 23:59:59.9")))))));
        this.testUnwrap("timestamp(2)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)2), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)2), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)2), DateTimes.parseTimestamp((int)2, (String)"2022-01-01 00:00:00.00")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)2), DateTimes.parseTimestamp((int)2, (String)"2022-12-31 23:59:59.99")))))));
        this.testUnwrap("timestamp(3)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2022-12-31 23:59:59.999")))))));
        this.testUnwrap("timestamp(4)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)4), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)4), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)4), DateTimes.parseTimestamp((int)4, (String)"2022-01-01 00:00:00.0000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)4), DateTimes.parseTimestamp((int)4, (String)"2022-12-31 23:59:59.9999")))))));
        this.testUnwrap("timestamp(5)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)5), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)5), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)5), DateTimes.parseTimestamp((int)5, (String)"2022-01-01 00:00:00.00000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)5), DateTimes.parseTimestamp((int)5, (String)"2022-12-31 23:59:59.99999")))))));
        this.testUnwrap("timestamp(6)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)6), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)6), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)6), DateTimes.parseTimestamp((int)6, (String)"2022-01-01 00:00:00.000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)6), DateTimes.parseTimestamp((int)6, (String)"2022-12-31 23:59:59.999999")))))));
        this.testUnwrap("timestamp(7)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)7), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)7), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)7), DateTimes.parseTimestamp((int)7, (String)"2022-01-01 00:00:00.0000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)7), DateTimes.parseTimestamp((int)7, (String)"2022-12-31 23:59:59.9999999")))))));
        this.testUnwrap("timestamp(8)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)8), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)8), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)8), DateTimes.parseTimestamp((int)8, (String)"2022-01-01 00:00:00.00000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)8), DateTimes.parseTimestamp((int)8, (String)"2022-12-31 23:59:59.99999999")))))));
        this.testUnwrap("timestamp(9)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)9), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)9), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2022-01-01 00:00:00.000000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)9), DateTimes.parseTimestamp((int)9, (String)"2022-12-31 23:59:59.999999999")))))));
        this.testUnwrap("timestamp(10)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)10), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)10), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)10), DateTimes.parseTimestamp((int)10, (String)"2022-01-01 00:00:00.0000000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)10), DateTimes.parseTimestamp((int)10, (String)"2022-12-31 23:59:59.9999999999")))))));
        this.testUnwrap("timestamp(11)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)11), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)11), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)11), DateTimes.parseTimestamp((int)11, (String)"2022-01-01 00:00:00.00000000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)11), DateTimes.parseTimestamp((int)11, (String)"2022-12-31 23:59:59.99999999999")))))));
        this.testUnwrap("timestamp(12)", "year(a) IS DISTINCT FROM 2022", (Expression)new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)new IsNull((Expression)new Reference((Type)TimestampType.createTimestampType((int)12), "a")), (Object)TestUnwrapYearInComparison.not((Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)12), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)12), DateTimes.parseTimestamp((int)12, (String)"2022-01-01 00:00:00.000000000000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)12), DateTimes.parseTimestamp((int)12, (String)"2022-12-31 23:59:59.999999999999")))))));
    }

    @Test
    public void testNull() {
        this.testUnwrap("date", "year(a) = CAST(NULL AS BIGINT)", (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
        this.testUnwrap("timestamp", "year(a) = CAST(NULL AS BIGINT)", (Expression)new Constant((Type)BooleanType.BOOLEAN, null));
    }

    @Test
    public void testNaN() {
        this.testUnwrap("date", "year(a) = nan()", (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new IsNull((Expression)new Call(YEAR_DATE, (List)ImmutableList.of((Object)new Reference((Type)DateType.DATE, "a")))), (Object)new Constant((Type)BooleanType.BOOLEAN, null))));
        this.testUnwrap("timestamp", "year(a) = nan()", (Expression)new Logical(Logical.Operator.AND, (List)ImmutableList.of((Object)new IsNull((Expression)new Call(YEAR_TIMESTAMP_3, (List)ImmutableList.of((Object)new Reference((Type)TimestampType.createTimestampType((int)3), "a")))), (Object)new Constant((Type)BooleanType.BOOLEAN, null))));
    }

    @Test
    public void smokeTests() {
        for (String type : Arrays.asList("SMALLINT", "INTEGER", "BIGINT", "REAL", "DOUBLE")) {
            this.testUnwrap("date", String.format("year(a) = %s '2022'", type), (Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-12-31"))));
        }
    }

    @Test
    public void testTermOrder() {
        this.assertPlan("SELECT * FROM (VALUES DATE '2022-01-01') t(a) WHERE 2022 = year(a)", Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("push_filter_into_values_max_row_count", "0").build(), PlanMatchPattern.output(PlanMatchPattern.filter((Expression)new Between((Expression)new Reference((Type)DateType.DATE, "A"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2022-12-31"))), PlanMatchPattern.values("A"))));
    }

    @Test
    public void testLeapYear() {
        this.testUnwrap("date", "year(a) = 2024", (Expression)new Between((Expression)new Reference((Type)DateType.DATE, "a"), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2024-01-01")), (Expression)new Constant((Type)DateType.DATE, (Object)DateTimeUtils.parseDate((String)"2024-12-31"))));
        this.testUnwrap("timestamp", "year(a) = 2024", (Expression)new Between((Expression)new Reference((Type)TimestampType.createTimestampType((int)3), "a"), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2024-01-01 00:00:00.000")), (Expression)new Constant((Type)TimestampType.createTimestampType((int)3), DateTimes.parseTimestamp((int)3, (String)"2024-12-31 23:59:59.999"))));
    }

    @Test
    public void testCalculateRangeEndInclusive() {
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)DateType.DATE)).isEqualTo((Object)LocalDate.of(1960, 12, 31).toEpochDay());
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)DateType.DATE)).isEqualTo((Object)LocalDate.of(2024, 12, 31).toEpochDay());
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_SECONDS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_MILLIS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59, 999000000)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_MICROS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59, 999999000)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_NANOS)).isEqualTo((Object)new LongTimestamp(TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59, 999999000)), 999000));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)1960, (Type)TimestampType.TIMESTAMP_PICOS)).isEqualTo((Object)new LongTimestamp(TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(1960, 12, 31, 23, 59, 59, 999999000)), 999999));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_SECONDS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_MILLIS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59, 999000000)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_MICROS)).isEqualTo((Object)TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59, 999999000)));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_NANOS)).isEqualTo((Object)new LongTimestamp(TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59, 999999000)), 999000));
        Assertions.assertThat((Object)UnwrapYearInComparison.calculateRangeEndInclusive((int)2024, (Type)TimestampType.TIMESTAMP_PICOS)).isEqualTo((Object)new LongTimestamp(TestUnwrapYearInComparison.toEpochMicros(LocalDateTime.of(2024, 12, 31, 23, 59, 59, 999999000)), 999999));
    }

    private static long toEpochMicros(LocalDateTime localDateTime) {
        return Math.multiplyExact(localDateTime.toEpochSecond(ZoneOffset.UTC), 1000000) + (long)(localDateTime.getNano() / 1000);
    }

    private void testUnwrap(String inputType, String inputPredicate, Expression expected) {
        Logical logical;
        Comparison antiOptimization = new Comparison(Comparison.Operator.EQUAL, (Expression)new Call(RANDOM, (List)ImmutableList.of()), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)42.0));
        expected = expected instanceof Logical && (logical = (Logical)expected).operator() == Logical.Operator.OR ? new Logical(Logical.Operator.OR, (List)ImmutableList.builder().addAll((Iterable)logical.terms()).add((Object)antiOptimization).build()) : new Logical(Logical.Operator.OR, (List)ImmutableList.of((Object)expected, (Object)antiOptimization));
        String sql = String.format("SELECT * FROM (VALUES CAST(NULL AS %s)) t(a) WHERE %s OR rand() = 42", inputType, inputPredicate);
        try {
            this.assertPlan(sql, this.getPlanTester().getDefaultSession(), PlanMatchPattern.output(PlanMatchPattern.filter(expected, PlanMatchPattern.values("a"))));
        }
        catch (Throwable e) {
            e.addSuppressed(new Exception("Query: " + sql));
            throw e;
        }
    }

    private static Expression not(Expression value) {
        return IrExpressions.not((Metadata)FUNCTIONS.getMetadata(), (Expression)value);
    }
}

