/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.Session;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.RvalueMatcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.assertions.WindowFrameMatcher;
import io.trino.sql.planner.assertions.WindowFunction;
import io.trino.sql.planner.plan.PatternRecognitionNode;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.WindowNode;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class WindowFunctionMatcher
implements RvalueMatcher {
    private final ExpectedValueProvider<WindowFunction> callMaker;

    public WindowFunctionMatcher(ExpectedValueProvider<WindowFunction> callMaker) {
        this.callMaker = Objects.requireNonNull(callMaker, "callMaker is null");
    }

    @Override
    public Optional<Symbol> getAssignedSymbol(PlanNode node, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Map assignments;
        Optional<Symbol> result = Optional.empty();
        if (node instanceof WindowNode) {
            assignments = ((WindowNode)node).getWindowFunctions();
        } else if (node instanceof PatternRecognitionNode) {
            assignments = ((PatternRecognitionNode)node).getWindowFunctions();
        } else {
            return result;
        }
        WindowFunction expectedCall = this.callMaker.getExpectedValue(symbolAliases);
        for (Map.Entry assignment : assignments.entrySet()) {
            WindowNode.Function function = (WindowNode.Function)assignment.getValue();
            if (!this.windowFunctionMatches(function, expectedCall, symbolAliases)) continue;
            Preconditions.checkState((boolean)result.isEmpty(), (String)"Ambiguous function calls in %s", (Object)node);
            result = Optional.of((Symbol)assignment.getKey());
        }
        return result;
    }

    private boolean windowFunctionMatches(WindowNode.Function windowFunction, WindowFunction expectedCall, SymbolAliases aliases) {
        return expectedCall.name().equals(windowFunction.getResolvedFunction().signature().getName().getFunctionName()) && WindowFrameMatcher.matches(expectedCall.frame(), windowFunction.getFrame(), aliases) && Objects.equals(expectedCall.orderingScheme(), windowFunction.getOrderingScheme()) && expectedCall.arguments().equals(windowFunction.getArguments());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("callMaker", this.callMaker).toString();
    }
}

