/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestMetadataManager;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.connector.SortOrder;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.OrderingScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.MergePatternRecognitionNodes;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.FrameBoundType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.RowsPerMatch;
import io.trino.sql.planner.plan.SkipToPosition;
import io.trino.sql.planner.plan.WindowFrameType;
import io.trino.sql.planner.plan.WindowNode;
import io.trino.sql.planner.rowpattern.AggregatedSetDescriptor;
import io.trino.sql.planner.rowpattern.AggregationValuePointer;
import io.trino.sql.planner.rowpattern.LogicalIndexPointer;
import io.trino.sql.planner.rowpattern.MatchNumberValuePointer;
import io.trino.sql.planner.rowpattern.ScalarValuePointer;
import io.trino.sql.planner.rowpattern.ValuePointer;
import io.trino.sql.planner.rowpattern.ir.IrLabel;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.type.UnknownType;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestMergePatternRecognitionNodes
extends BaseRuleTest {
    private static final TestingFunctionResolution FUNCTIONS = new TestingFunctionResolution();
    private static final ResolvedFunction ADD_BIGINT = FUNCTIONS.resolveOperator(OperatorType.ADD, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final ResolvedFunction MULTIPLY_BIGINT = FUNCTIONS.resolveOperator(OperatorType.MULTIPLY, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
    private static final WindowNode.Frame ROWS_CURRENT_TO_UNBOUNDED = new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty());

    public TestMergePatternRecognitionNodes() {
        super(new Plugin[0]);
    }

    @Test
    public void testSpecificationsDoNotMatch() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.FALSE).source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("a")}), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.FALSE).source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
        ResolvedFunction count = this.tester().getMetadata().resolveBuiltinFunction("count", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Call(count, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L))).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Call(count, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L))).source((PlanNode)p.values(p.symbol("a"), p.symbol("b", (Type)IntegerType.INTEGER))))))).doesNotFire();
    }

    @Test
    public void testParentDependsOnSourceCreatedOutputs() {
        ResolvedFunction lag = TestMetadataManager.createTestMetadataManager().resolveBuiltinFunction("lag", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "measure")))).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new MatchNumberValuePointer())).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "function")))).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.addWindowFunction(p.symbol("function"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("a").toSymbolReference()), Optional.empty(), WindowNode.Frame.DEFAULT_FRAME, false, false)).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addWindowFunction(p.symbol("dependent"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("function").toSymbolReference()), Optional.empty(), WindowNode.Frame.DEFAULT_FRAME, false, false)).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.addWindowFunction(p.symbol("function"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("a").toSymbolReference()), Optional.empty(), WindowNode.Frame.DEFAULT_FRAME, false, false)).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addWindowFunction(p.symbol("dependent"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("measure").toSymbolReference()), Optional.empty(), WindowNode.Frame.DEFAULT_FRAME, false, false)).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new MatchNumberValuePointer())).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a"))))))).doesNotFire();
    }

    @Test
    public void testParentDependsOnSourceCreatedOutputsWithProject() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "measure")))).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{p.symbol("measure")}), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new MatchNumberValuePointer())).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "renamed")))).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.project(Assignments.of((Symbol)p.symbol("renamed"), (Expression)new Reference((Type)BigintType.BIGINT, "measure")), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new MatchNumberValuePointer())).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("dependent"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "projected")))).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.project(Assignments.of((Symbol)p.symbol("projected"), (Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "measure")))), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new MatchNumberValuePointer())).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a")))))))).doesNotFire();
    }

    @Test
    public void testMergeWithoutProject() {
        ResolvedFunction lag = TestMetadataManager.createTestMetadataManager().resolveBuiltinFunction("lag", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("c"))).orderBy(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("d")), (Map)ImmutableMap.of((Object)p.symbol("d"), (Object)SortOrder.ASC_NULLS_LAST))).addMeasure(p.symbol("parent_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "b")))).addWindowFunction(p.symbol("parent_function"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("a").toSymbolReference()), Optional.empty(), WindowNode.Frame.DEFAULT_FRAME, false, false)).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).skipTo(SkipToPosition.LAST, (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).seek().addSubset(new IrLabel("U"), (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("c"))).orderBy(new OrderingScheme((List)ImmutableList.of((Object)p.symbol("d")), (Map)ImmutableMap.of((Object)p.symbol("d"), (Object)SortOrder.ASC_NULLS_LAST))).addMeasure(p.symbol("child_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "a")))).addWindowFunction(p.symbol("child_function"), new WindowNode.Function(lag, (List)ImmutableList.of((Object)p.symbol("b").toSymbolReference()), Optional.empty(), WindowNode.Frame.DEFAULT_FRAME, false, false)).rowsPerMatch(RowsPerMatch.WINDOW).frame(new WindowNode.Frame(WindowFrameType.ROWS, FrameBoundType.CURRENT_ROW, Optional.empty(), Optional.empty(), FrameBoundType.UNBOUNDED_FOLLOWING, Optional.empty(), Optional.empty())).skipTo(SkipToPosition.LAST, (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).seek().addSubset(new IrLabel("U"), (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"), p.symbol("c"), p.symbol("d"))))))).matches(PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of((Object)"d"), (Map<String, SortOrder>)ImmutableMap.of((Object)"d", (Object)SortOrder.ASC_NULLS_LAST))).addMeasure("parent_measure", (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "b"))), (Type)BigintType.BIGINT).addMeasure("child_measure", (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "a"))), (Type)BigintType.BIGINT).addFunction("parent_function", PlanMatchPattern.windowFunction("lag", (List<String>)ImmutableList.of((Object)"a"), WindowNode.Frame.DEFAULT_FRAME)).addFunction("child_function", PlanMatchPattern.windowFunction("lag", (List<String>)ImmutableList.of((Object)"b"), WindowNode.Frame.DEFAULT_FRAME)).rowsPerMatch(RowsPerMatch.WINDOW).frame(ROWS_CURRENT_TO_UNBOUNDED).skipTo(SkipToPosition.LAST, new IrLabel("X")).seek().addSubset(new IrLabel("U"), (Set<IrLabel>)ImmutableSet.of((Object)new IrLabel("X"))).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE), PlanMatchPattern.values("a", "b", "c", "d")));
    }

    @Test
    public void testMergeWithoutProjectAndPruneOutputs() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("c"))).addMeasure(p.symbol("parent_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "b")))).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("c"))).addMeasure(p.symbol("child_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "a")))).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"), p.symbol("c"))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"c", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "c")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "parent_measure"))), PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"c"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addMeasure("parent_measure", (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "b"))), (Type)BigintType.BIGINT).addMeasure("child_measure", (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "a"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE), PlanMatchPattern.values("a", "b", "c"))));
    }

    @Test
    public void testMergeWithProject() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("parent_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "a")))).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Symbol)p.symbol("expression"), (Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b")))), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("child_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "b")))).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "parent_measure")), (Object)"expression", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "expression"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "parent_measure")), (Object)"child_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "child_measure")), (Object)"expression", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"))))), PlanMatchPattern.patternRecognition(builder -> builder.addMeasure("parent_measure", (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "a"))), (Type)BigintType.BIGINT).addMeasure("child_measure", (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE), PlanMatchPattern.values("a", "b")))));
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("parent_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "a")))).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.project(Assignments.of((Symbol)p.symbol("a"), (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Symbol)p.symbol("expression"), (Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"))), (Object)new Reference((Type)BigintType.BIGINT, "child_measure")))), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("child_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "b")))).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "parent_measure")), (Object)"expression", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "expression"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "parent_measure")), (Object)"child_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "child_measure")), (Object)"expression", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"))), (Object)new Reference((Type)BigintType.BIGINT, "child_measure"))))), PlanMatchPattern.patternRecognition(builder -> builder.addMeasure("parent_measure", (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "a"))), (Type)BigintType.BIGINT).addMeasure("child_measure", (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE), PlanMatchPattern.values("a", "b")))));
    }

    @Test
    public void testMergeWithParentDependingOnProject() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.addMeasure(p.symbol("parent_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "expression_1")))).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.project(Assignments.builder().put(p.symbol("a"), (Expression)new Reference((Type)BigintType.BIGINT, "a")).put(p.symbol("expression_1"), (Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b")))).put(p.symbol("expression_2"), (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b")))).build(), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.addMeasure(p.symbol("child_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "b")))).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "parent_measure")), (Object)"expression_1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "expression_1")), (Object)"expression_2", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "expression_2"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.builder().put((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a"))).put((Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b"))).put((Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "parent_measure"))).put((Object)"child_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "child_measure"))).put((Object)"expression_1", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "expression_1"))).put((Object)"expression_2", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"))))).buildOrThrow(), PlanMatchPattern.patternRecognition(builder -> builder.addMeasure("parent_measure", (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "expression_1"))), (Type)BigintType.BIGINT).addMeasure("child_measure", (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ALL_SHOW_EMPTY).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b")), (Object)"expression_1", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "b"))))), PlanMatchPattern.values("a", "b"))))));
    }

    @Test
    public void testOneRowPerMatchMergeWithParentDependingOnProject() {
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("a"))).addMeasure(p.symbol("parent_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "expression_1")))).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.project(Assignments.builder().put(p.symbol("a"), (Expression)new Reference((Type)BigintType.BIGINT, "a")).put(p.symbol("child_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "child_measure")).put(p.symbol("expression_1"), (Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "a")))).put(p.symbol("expression_2"), (Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "a")))).build(), (PlanNode)p.patternRecognition(childBuilder -> childBuilder.partitionBy((List<Symbol>)ImmutableList.of((Object)p.symbol("a"))).addMeasure(p.symbol("child_measure"), (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol((Type)BigintType.BIGINT, "b")))).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE).source((PlanNode)p.values(p.symbol("a"), p.symbol("b")))))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "parent_measure"))), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"parent_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "parent_measure")), (Object)"child_measure", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "child_measure")), (Object)"expression_2", (Object)PlanMatchPattern.expression((Expression)new Call(ADD_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "a"))))), PlanMatchPattern.patternRecognition(builder -> builder.specification(PlanMatchPattern.specification((List<String>)ImmutableList.of((Object)"a"), (List<String>)ImmutableList.of(), (Map<String, SortOrder>)ImmutableMap.of())).addMeasure("parent_measure", (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), true, true, 0, 0), new Symbol((Type)UnknownType.UNKNOWN, "expression_1"))), (Type)BigintType.BIGINT).addMeasure("child_measure", (Expression)new Reference((Type)BigintType.BIGINT, "pointer"), (Map<String, ValuePointer>)ImmutableMap.of((Object)"pointer", (Object)new ScalarValuePointer(new LogicalIndexPointer((Set)ImmutableSet.of((Object)new IrLabel("X")), false, true, 0, 0), new Symbol((Type)UnknownType.UNKNOWN, "b"))), (Type)BigintType.BIGINT).rowsPerMatch(RowsPerMatch.ONE).pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)Booleans.TRUE), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"a", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "a")), (Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b")), (Object)"expression_1", (Object)PlanMatchPattern.expression((Expression)new Call(MULTIPLY_BIGINT, (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"), (Object)new Reference((Type)BigintType.BIGINT, "a"))))), PlanMatchPattern.values("a", "b"))))));
    }

    @Test
    public void testMergeWithAggregation() {
        ResolvedFunction count = this.tester().getMetadata().resolveBuiltinFunction("count", TypeSignatureProvider.fromTypes((Type[])new Type[]{BigintType.BIGINT}));
        this.tester().assertThat((Rule<?>)new MergePatternRecognitionNodes.MergePatternRecognitionNodesWithoutProject()).on(p -> p.patternRecognition(parentBuilder -> parentBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Map<Symbol, ValuePointer>)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "c"), (Object)new AggregationValuePointer(count, new AggregatedSetDescriptor((Set)ImmutableSet.of(), true), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a")), Optional.empty(), Optional.empty()))).source((PlanNode)p.patternRecognition(childBuilder -> childBuilder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Map<Symbol, ValuePointer>)ImmutableMap.of((Object)new Symbol((Type)BigintType.BIGINT, "c"), (Object)new AggregationValuePointer(count, new AggregatedSetDescriptor((Set)ImmutableSet.of(), true), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a")), Optional.empty(), Optional.empty()))).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT))))))).matches(PlanMatchPattern.patternRecognition(builder -> builder.pattern((IrRowPattern)new IrLabel("X")).addVariableDefinition(new IrLabel("X"), (Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "c"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Map<String, ValuePointer>)ImmutableMap.of((Object)"c", (Object)new AggregationValuePointer(count, new AggregatedSetDescriptor((Set)ImmutableSet.of(), true), (List)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a")), Optional.empty(), Optional.empty()))), PlanMatchPattern.values("a")));
    }
}

