/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.cost.TaskCountEstimator;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Coalesce;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationFunction;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.assertions.PlanTestSymbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.OptimizeMixedDistinctAggregations;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.iterative.rule.test.PlanBuilder;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestOptimizeMixedDistinctAggregations
extends BaseRuleTest {
    private static final int NODES_COUNT = 4;
    private static final TaskCountEstimator TASK_COUNT_ESTIMATOR = new TaskCountEstimator(() -> 4);

    public TestOptimizeMixedDistinctAggregations() {
        super(new Plugin[0]);
    }

    @Test
    public void testGlobalWithNonDistinct() {
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"b")), "group_id", PlanMatchPattern.values("a", "b"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"gid-filter-2", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"b"), (Object)ImmutableList.of((Object)"c")), "group_id", PlanMatchPattern.values("a", "b", "c"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct3", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2"), (Object)"distinct3-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"gid-filter-2", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"b"), (Object)ImmutableList.of((Object)"c")), "group_id", PlanMatchPattern.values("a", "b", "c"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("non-distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "d"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT), p.symbol("d", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct1")), "gid-filter-0"), (Object)"non-distinct2-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct2")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"gid-filter-2", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), (Object)"non-distinct2", PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"d"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"d"), (Object)ImmutableList.of((Object)"b"), (Object)ImmutableList.of((Object)"c")), "group_id", PlanMatchPattern.values("a", "b", "c", "d"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("non-distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct1")), "gid-filter-0"), (Object)"non-distinct2-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct2")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"gid-filter-2", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), (Object)"non-distinct2", PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"b"), (Object)ImmutableList.of((Object)"c")), "group_id", PlanMatchPattern.values("a", "b", "c"))))));
    }

    @Test
    public void testDistinctAggregationsAndNonDistinctAggregationsOnTheSameInput() {
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("non-distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct1")), "gid-filter-0"), (Object)"non-distinct2-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct2")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("a")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("a")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("a", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a-non-distinct")), (Object)"non-distinct2", PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"a-non-distinct"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a-non-distinct"), (Object)ImmutableList.of((Object)"a")), (Map<String, String>)ImmutableMap.of((Object)"a-non-distinct", (Object)"a"), (List<String>)ImmutableList.of(), "group_id", PlanMatchPattern.values("a"))))));
    }

    @Test
    public void testNonDistinctWith0OnEmptyInput() {
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non-distinct-final", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "non-distinct-expression"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0]))), PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-expression", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"b")), "group_id", PlanMatchPattern.values("a", "b")))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey", (Type)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non-distinct-final", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "non-distinct-expression"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0]))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-expression", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey", "b", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey")), "group_id", PlanMatchPattern.values("a", "b", "groupingKey")))))));
    }

    @Test
    public void testGlobalWithoutNonDistinct() {
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("b", (Type)BigintType.BIGINT))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-0"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"b"), (Object)ImmutableList.of((Object)"c")), "group_id", PlanMatchPattern.values("b", "c"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct3", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-0"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-1"), (Object)"distinct3-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"b"), (Object)ImmutableList.of((Object)"c")), "group_id", PlanMatchPattern.values("b", "c"))))));
    }

    @Test
    public void testDistinctOnNestedType() {
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol nested = p.symbol("nested", (Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}));
            builder.globalGrouping().addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)a.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)nested.toSymbolReference())), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(a, nested));
        })).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("nested")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("nested", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"nested")), "group_id", PlanMatchPattern.values("a", "nested"))))));
    }

    @Test
    public void testNonDistinctWithoutArgument() {
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("b", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"non-distinct-final", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "non-distinct-expression"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0]))), PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-expression", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of())), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of(), (Object)ImmutableList.of((Object)"b")), "group_id", PlanMatchPattern.values("b")))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("count", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of()), (List<Type>)ImmutableList.of()).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"count-final", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "count-expression"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0])), (Object)"non-distinct-final", (Object)PlanMatchPattern.expression((Expression)new Coalesce((Expression)new Reference((Type)BigintType.BIGINT, "non-distinct-expression"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L), new Expression[0]))), PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count-expression", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("count")), "gid-filter-0"), (Object)"non-distinct-expression", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"count", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of()), (Object)"non-distinct", PlanMatchPattern.aggregationFunction("count", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"b")), "group_id", PlanMatchPattern.values("a", "b")))))));
    }

    @Test
    public void testGroupByOneColumnWithNonDistinct() {
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey", (Type)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey", (Type)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey", "b", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey")), "group_id", PlanMatchPattern.values("a", "b", "groupingKey"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey", (Type)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"gid-filter-2", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey", "b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"c", (Object)"groupingKey")), "group_id", PlanMatchPattern.values("a", "b", "c", "groupingKey"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey", (Type)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct3", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2"), (Object)"distinct3-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"gid-filter-2", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey", "b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"c", (Object)"groupingKey")), "group_id", PlanMatchPattern.values("a", "b", "c", "groupingKey"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey", (Type)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "d"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT), p.symbol("d", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct1")), "gid-filter-0"), (Object)"non-distinct2-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct2")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"gid-filter-2", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey", "b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), (Object)"non-distinct2", PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"d"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"d", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"c", (Object)"groupingKey")), "group_id", PlanMatchPattern.values("a", "b", "c", "d", "groupingKey"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey", (Type)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct1")), "gid-filter-0"), (Object)"non-distinct2-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct2")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"gid-filter-2", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey", "b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), (Object)"non-distinct2", PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"c", (Object)"groupingKey")), "group_id", PlanMatchPattern.values("a", "b", "c", "groupingKey"))))));
    }

    @Test
    public void testGroupByOneColumnWithoutNonDistinct() {
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey", (Type)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("b", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey", (Type)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-0"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey", "b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"b", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"c", (Object)"groupingKey")), "group_id", PlanMatchPattern.values("b", "c", "groupingKey"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey", (Type)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct3", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-0"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-1"), (Object)"distinct3-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey", "b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of(), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"b", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"c", (Object)"groupingKey")), "group_id", PlanMatchPattern.values("b", "c", "groupingKey"))))));
    }

    @Test
    public void testGroupByMultipleColumnWithNonDistinct() {
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey1", "groupingKey2"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey1", "groupingKey2", "b", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"groupingKey1", (Object)"groupingKey2"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey1", (Object)"groupingKey2")), "group_id", PlanMatchPattern.values("a", "b", "groupingKey1", "groupingKey2"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT), p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey1", "groupingKey2"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"gid-filter-2", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey1", "groupingKey2", "b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"groupingKey1", (Object)"groupingKey2"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey1", (Object)"groupingKey2"), (Object)ImmutableList.of((Object)"c", (Object)"groupingKey1", (Object)"groupingKey2")), "group_id", PlanMatchPattern.values("a", "b", "c", "groupingKey1", "groupingKey2"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct3", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT), p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey1", "groupingKey2"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2"), (Object)"distinct3-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"gid-filter-2", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey1", "groupingKey2", "b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"groupingKey1", (Object)"groupingKey2"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey1", (Object)"groupingKey2"), (Object)ImmutableList.of((Object)"c", (Object)"groupingKey1", (Object)"groupingKey2")), "group_id", PlanMatchPattern.values("a", "b", "c", "groupingKey1", "groupingKey2"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2")).addAggregation(p.symbol("non-distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "d"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT), p.symbol("d", (Type)BigintType.BIGINT), p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey1", "groupingKey2"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct1")), "gid-filter-0"), (Object)"non-distinct2-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct2")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"gid-filter-2", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey1", "groupingKey2", "b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), (Object)"non-distinct2", PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"d"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"d", (Object)"groupingKey1", (Object)"groupingKey2"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey1", (Object)"groupingKey2"), (Object)ImmutableList.of((Object)"c", (Object)"groupingKey1", (Object)"groupingKey2")), "group_id", PlanMatchPattern.values("a", "b", "c", "d", "groupingKey1", "groupingKey2"))))));
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "pre_aggregate").on(p -> p.aggregation(builder -> builder.singleGroupingSet(p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("non-distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("avg", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct1", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct2", (Type)BigintType.BIGINT), PlanBuilder.aggregation("count", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "c"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("c", (Type)BigintType.BIGINT), p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey1", "groupingKey2"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct1")), "gid-filter-0"), (Object)"non-distinct2-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct2")), "gid-filter-0"), (Object)"distinct1-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1"), (Object)"distinct2-final", PlanMatchPattern.aggregationFunction("count", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("c")), "gid-filter-2")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L))), (Object)"gid-filter-2", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)2L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey1", "groupingKey2", "b", "c", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct1", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a")), (Object)"non-distinct2", PlanMatchPattern.aggregationFunction("avg", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"groupingKey1", (Object)"groupingKey2"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey1", (Object)"groupingKey2"), (Object)ImmutableList.of((Object)"c", (Object)"groupingKey1", (Object)"groupingKey2")), "group_id", PlanMatchPattern.values("a", "b", "c", "groupingKey1", "groupingKey2"))))));
    }

    @Test
    public void testAutomaticDecisionForGlobal() {
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "automatic").on(p -> p.aggregation(builder -> builder.globalGrouping().addAggregation(p.symbol("non-distinct"), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct"), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a"), p.symbol("b"))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.globalAggregation(), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("b", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a"), (Object)ImmutableList.of((Object)"b")), "group_id", PlanMatchPattern.values("a", "b"))))));
    }

    @Test
    public void testAutomaticDecisionForSingleGroupByKeyWithLowCardinality() {
        int clusterThreadCount = 4 * (Integer)this.tester().getSession().getSystemProperty("task_concurrency", Integer.class);
        PlanNodeId aggregationSourceId = new PlanNodeId("aggregationSourceId");
        Symbol groupingKey = new Symbol((Type)BigintType.BIGINT, "groupingKey");
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId.toString(), PlanNodeStatsEstimate.builder().addSymbolStatistics(groupingKey, SymbolStatsEstimate.builder().setDistinctValuesCount((double)(2 * clusterThreadCount)).build()).build()).on(p -> p.aggregation(builder -> builder.singleGroupingSet(groupingKey).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(aggregationSourceId, p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey", "b", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey")), "group_id", PlanMatchPattern.values("a", "b", "groupingKey"))))));
    }

    @Test
    public void testAutomaticDecisionWithUnknownStats() {
        PlanNodeId aggregationSourceId = new PlanNodeId("aggregationSourceId");
        Symbol groupingKey = new Symbol((Type)BigintType.BIGINT, "groupingKey");
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId.toString(), PlanNodeStatsEstimate.builder().addSymbolStatistics(groupingKey, SymbolStatsEstimate.builder().setDistinctValuesCount(Double.NaN).build()).build()).on(p -> p.aggregation(builder -> builder.singleGroupingSet(groupingKey).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(aggregationSourceId, p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey", "b", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"groupingKey"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey")), "group_id", PlanMatchPattern.values("a", "b", "groupingKey"))))));
    }

    @Test
    public void testAutomaticDecisionForSingleGroupByKeyWithHighCardinality() {
        int clusterThreadCount = 4 * (Integer)this.tester().getSession().getSystemProperty("task_concurrency", Integer.class);
        PlanNodeId aggregationSourceId = new PlanNodeId("aggregationSourceId");
        Symbol groupingKey = new Symbol((Type)BigintType.BIGINT, "groupingKey");
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId.toString(), PlanNodeStatsEstimate.builder().addSymbolStatistics(groupingKey, SymbolStatsEstimate.builder().setDistinctValuesCount((double)(1000 * clusterThreadCount)).build()).build()).on(p -> p.aggregation(builder -> builder.singleGroupingSet(groupingKey).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(aggregationSourceId, p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("groupingKey", (Type)BigintType.BIGINT))))).doesNotFire();
    }

    @Test
    public void testAutomaticDecisionForTwoGroupByKeyWithLowCardinality() {
        int clusterThreadCount = 4 * (Integer)this.tester().getSession().getSystemProperty("task_concurrency", Integer.class);
        PlanNodeId aggregationSourceId = new PlanNodeId("aggregationSourceId");
        Symbol groupingKey1 = new Symbol((Type)BigintType.BIGINT, "groupingKey1");
        Symbol groupingKey2 = new Symbol((Type)BigintType.BIGINT, "groupingKey2");
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId.toString(), PlanNodeStatsEstimate.builder().addSymbolStatistics(groupingKey1, SymbolStatsEstimate.builder().setDistinctValuesCount((double)(2 * clusterThreadCount)).build()).addSymbolStatistics(groupingKey2, SymbolStatsEstimate.builder().setDistinctValuesCount((double)(2 * clusterThreadCount)).build()).build()).on(p -> p.aggregation(builder -> builder.singleGroupingSet(groupingKey1, groupingKey2).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT))))).matches(PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey1", "groupingKey2"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct-final", PlanMatchPattern.aggregationFunction("any_value", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("non-distinct")), "gid-filter-0"), (Object)"distinct-final", PlanMatchPattern.aggregationFunction("sum", false, (List<PlanTestSymbol>)ImmutableList.of((Object)PlanMatchPattern.symbol("b")), "gid-filter-1")), PlanMatchPattern.project((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"gid-filter-0", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L))), (Object)"gid-filter-1", (Object)PlanMatchPattern.expression((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)BigintType.BIGINT, "group_id"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)1L)))), PlanMatchPattern.aggregation(PlanMatchPattern.singleGroupingSet("groupingKey1", "groupingKey2", "b", "group_id"), (Map<String, ExpectedValueProvider<AggregationFunction>>)ImmutableMap.of((Object)"non-distinct", PlanMatchPattern.aggregationFunction("sum", (List<String>)ImmutableList.of((Object)"a"))), PlanMatchPattern.groupId((List<List<String>>)ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"groupingKey1", (Object)"groupingKey2"), (Object)ImmutableList.of((Object)"b", (Object)"groupingKey1", (Object)"groupingKey2")), "group_id", PlanMatchPattern.values("a", "b", "groupingKey1", "groupingKey2"))))));
    }

    @Test
    public void testAutomaticDecisionForThreeGroupByKeyWithLowCardinality() {
        int clusterThreadCount = 4 * (Integer)this.tester().getSession().getSystemProperty("task_concurrency", Integer.class);
        PlanNodeId aggregationSourceId = new PlanNodeId("aggregationSourceId");
        Symbol groupingKey1 = new Symbol((Type)BigintType.BIGINT, "groupingKey1");
        Symbol groupingKey2 = new Symbol((Type)BigintType.BIGINT, "groupingKey2");
        Symbol groupingKey3 = new Symbol((Type)BigintType.BIGINT, "groupingKey3");
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId.toString(), PlanNodeStatsEstimate.builder().addSymbolStatistics(groupingKey1, SymbolStatsEstimate.builder().setDistinctValuesCount((double)clusterThreadCount).build()).addSymbolStatistics(groupingKey2, SymbolStatsEstimate.builder().setDistinctValuesCount((double)clusterThreadCount).build()).addSymbolStatistics(groupingKey3, SymbolStatsEstimate.builder().setDistinctValuesCount((double)clusterThreadCount).build()).build()).on(p -> p.aggregation(builder -> builder.singleGroupingSet(groupingKey1, groupingKey2, groupingKey3).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT), p.symbol("groupingKey3", (Type)BigintType.BIGINT))))).doesNotFire();
        this.tester().assertThat((Rule<?>)new OptimizeMixedDistinctAggregations(this.tester().getPlannerContext(), TASK_COUNT_ESTIMATOR)).setSystemProperty("distinct_aggregations_strategy", "automatic").overrideStats(aggregationSourceId.toString(), PlanNodeStatsEstimate.builder().addSymbolStatistics(groupingKey1, SymbolStatsEstimate.builder().setDistinctValuesCount(Double.NaN).build()).addSymbolStatistics(groupingKey2, SymbolStatsEstimate.builder().setDistinctValuesCount(Double.NaN).build()).addSymbolStatistics(groupingKey3, SymbolStatsEstimate.builder().setDistinctValuesCount(Double.NaN).build()).build()).on(p -> p.aggregation(builder -> builder.singleGroupingSet(groupingKey1, groupingKey2, groupingKey3).addAggregation(p.symbol("non-distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "a"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).addAggregation(p.symbol("distinct", (Type)BigintType.BIGINT), PlanBuilder.aggregation("sum", true, (List<Expression>)ImmutableList.of((Object)new Reference((Type)BigintType.BIGINT, "b"))), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT)).source((PlanNode)p.values(p.symbol("a", (Type)BigintType.BIGINT), p.symbol("b", (Type)BigintType.BIGINT), p.symbol("groupingKey1", (Type)BigintType.BIGINT), p.symbol("groupingKey2", (Type)BigintType.BIGINT), p.symbol("groupingKey3", (Type)BigintType.BIGINT))))).doesNotFire();
    }
}

