/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableMap;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.ExpressionMatcher;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PruneProjectColumns;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.Assignments;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestPruneProjectColumns
extends BaseRuleTest {
    public TestPruneProjectColumns() {
        super(new Plugin[0]);
    }

    @Test
    public void testNotAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneProjectColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{b}), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{a, b}), (PlanNode)p.values(a, b)));
        }).matches(PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.strictProject((Map<String, ExpressionMatcher>)ImmutableMap.of((Object)"b", (Object)PlanMatchPattern.expression((Expression)new Reference((Type)BigintType.BIGINT, "b"))), PlanMatchPattern.values("a", "b"))));
    }

    @Test
    public void testAllOutputsReferenced() {
        this.tester().assertThat((Rule<?>)new PruneProjectColumns()).on(p -> {
            Symbol a = p.symbol("a");
            Symbol b = p.symbol("b");
            return p.project(Assignments.identity((Symbol[])new Symbol[]{b}), (PlanNode)p.project(Assignments.identity((Symbol[])new Symbol[]{b}), (PlanNode)p.values(a, b)));
        }).doesNotFire();
    }
}

