/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.Plugin;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Booleans;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Cast;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.Row;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushFilterIntoValues;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.PlanNode;
import java.util.List;
import org.junit.jupiter.api.Test;

class TestPushFilterIntoValues
extends BaseRuleTest {
    TestPushFilterIntoValues() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFireWhenValuesHasNoOutputs() {
        this.tester().assertThat((Rule<?>)new PushFilterIntoValues(this.tester().getPlannerContext())).on(p -> p.filter((Expression)Booleans.TRUE, (PlanNode)p.values(5, new Symbol[0]))).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenValuesHasNonRowExpression() {
        this.tester().assertThat((Rule<?>)new PushFilterIntoValues(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            return p.filter((Expression)Booleans.TRUE, (PlanNode)p.valuesOfExpressions((List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<Expression>)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L))), (Object)new Cast((Expression)new Row((List)ImmutableList.of((Object)new Constant((Type)IntegerType.INTEGER, (Object)3L), (Object)new Constant((Type)IntegerType.INTEGER, (Object)4L))), (Type)RowType.anonymousRow((Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT})))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenFilterPredicateNonDeterministic() {
        ResolvedFunction random = new TestingFunctionResolution().resolveFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new PushFilterIntoValues(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a", (Type)DoubleType.DOUBLE);
            Symbol b = p.symbol("b", (Type)DoubleType.DOUBLE);
            return p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "a"), (Expression)new Call(random, (List)ImmutableList.of())), (PlanNode)p.values(5, a, b));
        }).doesNotFire();
    }

    @Test
    public void testEmptyValues() {
        this.tester().assertThat((Rule<?>)new PushFilterIntoValues(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            return p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Constant((Type)BigintType.BIGINT, (Object)0L)), (PlanNode)p.values(a, b));
        }).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b")));
    }

    @Test
    public void testDoesNotFireWhenValuesNonDeterministic() {
        ResolvedFunction random = new TestingFunctionResolution().resolveFunction("random", TypeSignatureProvider.fromTypes((Type[])new Type[0]));
        this.tester().assertThat((Rule<?>)new PushFilterIntoValues(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a", (Type)DoubleType.DOUBLE);
            Symbol b = p.symbol("b", (Type)DoubleType.DOUBLE);
            return p.filter((Expression)Booleans.TRUE, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.0), (Object)new Call(random, (List)ImmutableList.of())))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenValuesCorrelated() {
        this.tester().assertThat((Rule<?>)new PushFilterIntoValues(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a", (Type)DoubleType.DOUBLE);
            Symbol b = p.symbol("b", (Type)DoubleType.DOUBLE);
            return p.filter((Expression)Booleans.TRUE, (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)DoubleType.DOUBLE, (Object)1.0), (Object)new Reference((Type)DoubleType.DOUBLE, "c")))));
        }).doesNotFire();
    }

    @Test
    public void testDoesNotFireWhenFilterCorrelated() {
        this.tester().assertThat((Rule<?>)new PushFilterIntoValues(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a", (Type)DoubleType.DOUBLE);
            Symbol b = p.symbol("b", (Type)DoubleType.DOUBLE);
            return p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)DoubleType.DOUBLE, "c"), (Expression)new Constant((Type)DoubleType.DOUBLE, (Object)0.0)), (PlanNode)p.values(5, a, b));
        }).doesNotFire();
    }

    @Test
    public void testRetainAllRowsAndRemoveFilter() {
        this.tester().assertThat((Rule<?>)new PushFilterIntoValues(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            return p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)5L), (Object)new Constant((Type)BigintType.BIGINT, (Object)4L)), (Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)500L), (Object)new Constant((Type)BigintType.BIGINT, (Object)400L)))));
        }).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b")));
    }

    @Test
    public void testRemoveSomeRowsAndRemoveFilter() {
        this.tester().assertThat((Rule<?>)new PushFilterIntoValues(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            return p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)5L), (Object)new Constant((Type)BigintType.BIGINT, (Object)4L)), (Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L)))));
        }).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b"), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)5L), (Object)new Constant((Type)BigintType.BIGINT, (Object)4L)))));
    }

    @Test
    public void testRemoveAllRowsAndRemoveFilter() {
        this.tester().assertThat((Rule<?>)new PushFilterIntoValues(this.tester().getPlannerContext())).on(p -> {
            Symbol a = p.symbol("a", (Type)BigintType.BIGINT);
            Symbol b = p.symbol("b", (Type)BigintType.BIGINT);
            return p.filter((Expression)new Comparison(Comparison.Operator.GREATER_THAN, (Expression)new Reference((Type)BigintType.BIGINT, "a"), (Expression)new Reference((Type)BigintType.BIGINT, "b")), (PlanNode)p.values((List<Symbol>)ImmutableList.of((Object)a, (Object)b), (List<List<Expression>>)ImmutableList.of((Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)4L), (Object)new Constant((Type)BigintType.BIGINT, (Object)5L)), (Object)ImmutableList.of((Object)new Constant((Type)BigintType.BIGINT, (Object)1L), (Object)new Constant((Type)BigintType.BIGINT, (Object)2L)))));
        }).matches(PlanMatchPattern.values((List<String>)ImmutableList.of((Object)"a", (Object)"b")));
    }
}

