/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import io.trino.spi.Plugin;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.RemoveRedundantJoin;
import io.trino.sql.planner.iterative.rule.test.BaseRuleTest;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import org.junit.jupiter.api.Test;

public class TestRemoveRedundantJoin
extends BaseRuleTest {
    public TestRemoveRedundantJoin() {
        super(new Plugin[0]);
    }

    @Test
    public void testDoesNotFire() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinType.FULL, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).doesNotFire();
    }

    @Test
    public void testInnerJoinRemoval() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(0, new Symbol[0]), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values("a"));
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinType.INNER, (PlanNode)p.values(0, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values("b"));
    }

    @Test
    public void testLeftJoinRemoval() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinType.LEFT, (PlanNode)p.values(0, new Symbol[0]), (PlanNode)p.values(10, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values("a"));
    }

    @Test
    public void testRightJoinRemoval() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinType.RIGHT, (PlanNode)p.values(10, p.symbol("a")), (PlanNode)p.values(0, new Symbol[0]), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values("a"));
    }

    @Test
    public void testFullJoinRemoval() {
        this.tester().assertThat((Rule<?>)new RemoveRedundantJoin()).on(p -> p.join(JoinType.FULL, (PlanNode)p.values(0, p.symbol("a")), (PlanNode)p.values(0, p.symbol("b")), new JoinNode.EquiJoinClause[0])).matches(PlanMatchPattern.values("a", "b"));
    }
}

