/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.spi.expression.FunctionName;
import io.trino.spi.statistics.ColumnStatisticMetadata;
import io.trino.spi.statistics.ColumnStatisticType;
import io.trino.spi.statistics.TableStatisticType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.TestingTypeManager;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.SymbolKeyDeserializer;
import io.trino.sql.planner.plan.StatisticAggregationsDescriptor;
import io.trino.type.TypeDeserializer;
import io.trino.type.TypeSignatureKeyDeserializer;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStatisticAggregationsDescriptor {
    private static final ImmutableList<String> COLUMNS = ImmutableList.of((Object)"", (Object)"col1", (Object)"$:###:;", (Object)"abc+dddd___");

    @Test
    public void testSerializationRoundTrip() {
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setKeyDeserializers((Map)ImmutableMap.of(Symbol.class, (Object)new SymbolKeyDeserializer((TypeManager)new TestingTypeManager()), TypeSignature.class, (Object)new TypeSignatureKeyDeserializer()));
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(arg_0 -> ((TestingTypeManager)new TestingTypeManager()).getType(arg_0))));
        JsonCodec codec = new JsonCodecFactory((Provider)provider).jsonCodec((TypeToken)new TypeToken<StatisticAggregationsDescriptor<Symbol>>(){});
        TestStatisticAggregationsDescriptor.assertSerializationRoundTrip((JsonCodec<StatisticAggregationsDescriptor<Symbol>>)codec, (StatisticAggregationsDescriptor<Symbol>)StatisticAggregationsDescriptor.builder().build());
        TestStatisticAggregationsDescriptor.assertSerializationRoundTrip((JsonCodec<StatisticAggregationsDescriptor<Symbol>>)codec, TestStatisticAggregationsDescriptor.createTestDescriptor());
    }

    private static void assertSerializationRoundTrip(JsonCodec<StatisticAggregationsDescriptor<Symbol>> codec, StatisticAggregationsDescriptor<Symbol> descriptor) {
        Assertions.assertThat((Object)((StatisticAggregationsDescriptor)codec.fromJson(codec.toJson(descriptor)))).isEqualTo(descriptor);
    }

    private static StatisticAggregationsDescriptor<Symbol> createTestDescriptor() {
        StatisticAggregationsDescriptor.Builder builder = StatisticAggregationsDescriptor.builder();
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        for (String column : COLUMNS) {
            for (ColumnStatisticType type : ColumnStatisticType.values()) {
                builder.addColumnStatistic(new ColumnStatisticMetadata(column, type), (Object)TestStatisticAggregationsDescriptor.testSymbol(symbolAllocator));
            }
            builder.addColumnStatistic(new ColumnStatisticMetadata(column, "count non null", new FunctionName("count")), (Object)TestStatisticAggregationsDescriptor.testSymbol(symbolAllocator));
            builder.addColumnStatistic(new ColumnStatisticMetadata(column, "count true", new FunctionName("count_if")), (Object)TestStatisticAggregationsDescriptor.testSymbol(symbolAllocator));
            builder.addGrouping(column, (Object)TestStatisticAggregationsDescriptor.testSymbol(symbolAllocator));
        }
        builder.addTableStatistic(TableStatisticType.ROW_COUNT, (Object)TestStatisticAggregationsDescriptor.testSymbol(symbolAllocator));
        return builder.build();
    }

    private static Symbol testSymbol(SymbolAllocator allocator) {
        return allocator.newSymbol("test_symbol", (Type)BigintType.BIGINT);
    }
}

