/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestOrderedAggregation {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testAggregationWithOrderBy() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT sum(x ORDER BY y) FROM (VALUES (1, 2), (3, 5), (4, 1)) t(x, y)"))).matches("VALUES (BIGINT '8')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(x ORDER BY y) FROM (VALUES (1, 2), (3, 5), (4, 1)) t(x, y)"))).matches("VALUES ARRAY[4, 1, 3]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(x ORDER BY y DESC) FROM (VALUES (1, 2), (3, 5), (4, 1)) t(x, y)"))).matches("VALUES ARRAY[3, 1, 4]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(x ORDER BY x DESC) FROM (VALUES (1, 2), (3, 5), (4, 1)) t(x, y)"))).matches("VALUES ARRAY[4, 3, 1]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(x ORDER BY x) FROM (VALUES ('a', 2), ('bcd', 5), ('abcd', 1)) t(x, y)"))).matches("VALUES ARRAY['a', 'abcd', 'bcd']");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(y ORDER BY x) FROM (VALUES ('a', 2), ('bcd', 5), ('abcd', 1)) t(x, y)"))).matches("VALUES ARRAY[2, 1, 5]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(y ORDER BY x) FROM (VALUES ((1, 2), 2), ((3, 4), 5), ((1, 1), 1)) t(x, y)"))).matches("VALUES ARRAY[1, 2, 5]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(z ORDER BY x, y DESC) FROM (VALUES (1, 2, 2), (2, 2, 3), (2, 4, 5), (3, 4, 4), (1, 1, 1)) t(x, y, z)"))).matches("VALUES ARRAY[2, 1, 5, 3, 4]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT x, array_agg(z ORDER BY y + z DESC) FROM (VALUES (1, 2, 2), (2, 2, 3), (2, 4, 5), (3, 4, 4), (3, 2, 1), (1, 1, 1)) t(x, y, z) GROUP BY x"))).matches("VALUES (1, ARRAY[2, 1]), (2, ARRAY[5, 3]), (3, ARRAY[4, 1])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(y ORDER BY x.a DESC) FROM (VALUES (CAST(ROW(1) AS ROW(a BIGINT)), 1), (CAST(ROW(2) AS ROW(a BIGINT)), 2)) t(x, y)"))).matches("VALUES ARRAY[2, 1]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT x, y, array_agg(z ORDER BY z DESC NULLS FIRST) FROM (VALUES (1, 2, NULL), (1, 2, 1), (1, 2, 2), (2, 1, 3), (2, 1, 4), (2, 1, NULL)) t(x, y, z) GROUP BY x, y"))).matches("VALUES (1, 2, ARRAY[NULL, 2, 1]), (2, 1, ARRAY[NULL, 4, 3])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT x, y, array_agg(z ORDER BY z DESC NULLS LAST) FROM (VALUES (1, 2, 3), (1, 2, 1), (1, 2, 2), (2, 1, 3), (2, 1, 4), (2, 1, NULL)) t(x, y, z) GROUP BY GROUPING SETS ((x), (x, y))"))).matches("VALUES (1, 2, ARRAY[3, 2, 1]), (1, NULL, ARRAY[3, 2, 1]), (2, 1, ARRAY[4, 3, NULL]), (2, NULL, ARRAY[4, 3, NULL])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT x, y, array_agg(z ORDER BY z DESC NULLS LAST) FROM (VALUES (1, 2, 3), (1, 2, 1), (1, 2, 2), (2, 1, 3), (2, 1, 4), (2, 1, NULL)) t(x, y, z) GROUP BY GROUPING SETS ((x), (x, y))"))).matches("VALUES (1, 2, ARRAY[3, 2, 1]), (1, NULL, ARRAY[3, 2, 1]), (2, 1, ARRAY[4, 3, NULL]), (2, NULL, ARRAY[4, 3, NULL])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT x, array_agg(DISTINCT z + y ORDER BY z + y DESC) FROM (VALUES (1, 2, 2), (2, 2, 3), (2, 4, 5), (3, 4, 4), (3, 2, 1), (1, 1, 1)) t(x, y, z) GROUP BY x"))).matches("VALUES (1, ARRAY[4, 2]), (2, ARRAY[9, 5]), (3, ARRAY[8, 3])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT x, sum(cast(x AS double))\nFROM (VALUES '1.0') t(x)\nGROUP BY x\nORDER BY sum(cast(t.x AS double) ORDER BY t.x)"))).matches("VALUES ('1.0', 1e0)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT x, y, array_agg(z ORDER BY z) FROM (VALUES (1, 2, 3), (1, 2, 1), (2, 1, 3), (2, 1, 4)) t(x, y, z) GROUP BY GROUPING SETS ((x), (x, y))"))).matches("VALUES (1, NULL, ARRAY[1, 3]), (2, NULL, ARRAY[3, 4]), (1, 2, ARRAY[1, 3]), (2, 1, ARRAY[3, 4])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT abs(z ORDER BY z) OVER (PARTITION BY x) FROM (VALUES (1, 2, 3), (1, 2, 1), (2, 1, 3), (2, 1, 4)) t(x, y, z) GROUP BY x, z"))).failure().hasMessageMatching(".* ORDER BY is only valid for aggregation functions");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(z ORDER BY z) OVER (PARTITION BY x) FROM (VALUES (1, 2, 3), (1, 2, 1), (2, 1, 3), (2, 1, 4)) t(x, y, z) GROUP BY x, z"))).matches("VALUES ARRAY[1, 3], ARRAY[1, 3], ARRAY[3, 4], ARRAY[3, 4]");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(DISTINCT x ORDER BY y) FROM (VALUES (1, 2), (3, 5), (4, 1)) t(x, y)"))).failure().hasMessageMatching(".* For aggregate function with DISTINCT, ORDER BY expressions must appear in arguments");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT array_agg(DISTINCT x+y ORDER BY y) FROM (VALUES (1, 2), (3, 5), (4, 1)) t(x, y)"))).failure().hasMessageMatching(".* For aggregate function with DISTINCT, ORDER BY expressions must appear in arguments");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT x, array_agg(DISTINCT y ORDER BY z + y DESC) FROM (VALUES (1, 2, 2), (2, 2, 3), (2, 4, 5), (3, 4, 4), (3, 2, 1), (1, 1, 1)) t(x, y, z) GROUP BY x"))).failure().hasMessageMatching(".* For aggregate function with DISTINCT, ORDER BY expressions must appear in arguments");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT multimap_agg(x, y ORDER BY z) FROM (VALUES (1, 2, 2), (1, 5, 5), (2, 1, 5), (3, 4, 4), (2, 5, 1), (1, 1, 1)) t(x, y, z)"))).matches("VALUES map_from_entries(ARRAY[row(1, ARRAY[1, 2, 5]), row(2, ARRAY[5, 1]), row(3, ARRAY[4])])");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("select array_agg(a ORDER BY last_value(b) OVER()) OVER (partition by c) FROM (VALUES (1, 2, 3)) t(a, b, c)"))).failure().hasMessageMatching(".* Cannot nest window functions or row pattern measures inside window function arguments");
    }

    @Test
    public void testGroupingSets() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT x, array_agg(y ORDER BY y), array_agg(y ORDER BY y) FILTER (WHERE y > 1), count(*) FROM (VALUES    (1, 3),    (1, 1),    (2, 3),    (2, 4)) t(x, y) GROUP BY GROUPING SETS ((), (x))"))).matches("VALUES    (1, ARRAY[1, 3], ARRAY[3], BIGINT '2'),    (2, ARRAY[3, 4], ARRAY[3, 4], BIGINT '2'),    (NULL, ARRAY[1, 3, 3, 4], ARRAY[3, 3, 4], BIGINT '4')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT x, array_agg(DISTINCT y ORDER BY y), count(*) FROM (VALUES    (1, 3),    (1, 1),    (1, 3),    (2, 3),    (2, 4)) t(x, y) GROUP BY GROUPING SETS ((), (x))"))).matches("VALUES    (1, ARRAY[1, 3], BIGINT '3'),    (2, ARRAY[3, 4], BIGINT '2'),    (NULL, ARRAY[1, 3, 4], BIGINT '5')");
    }

    @Test
    public void testRepeatedSortItems() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(x ORDER BY y, y) FROM (VALUES ('a', 2)) t(x, y)"))).matches("VALUES BIGINT '1'");
    }

    @Test
    public void testCompletelyFilteredGroup() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(id) > 15000, sum(cardinality(v)) FROM (     SELECT         id,         array_agg( v ORDER BY t DESC) filter (WHERE v IS NOT NULL) AS v     FROM (         (             SELECT 'filtered' AS id, cast('value' AS varchar) AS v, 'sort' AS t             FROM (VALUES 1, 2, 3, 4, 5, 6, 7, 8, 9, 10)         )         UNION ALL         (             SELECT cast(uuid() AS varchar) AS id, cast(null AS varchar) AS v, 'sort' AS t             FROM UNNEST(combinations(ARRAY[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20], 5))         )     )     GROUP BY id )"))).matches("VALUES (TRUE, BIGINT '10')");
    }
}

