/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorEntities;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.metadata.QualifiedObjectName;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Identity;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestRowFilter {
    private static final String LOCAL_CATALOG = "local";
    private static final String MOCK_CATALOG = "mock";
    private static final String MOCK_CATALOG_MISSING_COLUMNS = "mockmissingcolumns";
    private static final String USER = "user";
    private static final String VIEW_OWNER = "view-owner";
    private static final String RUN_AS_USER = "run-as-user";
    private static final Session SESSION = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setIdentity(Identity.forUser((String)"user").build()).build();
    private final QueryAssertions assertions;
    private final TestingAccessControlManager accessControl;

    public TestRowFilter() {
        StandaloneQueryRunner runner = new StandaloneQueryRunner(SESSION);
        runner.installPlugin((Plugin)new TpchPlugin());
        runner.createCatalog(LOCAL_CATALOG, "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        ConnectorViewDefinition view = new ConnectorViewDefinition("SELECT nationkey, name FROM local.tiny.nation", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("nationkey", BigintType.BIGINT.getTypeId(), Optional.empty()), (Object)new ConnectorViewDefinition.ViewColumn("name", VarcharType.createVarcharType((int)25).getTypeId(), Optional.empty())), Optional.empty(), Optional.of(VIEW_OWNER), false, (List)ImmutableList.of());
        runner.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withGetViews((s, prefix) -> ImmutableMap.of((Object)new SchemaTableName("default", "nation_view"), (Object)view)).withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_hidden_column"))) {
                return MockConnectorEntities.TPCH_NATION_WITH_HIDDEN_COLUMN;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_optional_column"))) {
                return MockConnectorEntities.TPCH_NATION_WITH_OPTIONAL_COLUMN;
            }
            throw new UnsupportedOperationException();
        }).withData(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation"))) {
                return MockConnectorEntities.TPCH_NATION_DATA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_hidden_column"))) {
                return MockConnectorEntities.TPCH_WITH_HIDDEN_COLUMN_DATA;
            }
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_optional_column"))) {
                return MockConnectorEntities.TPCH_NATION_DATA;
            }
            throw new UnsupportedOperationException();
        }).build()));
        runner.createCatalog(MOCK_CATALOG, MOCK_CATALOG, (Map)ImmutableMap.of());
        runner.installPlugin((Plugin)new MockConnectorPlugin(MockConnectorFactory.builder().withName(MOCK_CATALOG_MISSING_COLUMNS).withGetViews((s, prefix) -> ImmutableMap.of((Object)new SchemaTableName("default", "nation_view"), (Object)view)).withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_optional_column"))) {
                return MockConnectorEntities.TPCH_NATION_WITH_OPTIONAL_COLUMN;
            }
            throw new UnsupportedOperationException();
        }).withData(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_with_optional_column"))) {
                return MockConnectorEntities.TPCH_NATION_DATA;
            }
            throw new UnsupportedOperationException();
        }).withAllowMissingColumnsOnInsert(true).build()));
        runner.createCatalog(MOCK_CATALOG_MISSING_COLUMNS, MOCK_CATALOG_MISSING_COLUMNS, (Map)ImmutableMap.of());
        this.assertions = new QueryAssertions((QueryRunner)runner);
        this.accessControl = this.assertions.getQueryRunner().getAccessControl();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testSimpleFilter() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().expression("orderkey < 10").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).matches("VALUES BIGINT '7'");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().expression("NULL").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).matches("VALUES BIGINT '0'");
    }

    @Test
    public void testMultipleFilters() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().expression("orderkey < 10").build());
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().expression("orderkey > 5").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).matches("VALUES BIGINT '2'");
    }

    @Test
    public void testCorrelatedSubquery() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("EXISTS (SELECT 1 FROM nation WHERE nationkey = orderkey)").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).matches("VALUES BIGINT '7'");
    }

    @Test
    public void testView() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "nation"), VIEW_OWNER, ViewExpression.builder().expression("nationkey = 1").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)RUN_AS_USER).build()).build(), "SELECT name FROM mock.default.nation_view"))).matches("VALUES CAST('ARGENTINA' AS VARCHAR(25))");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "nation"), VIEW_OWNER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("nationkey = 1").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)VIEW_OWNER).build()).build(), "SELECT name FROM mock.default.nation_view"))).matches("VALUES CAST('ARGENTINA' AS VARCHAR(25))");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "nation"), RUN_AS_USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("nationkey = 1").build());
        Session session = Session.builder((Session)SESSION).setIdentity(Identity.forUser((String)RUN_AS_USER).build()).build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(session, "SELECT count(*) FROM mock.default.nation_view"))).matches("VALUES BIGINT '25'");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "default", "nation_view"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("nationkey = 1").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT name FROM mock.default.nation_view"))).matches("VALUES CAST('ARGENTINA' AS VARCHAR(25))");
    }

    @Test
    public void testTableReferenceInWithClause() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().expression("orderkey = 1").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH t AS (SELECT count(*) FROM orders) SELECT * FROM t"))).matches("VALUES BIGINT '1'");
    }

    @Test
    public void testOtherSchema() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("sf1").expression("(SELECT count(*) FROM customer) = 150000").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).matches("VALUES BIGINT '15000'");
    }

    @Test
    public void testDifferentIdentity() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), RUN_AS_USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey = 1").build());
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey IN (SELECT orderkey FROM orders)").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).matches("VALUES BIGINT '1'");
    }

    @Test
    public void testRecursion() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey IN (SELECT orderkey FROM orders)").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ROW_FILTER}).hasMessageMatching(".*\\QRow filter for 'local.tiny.orders' is recursive\\E.*");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey IN (SELECT local.tiny.orderkey FROM orders)").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ROW_FILTER}).hasMessageMatching(".*\\QRow filter for 'local.tiny.orders' is recursive\\E.*");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), RUN_AS_USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey IN (SELECT orderkey FROM orders)").build());
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey IN (SELECT orderkey FROM orders)").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ROW_FILTER}).hasMessageMatching(".*\\QRow filter for 'local.tiny.orders' is recursive\\E.*");
    }

    @Test
    public void testLimitedScope() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "customer"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey = 1").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT (SELECT min(name) FROM customer WHERE customer.custkey = orders.custkey) FROM orders"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:31: Invalid row filter for 'local.tiny.customer': Column 'orderkey' cannot be resolved");
    }

    @Test
    public void testSqlInjection() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("regionkey IN (SELECT regionkey FROM region WHERE name = 'ASIA')").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH region(regionkey, name) AS (VALUES (0, 'ASIA'), (1, 'ASIA'), (2, 'ASIA'), (3, 'ASIA'), (4, 'ASIA'))SELECT name FROM nation ORDER BY name LIMIT 1"))).matches("VALUES CAST('CHINA' AS VARCHAR(25))");
    }

    @Test
    public void testInvalidFilter() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("$$$").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_ROW_FILTER}).hasMessage("line 1:22: Invalid row filter for 'local.tiny.orders': mismatched input '$'. Expecting: <expression>");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("unknown_column").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.COLUMN_NOT_FOUND}).hasMessage("line 1:22: Invalid row filter for 'local.tiny.orders': Column 'unknown_column' cannot be resolved");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("1").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:22: Expected row filter for 'local.tiny.orders' to be of type BOOLEAN, but was integer");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("count(*) > 0").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:10: Row filter for 'local.tiny.orders' cannot contain aggregations, window functions or grouping operations: [count(*)]");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("row_number() OVER () > 0").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:22: Row filter for 'local.tiny.orders' cannot contain aggregations, window functions or grouping operations: [row_number() OVER ()]");
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().catalog(LOCAL_CATALOG).schema("tiny").expression("grouping(orderkey) = 0").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT count(*) FROM orders"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.EXPRESSION_NOT_SCALAR}).hasMessage("line 1:20: Row filter for 'local.tiny.orders' cannot contain aggregations, window functions or grouping operations: [GROUPING (orderkey)]");
    }

    @Test
    public void testShowStats() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(LOCAL_CATALOG, "tiny", "orders"), USER, ViewExpression.builder().identity(RUN_AS_USER).catalog(LOCAL_CATALOG).schema("tiny").expression("orderkey = 0").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SHOW STATS FOR (SELECT * FROM tiny.orders)"))).containsAll("VALUES (VARCHAR 'orderkey', 0e1, 0e1, 1e0, CAST(NULL AS double), CAST(NULL AS varchar), CAST(NULL AS varchar)),(VARCHAR 'custkey', 0e1, 0e1, 1e0, CAST(NULL AS double), CAST(NULL AS varchar), CAST(NULL AS varchar)),(NULL, NULL, NULL, NULL, 0e1, NULL, NULL)");
    }

    @Test
    public void testDelete() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().expression("nationkey < 10").build());
        ((QueryAssertions.QueryAssert)this.assertions.query("DELETE FROM mock.tiny.nation WHERE nationkey < 3").assertThat()).matches("SELECT BIGINT '3'");
        ((QueryAssertions.QueryAssert)this.assertions.query("DELETE FROM mock.tiny.nation WHERE nationkey IN (1, 2, 3)").assertThat()).matches("SELECT BIGINT '3'");
        ((QueryAssertions.QueryAssert)this.assertions.query("DELETE FROM mock.tiny.nation").assertThat()).matches("SELECT BIGINT '10'");
        ((QueryAssertions.QueryAssert)this.assertions.query("DELETE FROM mock.tiny.nation WHERE nationkey IN (1, 11)").assertThat()).matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)this.assertions.query("DELETE FROM mock.tiny.nation WHERE nationkey >= 10").assertThat()).matches("SELECT BIGINT '0'");
    }

    @Test
    public void testMergeDelete() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().expression("nationkey < 10").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2) t(x) ON nationkey = x\nWHEN MATCHED THEN DELETE\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3,4,5) t(x) ON regionkey = x\nWHEN MATCHED THEN DELETE\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,11) t(x) ON nationkey = x\nWHEN MATCHED THEN DELETE\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 11,12,13,14,15) t(x) ON nationkey = x\nWHEN MATCHED THEN DELETE\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
    }

    @Test
    public void testUpdate() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().expression("nationkey < 10").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 2 WHERE nationkey < 3"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 2 WHERE nationkey IN (1, 2, 3)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 2"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 2 WHERE nationkey IN (1, 11)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET regionkey = regionkey * 2 WHERE nationkey = 11"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET nationkey = 10 WHERE nationkey < 3"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET nationkey = null WHERE nationkey < 3"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET nationkey = 10 WHERE nationkey = 10"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Updating a table with a row filter is not supported");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation SET nationkey = null WHERE nationkey = null "))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Updating a table with a row filter is not supported");
    }

    @Test
    public void testMergeUpdate() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().expression("nationkey < 10").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 5) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3,4,5,6) t(x) ON regionkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1, 11) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 11) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET regionkey = regionkey * 2\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = 10\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 1,2,3) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = NULL\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 10) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = 13\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 10) t(x) ON nationkey = x\nWHEN MATCHED THEN UPDATE SET nationkey = NULL\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 10) t(x) ON nationkey IS NULL\nWHEN MATCHED THEN UPDATE SET nationkey = 13\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
    }

    @Test
    public void testInsert() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().expression("nationkey > 100").build());
        ((QueryAssertions.QueryAssert)this.assertions.query("INSERT INTO mock.tiny.nation VALUES (101, 'POLAND', 0, 'No comment')").assertThat()).skippingTypesCheck().matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation VALUES (26, 'POLAND', 0, 'No comment')"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PERMISSION_DENIED}).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation VALUES (26, 'POLAND', 0, 'No comment'),(27, 'HOLLAND', 0, 'A comment')"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PERMISSION_DENIED}).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation(nationkey) VALUES (null)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PERMISSION_DENIED}).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation(regionkey) VALUES (0)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PERMISSION_DENIED}).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
    }

    @Test
    public void testMergeInsert() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation"), USER, ViewExpression.builder().expression("nationkey > 100").build());
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT VALUES (101, 'POLAND', 0, 'No comment')\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT VALUES (26, 'POLAND', 0, 'No comment')\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES (26, 'POLAND', 0, 'No comment'), (27, 'HOLLAND', 0, 'A comment')) t(a,b,c,d) ON nationkey = a\nWHEN NOT MATCHED THEN INSERT VALUES (a,b,c,d)\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT (nationkey) VALUES (NULL)\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("MERGE INTO mock.tiny.nation USING (VALUES 42) t(dummy) ON false\nWHEN NOT MATCHED THEN INSERT (nationkey) VALUES (0)\n"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessage("line 1:1: Cannot merge into a table with row filters");
    }

    @Test
    public void testRowFilterWithHiddenColumns() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation_with_hidden_column"), USER, ViewExpression.builder().expression("nationkey < 1").build());
        ((QueryAssertions.QueryAssert)this.assertions.query("SELECT * FROM mock.tiny.nation_with_hidden_column").assertThat()).skippingTypesCheck().matches("VALUES (BIGINT '0', 'ALGERIA', BIGINT '0', ' haggle. carefully final deposits detect slyly agai')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_with_hidden_column VALUES (101, 'POLAND', 0, 'No comment')"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PERMISSION_DENIED}).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
        ((QueryAssertions.QueryAssert)this.assertions.query("INSERT INTO mock.tiny.nation_with_hidden_column VALUES (0, 'POLAND', 0, 'No comment')").assertThat()).skippingTypesCheck().matches("VALUES BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_with_hidden_column SET name = 'POLAND'"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessageContaining("Updating a table with a row filter is not supported");
        ((QueryAssertions.QueryAssert)this.assertions.query("DELETE FROM mock.tiny.nation_with_hidden_column WHERE regionkey < 5").assertThat()).skippingTypesCheck().matches("SELECT BIGINT '1'");
        ((QueryAssertions.QueryAssert)this.assertions.query("DELETE FROM mock.tiny.nation_with_hidden_column WHERE \"$hidden\" IS NOT NULL").assertThat()).skippingTypesCheck().matches("SELECT BIGINT '1'");
    }

    @Test
    public void testRowFilterOnHiddenColumn() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG, "tiny", "nation_with_hidden_column"), USER, ViewExpression.builder().expression("\"$hidden\" < 1").build());
        ((QueryAssertions.QueryAssert)this.assertions.query("SELECT count(*) FROM mock.tiny.nation_with_hidden_column").assertThat()).skippingTypesCheck().matches("VALUES BIGINT '25'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mock.tiny.nation_with_hidden_column VALUES (101, 'POLAND', 0, 'No comment')"))).nonTrinoExceptionFailure().hasStackTraceContaining("ArrayIndexOutOfBoundsException: Index 4 out of bounds for length 4");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("UPDATE mock.tiny.nation_with_hidden_column SET name = 'POLAND'"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.NOT_SUPPORTED}).hasMessageContaining("Updating a table with a row filter is not supported");
        ((QueryAssertions.QueryAssert)this.assertions.query("DELETE FROM mock.tiny.nation_with_hidden_column WHERE regionkey < 5").assertThat()).skippingTypesCheck().matches("SELECT BIGINT '25'");
    }

    @Test
    public void testRowFilterOnOptionalColumn() {
        this.accessControl.reset();
        this.accessControl.rowFilter(new QualifiedObjectName(MOCK_CATALOG_MISSING_COLUMNS, "tiny", "nation_with_optional_column"), USER, ViewExpression.builder().expression("length(optional) > 2").build());
        ((QueryAssertions.QueryAssert)this.assertions.query("INSERT INTO mockmissingcolumns.tiny.nation_with_optional_column(nationkey, name, regionkey, comment, optional) VALUES (0, 'POLAND', 0, 'No comment', 'some string')").assertThat()).skippingTypesCheck().matches("VALUES BIGINT '1'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mockmissingcolumns.tiny.nation_with_optional_column(nationkey, name, regionkey, comment, optional) VALUES (0, 'POLAND', 0, 'No comment', 'so')"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PERMISSION_DENIED}).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("INSERT INTO mockmissingcolumns.tiny.nation_with_optional_column(nationkey, name, regionkey, comment, optional) VALUES (0, 'POLAND', 0, 'No comment', null)"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.PERMISSION_DENIED}).hasMessage("Access Denied: Cannot insert row that does not match a row filter");
    }
}

