/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.Type;
import io.trino.type.AbstractTestType;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTimeType
extends AbstractTestType {
    public TestTimeType() {
        super((Type)TimeType.TIME_MILLIS, SqlTime.class, TestTimeType.createTestBlock());
    }

    public static ValueBlock createTestBlock() {
        BlockBuilder blockBuilder = TimeType.TIME_MILLIS.createFixedSizeBlockBuilder(15);
        TimeType.TIME_MILLIS.writeLong(blockBuilder, 1111000000000L);
        TimeType.TIME_MILLIS.writeLong(blockBuilder, 1111000000000L);
        TimeType.TIME_MILLIS.writeLong(blockBuilder, 1111000000000L);
        TimeType.TIME_MILLIS.writeLong(blockBuilder, 2222000000000L);
        TimeType.TIME_MILLIS.writeLong(blockBuilder, 2222000000000L);
        TimeType.TIME_MILLIS.writeLong(blockBuilder, 2222000000000L);
        TimeType.TIME_MILLIS.writeLong(blockBuilder, 2222000000000L);
        TimeType.TIME_MILLIS.writeLong(blockBuilder, 2222000000000L);
        TimeType.TIME_MILLIS.writeLong(blockBuilder, 3333000000000L);
        TimeType.TIME_MILLIS.writeLong(blockBuilder, 3333000000000L);
        TimeType.TIME_MILLIS.writeLong(blockBuilder, 4444000000000L);
        return blockBuilder.buildValueBlock();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return (Long)value + 1L;
    }

    @Test
    public void testRange() {
        Type.Range range = (Type.Range)this.type.getRange().orElseThrow();
        Assertions.assertThat((Object)range.getMin()).isEqualTo((Object)0);
        Assertions.assertThat((Object)range.getMax()).isEqualTo((Object)86400000000000000L);
    }

    @Test
    public void testPreviousValue() {
        long minValue = 0L;
        long maxValue = 86400000000000000L;
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)minValue)).isEqualTo(Optional.empty());
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(minValue + 1000000000L))).isEqualTo(Optional.of(minValue));
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEqualTo(Optional.of(1110000000000L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)(maxValue - 1000000000L))).isEqualTo(Optional.of(maxValue - 2000000000L));
        Assertions.assertThat((Optional)this.type.getPreviousValue((Object)maxValue)).isEqualTo(Optional.of(maxValue - 1000000000L));
    }

    @Test
    public void testNextValue() {
        long minValue = 0L;
        long maxValue = 86400000000000000L;
        Assertions.assertThat((Optional)this.type.getNextValue((Object)minValue)).isEqualTo(Optional.of(minValue + 1000000000L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(minValue + 1000000000L))).isEqualTo(Optional.of(minValue + 2000000000L));
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEqualTo(Optional.of(1112000000000L));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)(maxValue - 1000000000L))).isEqualTo(Optional.of(maxValue));
        Assertions.assertThat((Optional)this.type.getNextValue((Object)maxValue)).isEqualTo(Optional.empty());
    }
}

