/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import io.trino.metadata.MetadataUtil;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;

public record SystemTableHandle(String schemaName, String tableName, TupleDomain<ColumnHandle> constraint) implements ConnectorTableHandle
{
    public SystemTableHandle {
        MetadataUtil.checkSchemaName(schemaName);
        MetadataUtil.checkTableName(tableName);
        Objects.requireNonNull(constraint, "constraint is null");
    }

    public static SystemTableHandle fromSchemaTableName(SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        return new SystemTableHandle(tableName.getSchemaName(), tableName.getTableName(), (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    public SchemaTableName schemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    @Override
    public String toString() {
        return this.schemaName + "." + this.tableName;
    }
}

