/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.RenameSchema;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RenameSchemaTask
implements DataDefinitionTask<RenameSchema> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public RenameSchemaTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "RENAME SCHEMA";
    }

    @Override
    public ListenableFuture<Void> execute(RenameSchema statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        CatalogSchemaName source = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSource()));
        CatalogSchemaName target = new CatalogSchemaName(source.getCatalogName(), statement.getTarget().getValue());
        if (!this.metadata.schemaExists(session, source)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_FOUND, (Node)statement, "Schema '%s' does not exist", source);
        }
        if (this.metadata.schemaExists(session, target)) {
            throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_ALREADY_EXISTS, (Node)statement, "Target schema '%s' already exists", target);
        }
        this.accessControl.checkCanRenameSchema(session.toSecurityContext(), source, statement.getTarget().getValue());
        this.metadata.renameSchema(session, source, statement.getTarget().getValue());
        return Futures.immediateVoidFuture();
    }
}

