/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.ParameterExtractor;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.SessionPropertyEvaluator;
import io.trino.execution.warnings.WarningCollector;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;

public class SetSessionTask
implements DataDefinitionTask<SetSession> {
    private final SessionPropertyEvaluator sessionEvaluator;
    private final AccessControl accessControl;

    @Inject
    public SetSessionTask(SessionPropertyEvaluator sessionPropertyEvaluator, AccessControl accessControl) {
        this.sessionEvaluator = Objects.requireNonNull(sessionPropertyEvaluator, "sessionEvaluator is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "SET SESSION";
    }

    @Override
    public ListenableFuture<Void> execute(SetSession statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        QualifiedName propertyName = statement.getName();
        List parts = propertyName.getParts();
        Session session = stateMachine.getSession();
        if (parts.size() == 1) {
            this.accessControl.checkCanSetSystemSessionProperty(session.getIdentity(), session.getQueryId(), (String)parts.getFirst());
        } else if (parts.size() == 2) {
            this.accessControl.checkCanSetCatalogSessionProperty(SecurityContext.of(session), (String)parts.getFirst(), (String)parts.getLast());
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_SESSION_PROPERTY, "Invalid session property '%s'".formatted(propertyName));
        }
        stateMachine.addSetSessionProperties(statement.getName().toString(), this.sessionEvaluator.evaluate(stateMachine.getSession(), statement.getName(), statement.getValue(), ParameterExtractor.bindParameters((Statement)statement, parameters)));
        return Futures.immediateVoidFuture();
    }
}

