/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler.faulttolerant;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import io.trino.exchange.SpoolingExchangeInput;
import io.trino.execution.scheduler.faulttolerant.NodeRequirements;
import io.trino.execution.scheduler.faulttolerant.SplitAssigner;
import io.trino.metadata.Split;
import io.trino.operator.ExchangeOperator;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.exchange.ExchangeSourceHandle;
import io.trino.split.RemoteSplit;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class ArbitraryDistributionSplitAssigner
implements SplitAssigner {
    private final Optional<CatalogHandle> catalogRequirement;
    private final Set<PlanNodeId> partitionedSources;
    private final Set<PlanNodeId> replicatedSources;
    private final Set<PlanNodeId> allSources;
    private final int adaptiveGrowthPeriod;
    private final double adaptiveGrowthFactor;
    private final long minTargetPartitionSizeInBytes;
    private final long maxTargetPartitionSizeInBytes;
    private final long standardSplitSizeInBytes;
    private final int maxTaskSplitCount;
    private int nextPartitionId;
    private int adaptiveCounter;
    private long targetPartitionSizeInBytes;
    private long roundedTargetPartitionSizeInBytes;
    private final List<PartitionAssignment> allAssignments = new ArrayList<PartitionAssignment>();
    private final Map<NodeRequirements, PartitionAssignment> openAssignments = new HashMap<NodeRequirements, PartitionAssignment>();
    private final Set<PlanNodeId> completedSources = new HashSet<PlanNodeId>();
    private final ListMultimap<PlanNodeId, Split> replicatedSplits = ArrayListMultimap.create();
    private boolean noMoreReplicatedSplits;

    ArbitraryDistributionSplitAssigner(Optional<CatalogHandle> catalogRequirement, Set<PlanNodeId> partitionedSources, Set<PlanNodeId> replicatedSources, int adaptiveGrowthPeriod, double adaptiveGrowthFactor, long minTargetPartitionSizeInBytes, long maxTargetPartitionSizeInBytes, long standardSplitSizeInBytes, int maxTaskSplitCount) {
        this.catalogRequirement = Objects.requireNonNull(catalogRequirement, "catalogRequirement is null");
        this.partitionedSources = ImmutableSet.copyOf((Collection)Objects.requireNonNull(partitionedSources, "partitionedSources is null"));
        this.replicatedSources = ImmutableSet.copyOf((Collection)Objects.requireNonNull(replicatedSources, "replicatedSources is null"));
        this.allSources = ImmutableSet.builder().addAll(partitionedSources).addAll(replicatedSources).build();
        this.adaptiveGrowthPeriod = adaptiveGrowthPeriod;
        this.adaptiveGrowthFactor = adaptiveGrowthFactor;
        this.minTargetPartitionSizeInBytes = minTargetPartitionSizeInBytes;
        this.maxTargetPartitionSizeInBytes = maxTargetPartitionSizeInBytes;
        this.standardSplitSizeInBytes = standardSplitSizeInBytes;
        this.maxTaskSplitCount = maxTaskSplitCount;
        this.targetPartitionSizeInBytes = minTargetPartitionSizeInBytes;
        this.roundedTargetPartitionSizeInBytes = minTargetPartitionSizeInBytes;
    }

    @Override
    public SplitAssigner.AssignmentResult assign(PlanNodeId planNodeId, ListMultimap<Integer, Split> splits, boolean noMoreSplits) {
        for (Split split : splits.values()) {
            Optional<CatalogHandle> splitCatalogRequirement = Optional.of(split.getCatalogHandle()).filter(catalog -> !catalog.getType().isInternal() && !catalog.equals((Object)ExchangeOperator.REMOTE_CATALOG_HANDLE));
            Preconditions.checkArgument((this.catalogRequirement.isEmpty() || this.catalogRequirement.equals(splitCatalogRequirement) ? 1 : 0) != 0, (String)"unexpected split catalog requirement: %s", splitCatalogRequirement);
        }
        if (this.replicatedSources.contains(planNodeId)) {
            return this.assignReplicatedSplits(planNodeId, (List<Split>)ImmutableList.copyOf((Collection)splits.values()), noMoreSplits);
        }
        return this.assignPartitionedSplits(planNodeId, (List<Split>)ImmutableList.copyOf((Collection)splits.values()), noMoreSplits);
    }

    @Override
    public SplitAssigner.AssignmentResult finish() {
        Preconditions.checkState((!this.allAssignments.isEmpty() ? 1 : 0) != 0, (Object)"allAssignments is not expected to be empty");
        return SplitAssigner.AssignmentResult.builder().build();
    }

    private SplitAssigner.AssignmentResult assignReplicatedSplits(PlanNodeId planNodeId, List<Split> splits, boolean noMoreSplits) {
        SplitAssigner.AssignmentResult.Builder assignment = SplitAssigner.AssignmentResult.builder();
        this.replicatedSplits.putAll((Object)planNodeId, splits);
        for (PartitionAssignment partitionAssignment : this.allAssignments) {
            assignment.updatePartition(new SplitAssigner.PartitionUpdate(partitionAssignment.getPartitionId(), planNodeId, false, this.singleSourcePartition(splits), noMoreSplits));
        }
        if (noMoreSplits) {
            this.completedSources.add(planNodeId);
            if (this.completedSources.containsAll(this.replicatedSources)) {
                this.noMoreReplicatedSplits = true;
            }
        }
        if (this.noMoreReplicatedSplits) {
            for (PartitionAssignment partitionAssignment : this.allAssignments) {
                if (!partitionAssignment.isFull()) continue;
                assignment.sealPartition(partitionAssignment.getPartitionId());
            }
        }
        if (this.completedSources.containsAll(this.allSources)) {
            if (this.allAssignments.isEmpty()) {
                this.allAssignments.add(new PartitionAssignment(0));
                assignment.addPartition(new SplitAssigner.Partition(0, new NodeRequirements(this.catalogRequirement, Optional.empty(), true)));
                for (PlanNodeId replicatedSourceId : this.replicatedSources) {
                    assignment.updatePartition(new SplitAssigner.PartitionUpdate(0, replicatedSourceId, false, this.singleSourcePartition(this.replicatedSplits.get((Object)replicatedSourceId)), true));
                }
                for (PlanNodeId partitionedSourceId : this.partitionedSources) {
                    assignment.updatePartition(new SplitAssigner.PartitionUpdate(0, partitionedSourceId, false, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true));
                }
                assignment.sealPartition(0);
            } else {
                for (PartitionAssignment partitionAssignment : this.allAssignments) {
                    if (partitionAssignment.isFull()) continue;
                    for (PlanNodeId partitionedSourceNodeId : this.partitionedSources) {
                        assignment.updatePartition(new SplitAssigner.PartitionUpdate(partitionAssignment.getPartitionId(), partitionedSourceNodeId, false, this.singleSourcePartition((List<Split>)ImmutableList.of()), true));
                    }
                    assignment.sealPartition(partitionAssignment.getPartitionId());
                }
            }
            this.replicatedSplits.clear();
            assignment.setNoMorePartitions();
        }
        return assignment.build();
    }

    private ListMultimap<Integer, Split> singleSourcePartition(List<Split> splits) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        builder.putAll((Object)0, splits);
        return builder.build();
    }

    private SplitAssigner.AssignmentResult assignPartitionedSplits(PlanNodeId planNodeId, List<Split> splits, boolean noMoreSplits) {
        SplitAssigner.AssignmentResult.Builder assignment = SplitAssigner.AssignmentResult.builder();
        for (Split split : splits) {
            NodeRequirements nodeRequirements = this.getNodeRequirements(split);
            PartitionAssignment partitionAssignment = this.openAssignments.get(nodeRequirements);
            long splitSizeInBytes = this.getSplitSizeInBytes(split);
            if (partitionAssignment != null && (partitionAssignment.getAssignedDataSizeInBytes() + splitSizeInBytes > this.roundedTargetPartitionSizeInBytes || partitionAssignment.getAssignedSplitCount() + 1 > this.maxTaskSplitCount)) {
                partitionAssignment.setFull(true);
                for (PlanNodeId partitionedSourceNodeId : this.partitionedSources) {
                    assignment.updatePartition(new SplitAssigner.PartitionUpdate(partitionAssignment.getPartitionId(), partitionedSourceNodeId, false, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true));
                }
                if (this.completedSources.containsAll(this.replicatedSources)) {
                    assignment.sealPartition(partitionAssignment.getPartitionId());
                }
                partitionAssignment = null;
                this.openAssignments.remove(nodeRequirements);
                ++this.adaptiveCounter;
                if (this.adaptiveCounter >= this.adaptiveGrowthPeriod) {
                    this.targetPartitionSizeInBytes = (long)Math.min((double)this.maxTargetPartitionSizeInBytes, Math.ceil((double)this.targetPartitionSizeInBytes * this.adaptiveGrowthFactor));
                    this.roundedTargetPartitionSizeInBytes = Math.round((double)this.targetPartitionSizeInBytes * 1.0 / (double)this.minTargetPartitionSizeInBytes) * this.minTargetPartitionSizeInBytes;
                    Verify.verify((this.roundedTargetPartitionSizeInBytes > 0L ? 1 : 0) != 0, (String)"roundedTargetPartitionSizeInBytes %s not positive", (long)this.roundedTargetPartitionSizeInBytes);
                    this.adaptiveCounter = 0;
                }
            }
            if (partitionAssignment == null) {
                partitionAssignment = new PartitionAssignment(this.nextPartitionId++);
                this.allAssignments.add(partitionAssignment);
                this.openAssignments.put(nodeRequirements, partitionAssignment);
                assignment.addPartition(new SplitAssigner.Partition(partitionAssignment.getPartitionId(), nodeRequirements));
                for (PlanNodeId replicatedSourceId : this.replicatedSources) {
                    assignment.updatePartition(new SplitAssigner.PartitionUpdate(partitionAssignment.getPartitionId(), replicatedSourceId, false, this.singleSourcePartition(this.replicatedSplits.get((Object)replicatedSourceId)), this.completedSources.contains(replicatedSourceId)));
                }
            }
            assignment.updatePartition(new SplitAssigner.PartitionUpdate(partitionAssignment.getPartitionId(), planNodeId, true, this.singleSourcePartition((List<Split>)ImmutableList.of((Object)split)), false));
            partitionAssignment.assignSplit(splitSizeInBytes);
        }
        if (noMoreSplits) {
            this.completedSources.add(planNodeId);
        }
        if (this.completedSources.containsAll(this.allSources)) {
            if (this.allAssignments.isEmpty()) {
                this.allAssignments.add(new PartitionAssignment(0));
                assignment.addPartition(new SplitAssigner.Partition(0, new NodeRequirements(this.catalogRequirement, Optional.empty(), true)));
                for (PlanNodeId replicatedSourceId : this.replicatedSources) {
                    assignment.updatePartition(new SplitAssigner.PartitionUpdate(0, replicatedSourceId, false, this.singleSourcePartition(this.replicatedSplits.get((Object)replicatedSourceId)), true));
                }
                for (PlanNodeId partitionedSourceId : this.partitionedSources) {
                    assignment.updatePartition(new SplitAssigner.PartitionUpdate(0, partitionedSourceId, false, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true));
                }
                assignment.sealPartition(0);
            } else {
                for (PartitionAssignment partitionAssignment : this.openAssignments.values()) {
                    for (PlanNodeId partitionedSourceNodeId : this.partitionedSources) {
                        assignment.updatePartition(new SplitAssigner.PartitionUpdate(partitionAssignment.getPartitionId(), partitionedSourceNodeId, false, (ListMultimap<Integer, Split>)ImmutableListMultimap.of(), true));
                    }
                    assignment.sealPartition(partitionAssignment.getPartitionId());
                }
                this.openAssignments.clear();
            }
            this.replicatedSplits.clear();
            assignment.setNoMorePartitions();
        }
        return assignment.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalogRequirement", this.catalogRequirement).add("partitionedSources", this.partitionedSources).add("replicatedSources", this.replicatedSources).add("allSources", this.allSources).add("adaptiveGrowthPeriod", this.adaptiveGrowthPeriod).add("adaptiveGrowthFactor", this.adaptiveGrowthFactor).add("minTargetPartitionSizeInBytes", this.minTargetPartitionSizeInBytes).add("maxTargetPartitionSizeInBytes", this.maxTargetPartitionSizeInBytes).add("standardSplitSizeInBytes", this.standardSplitSizeInBytes).add("maxTaskSplitCount", this.maxTaskSplitCount).add("nextPartitionId", this.nextPartitionId).add("adaptiveCounter", this.adaptiveCounter).add("targetPartitionSizeInBytes", this.targetPartitionSizeInBytes).add("roundedTargetPartitionSizeInBytes", this.roundedTargetPartitionSizeInBytes).add("allAssignments", this.allAssignments).add("openAssignments", this.openAssignments).add("completedSources", this.completedSources).add("replicatedSplits.size()", this.replicatedSplits.size()).add("noMoreReplicatedSplits", this.noMoreReplicatedSplits).toString();
    }

    private long rank(HostAddress address) {
        PartitionAssignment flexEntry = this.openAssignments.get(new NodeRequirements(this.catalogRequirement, Optional.of(address), true));
        PartitionAssignment rigidEntry = this.openAssignments.get(new NodeRequirements(this.catalogRequirement, Optional.of(address), false));
        if (flexEntry == null && rigidEntry == null) {
            return -1L;
        }
        if (flexEntry == null) {
            return rigidEntry.getAssignedDataSizeInBytes();
        }
        if (rigidEntry == null) {
            return flexEntry.getAssignedDataSizeInBytes();
        }
        return flexEntry.getAssignedDataSizeInBytes() + rigidEntry.getAssignedDataSizeInBytes();
    }

    private NodeRequirements getNodeRequirements(Split split) {
        if (split.getAddresses().isEmpty()) {
            Preconditions.checkArgument((boolean)split.isRemotelyAccessible(), (String)"split is not remotely accessible but the list of hosts is empty: %s", (Object)split);
            return new NodeRequirements(this.catalogRequirement, Optional.empty(), true);
        }
        HostAddress selectedAddress = split.getAddresses().stream().min(Comparator.comparing(this::rank)).orElseThrow();
        return new NodeRequirements(this.catalogRequirement, Optional.of(selectedAddress), split.isRemotelyAccessible());
    }

    private long getSplitSizeInBytes(Split split) {
        if (split.getCatalogHandle().equals((Object)ExchangeOperator.REMOTE_CATALOG_HANDLE)) {
            RemoteSplit remoteSplit = (RemoteSplit)split.getConnectorSplit();
            SpoolingExchangeInput exchangeInput = (SpoolingExchangeInput)remoteSplit.getExchangeInput();
            long size = 0L;
            for (ExchangeSourceHandle handle : exchangeInput.getExchangeSourceHandles()) {
                size += handle.getDataSizeInBytes();
            }
            return size;
        }
        return Math.round((double)split.getSplitWeight().getRawValue() * 1.0 / (double)SplitWeight.standard().getRawValue() * (double)this.standardSplitSizeInBytes);
    }

    private static class PartitionAssignment {
        private final int partitionId;
        private long assignedDataSizeInBytes;
        private int assignedSplitCount;
        private boolean full;

        private PartitionAssignment(int partitionId) {
            this.partitionId = partitionId;
        }

        public int getPartitionId() {
            return this.partitionId;
        }

        public void assignSplit(long sizeInBytes) {
            this.assignedDataSizeInBytes += sizeInBytes;
            ++this.assignedSplitCount;
        }

        public long getAssignedDataSizeInBytes() {
            return this.assignedDataSizeInBytes;
        }

        public int getAssignedSplitCount() {
            return this.assignedSplitCount;
        }

        public boolean isFull() {
            return this.full;
        }

        public void setFull(boolean full) {
            this.full = full;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partitionId", this.partitionId).add("assignedDataSizeInBytes", this.assignedDataSizeInBytes).add("assignedSplitCount", this.assignedSplitCount).add("full", this.full).toString();
        }
    }
}

