/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.trino.client.spooling.DataAttribute;
import io.trino.client.spooling.DataAttributes;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.operator.DriverContext;
import io.trino.operator.OperationTimer;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.OperatorInfo;
import io.trino.operator.OutputSpoolingController;
import io.trino.server.protocol.OutputColumn;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.server.protocol.spooling.SpooledBlock;
import io.trino.server.protocol.spooling.SpoolingSessionProperties;
import io.trino.spi.Mergeable;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.spool.SpooledSegmentHandle;
import io.trino.spi.spool.SpoolingContext;
import io.trino.spi.spool.SpoolingManager;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.plan.OutputNode;
import io.trino.sql.planner.plan.PlanNodeId;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;

public class OutputSpoolingOperatorFactory
implements OperatorFactory {
    private final int operatorId;
    private final PlanNodeId planNodeId;
    private final Map<Symbol, Integer> operatorLayout;
    private final SpoolingManager spoolingManager;
    private final QueryDataEncoder queryDataEncoder;
    private boolean closed;

    public OutputSpoolingOperatorFactory(int operatorId, PlanNodeId planNodeId, Map<Symbol, Integer> operatorLayout, QueryDataEncoder queryDataEncoder, SpoolingManager spoolingManager) {
        this.operatorId = operatorId;
        this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
        this.operatorLayout = ImmutableMap.copyOf(Objects.requireNonNull(operatorLayout, "layout is null"));
        this.queryDataEncoder = Objects.requireNonNull(queryDataEncoder, "queryDataEncoder is null");
        this.spoolingManager = Objects.requireNonNull(spoolingManager, "spoolingManager is null");
    }

    public static List<OutputColumn> spooledOutputLayout(OutputNode outputNode, Map<Symbol, Integer> layout) {
        List<String> columnNames = outputNode.getColumnNames();
        List<Symbol> outputSymbols = outputNode.getOutputSymbols();
        ImmutableList.Builder outputColumnBuilder = ImmutableList.builderWithExpectedSize((int)outputNode.getColumnNames().size());
        for (int i = 0; i < columnNames.size(); ++i) {
            if (outputSymbols.get(i).type().equals((Object)SpooledBlock.SPOOLING_METADATA_TYPE)) continue;
            outputColumnBuilder.add((Object)new OutputColumn(layout.get(outputSymbols.get(i)), columnNames.get(i), outputSymbols.get(i).type()));
        }
        return outputColumnBuilder.build();
    }

    public static Map<Symbol, Integer> layoutUnionWithSpooledMetadata(Map<Symbol, Integer> layout) {
        int maxChannelId = layout.values().stream().max(Integer::compareTo).orElseThrow();
        Verify.verify((maxChannelId + 1 == layout.size() ? 1 : 0) != 0, (String)"Max channel id %s is not equal to layout size: %s", (int)maxChannelId, (int)layout.size());
        return ImmutableMap.builderWithExpectedSize((int)(layout.size() + 1)).putAll(layout).put((Object)SpooledBlock.SPOOLING_METADATA_SYMBOL, (Object)(maxChannelId + 1)).buildOrThrow();
    }

    @Override
    public Operator createOperator(DriverContext driverContext) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
        OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, OutputSpoolingOperator.class.getSimpleName());
        return new OutputSpoolingOperator(operatorContext, this.queryDataEncoder, this.spoolingManager, this.operatorLayout);
    }

    @Override
    public void noMoreOperators() {
        this.closed = true;
    }

    @Override
    public OperatorFactory duplicate() {
        return new OutputSpoolingOperatorFactory(this.operatorId, this.planNodeId, this.operatorLayout, this.queryDataEncoder, this.spoolingManager);
    }

    static class OutputSpoolingOperator
    implements Operator {
        private final OutputSpoolingController controller;
        private State state = State.NEEDS_INPUT;
        private final OperatorContext operatorContext;
        private final LocalMemoryContext userMemoryContext;
        private final QueryDataEncoder queryDataEncoder;
        private final SpoolingManager spoolingManager;
        private final Map<Symbol, Integer> layout;
        private final PageBuffer buffer;
        private final Block[] emptyBlocks;
        private final OperationTimer.OperationTiming spoolingTiming = new OperationTimer.OperationTiming();
        private Page outputPage;

        public OutputSpoolingOperator(OperatorContext operatorContext, QueryDataEncoder queryDataEncoder, SpoolingManager spoolingManager, Map<Symbol, Integer> layout) {
            this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
            this.controller = new OutputSpoolingController(SpoolingSessionProperties.isInliningEnabled(operatorContext.getSession()), SpoolingSessionProperties.getInliningMaxRows(operatorContext.getSession()), SpoolingSessionProperties.getInliningMaxSize(operatorContext.getSession()).toBytes(), SpoolingSessionProperties.getInitialSegmentSize(operatorContext.getSession()).toBytes(), SpoolingSessionProperties.getMaxSegmentSize(operatorContext.getSession()).toBytes());
            this.userMemoryContext = operatorContext.newLocalUserMemoryContext(OutputSpoolingOperator.class.getSimpleName());
            this.queryDataEncoder = Objects.requireNonNull(queryDataEncoder, "queryDataEncoder is null");
            this.spoolingManager = Objects.requireNonNull(spoolingManager, "spoolingManager is null");
            this.layout = Objects.requireNonNull(layout, "layout is null");
            this.emptyBlocks = OutputSpoolingOperator.emptyBlocks(layout);
            this.buffer = PageBuffer.create(this.userMemoryContext);
            operatorContext.setInfoSupplier(new OutputSpoolingInfoSupplier(this.spoolingTiming, this.controller));
        }

        @Override
        public OperatorContext getOperatorContext() {
            return this.operatorContext;
        }

        @Override
        public boolean needsInput() {
            return this.state == State.NEEDS_INPUT;
        }

        @Override
        public void addInput(Page page) {
            Preconditions.checkState((boolean)this.needsInput(), (Object)"Operator is already finishing");
            Objects.requireNonNull(page, "page is null");
            switch (this.controller.getNextMode(page)) {
                default: {
                    throw new MatchException(null, null);
                }
                case SPOOL: {
                    this.buffer.add(page);
                    Page page2 = this.outputBuffer(false);
                    break;
                }
                case BUFFER: {
                    this.buffer.add(page);
                    Page page2 = null;
                    break;
                }
                case INLINE: {
                    Page page2 = this.outputPage = SpooledBlock.createNonSpooledPage(page);
                }
            }
            if (this.outputPage != null) {
                this.state = State.HAS_OUTPUT;
            }
        }

        @Override
        public Page getOutput() {
            if (this.state != State.HAS_OUTPUT && this.state != State.HAS_LAST_OUTPUT) {
                return null;
            }
            Page toReturn = this.outputPage;
            this.outputPage = null;
            this.state = this.state == State.HAS_LAST_OUTPUT ? State.FINISHED : State.NEEDS_INPUT;
            return toReturn;
        }

        @Override
        public void finish() {
            if (this.state == State.NEEDS_INPUT) {
                this.outputPage = this.outputBuffer(true);
                this.state = this.outputPage != null ? State.HAS_LAST_OUTPUT : State.FINISHED;
            }
        }

        @Override
        public boolean isFinished() {
            return this.state == State.FINISHED;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Page outputBuffer(boolean finished) {
            if (this.buffer.isEmpty()) {
                return null;
            }
            PageBuffer pageBuffer = this.buffer;
            synchronized (pageBuffer) {
                return this.spool(this.buffer.removeAll(), finished);
            }
        }

        private Page spool(List<Page> pages, boolean finished) {
            long rows = OutputSpoolingOperator.reduce(pages, Page::getPositionCount);
            long size = OutputSpoolingOperator.reduce(pages, Page::getSizeInBytes);
            if (finished) {
                this.controller.recordSpooled(rows, size);
            }
            SpooledSegmentHandle segmentHandle = this.spoolingManager.create(new SpoolingContext(this.queryDataEncoder.encoding(), this.operatorContext.getDriverContext().getSession().getQueryId(), rows, size));
            OperationTimer overallTimer = new OperationTimer(false);
            try {
                Page page;
                block12: {
                    OutputStream output = this.spoolingManager.createOutputStream(segmentHandle);
                    try {
                        DataAttributes attributes = this.queryDataEncoder.encodeTo(output, pages).toBuilder().set(DataAttribute.ROWS_COUNT, (Object)rows).build();
                        this.controller.recordEncoded(((Integer)attributes.get(DataAttribute.SEGMENT_SIZE, Integer.class)).intValue());
                        page = this.emptySingleRowPage(SpooledBlock.forLocation(this.spoolingManager.location(segmentHandle), attributes).serialize());
                        if (output == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (output != null) {
                                try {
                                    output.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    output.close();
                }
                return page;
            }
            finally {
                overallTimer.end(this.spoolingTiming);
            }
        }

        private Page emptySingleRowPage(Block block) {
            Block[] blocks = this.emptyBlocks;
            blocks[this.layout.get((Object)SpooledBlock.SPOOLING_METADATA_SYMBOL).intValue()] = block;
            return new Page(blocks);
        }

        static long reduce(List<Page> page, ToLongFunction<Page> reduce) {
            return page.stream().mapToLong(reduce).sum();
        }

        private static Block[] emptyBlocks(Map<Symbol, Integer> layout) {
            Block[] blocks = new Block[layout.size()];
            for (Map.Entry<Symbol, Integer> entry : layout.entrySet()) {
                if (entry.getKey().type().equals((Object)SpooledBlock.SPOOLING_METADATA_TYPE)) continue;
                blocks[entry.getValue().intValue()] = entry.getKey().type().createNullBlock();
            }
            return blocks;
        }

        @Override
        public void close() throws Exception {
            this.userMemoryContext.close();
        }

        static enum State {
            NEEDS_INPUT,
            HAS_OUTPUT,
            HAS_LAST_OUTPUT,
            FINISHED;

        }
    }

    public record OutputSpoolingInfo(Duration spoolingWallTime, Duration spoolingCpuTime, long inlinedPages, long inlinedPositions, long inlinedRawBytes, long spooledPages, long spooledPositions, long spooledRawBytes, long spooledEncodedBytes) implements Mergeable<OutputSpoolingInfo>,
    OperatorInfo
    {
        public OutputSpoolingInfo {
            Objects.requireNonNull(spoolingWallTime, "spoolingWallTime is null");
            Objects.requireNonNull(spoolingCpuTime, "spoolingCpuTime is null");
        }

        public OutputSpoolingInfo mergeWith(OutputSpoolingInfo other) {
            return new OutputSpoolingInfo(Duration.succinctDuration((double)(this.spoolingWallTime.toMillis() + other.spoolingWallTime().toMillis()), (TimeUnit)TimeUnit.MILLISECONDS), Duration.succinctDuration((double)(this.spoolingCpuTime.toMillis() + other.spoolingCpuTime().toMillis()), (TimeUnit)TimeUnit.MILLISECONDS), this.inlinedPages + other.inlinedPages(), this.inlinedPositions + other.inlinedPositions, this.inlinedRawBytes + other.inlinedRawBytes, this.spooledPages + other.spooledPages, this.spooledPositions + other.spooledPositions, this.spooledRawBytes + other.spooledRawBytes, this.spooledEncodedBytes + other.spooledEncodedBytes);
        }

        @JsonProperty
        public double getEncodedToRawBytesRatio() {
            return 1.0 * (double)this.spooledEncodedBytes / (double)this.spooledRawBytes;
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("spoolingWallTime", (Object)this.spoolingWallTime).add("spoolingCpuTime", (Object)this.spoolingCpuTime).add("inlinedPages", this.inlinedPages).add("inlinedPositions", this.inlinedPositions).add("inlinedRawBytes", this.inlinedRawBytes).add("spooledPages", this.spooledPages).add("spooledPositions", this.spooledPositions).add("spooledRawBytes", this.spooledRawBytes).add("spooledEncodedBytes", this.spooledEncodedBytes).add("encodedToRawBytesRatio", this.getEncodedToRawBytesRatio()).toString();
        }
    }

    private record OutputSpoolingInfoSupplier(OperationTimer.OperationTiming spoolingTiming, OutputSpoolingController controller) implements Supplier<OutputSpoolingInfo>
    {
        private OutputSpoolingInfoSupplier {
            Objects.requireNonNull(spoolingTiming, "spoolingTiming is null");
            Objects.requireNonNull(controller, "controller is null");
        }

        @Override
        public OutputSpoolingInfo get() {
            return new OutputSpoolingInfo(Duration.succinctDuration((double)this.spoolingTiming.getWallNanos(), (TimeUnit)TimeUnit.NANOSECONDS), Duration.succinctDuration((double)this.spoolingTiming.getCpuNanos(), (TimeUnit)TimeUnit.NANOSECONDS), this.controller.getInlinedPages(), this.controller.getInlinedPositions(), this.controller.getInlinedRawBytes(), this.controller.getSpooledPages(), this.controller.getSpooledPositions(), this.controller.getSpooledRawBytes(), this.controller.getSpooledEncodedBytes());
        }
    }

    private static class PageBuffer {
        private final List<Page> buffer = new ArrayList<Page>();
        private final LocalMemoryContext memoryContext;

        private PageBuffer(LocalMemoryContext memoryContext) {
            this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
        }

        public static PageBuffer create(LocalMemoryContext memoryContext) {
            return new PageBuffer(memoryContext);
        }

        public void add(Page page) {
            this.buffer.add(page);
            this.memoryContext.setBytes(this.memoryContext.getBytes() + page.getRetainedSizeInBytes());
        }

        public boolean isEmpty() {
            return this.buffer.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Page> removeAll() {
            ImmutableList pages;
            List<Page> list = this.buffer;
            synchronized (list) {
                pages = ImmutableList.copyOf(this.buffer);
                this.buffer.clear();
                this.memoryContext.setBytes(0L);
            }
            return pages;
        }
    }
}

