/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.airlift.slice.Slice;
import io.trino.json.JsonInputErrorNode;
import io.trino.operator.scalar.json.JsonInputConversionException;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class JsonInputFunctions {
    public static final String VARCHAR_TO_JSON = "$varchar_to_json";
    public static final String VARBINARY_TO_JSON = "$varbinary_to_json";
    public static final String VARBINARY_UTF8_TO_JSON = "$varbinary_utf8_to_json";
    public static final String VARBINARY_UTF16_TO_JSON = "$varbinary_utf16_to_json";
    public static final String VARBINARY_UTF32_TO_JSON = "$varbinary_utf32_to_json";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final Charset UTF_32LE = Charset.forName("UTF-32LE");

    private JsonInputFunctions() {
    }

    @ScalarFunction(value="$varchar_to_json", hidden=true)
    @SqlType(value="json2016")
    public static JsonNode varcharToJson(@SqlType(value="varchar") Slice inputExpression, @SqlType(value="boolean") boolean failOnError) {
        InputStreamReader reader = new InputStreamReader((InputStream)inputExpression.getInput(), StandardCharsets.UTF_8);
        return JsonInputFunctions.toJson(reader, failOnError);
    }

    @ScalarFunction(value="$varbinary_to_json", hidden=true)
    @SqlType(value="json2016")
    public static JsonNode varbinaryToJson(@SqlType(value="varbinary") Slice inputExpression, @SqlType(value="boolean") boolean failOnError) {
        return JsonInputFunctions.varbinaryUtf8ToJson(inputExpression, failOnError);
    }

    @ScalarFunction(value="$varbinary_utf8_to_json", hidden=true)
    @SqlType(value="json2016")
    public static JsonNode varbinaryUtf8ToJson(@SqlType(value="varbinary") Slice inputExpression, @SqlType(value="boolean") boolean failOnError) {
        InputStreamReader reader = new InputStreamReader((InputStream)inputExpression.getInput(), StandardCharsets.UTF_8);
        return JsonInputFunctions.toJson(reader, failOnError);
    }

    @ScalarFunction(value="$varbinary_utf16_to_json", hidden=true)
    @SqlType(value="json2016")
    public static JsonNode varbinaryUtf16ToJson(@SqlType(value="varbinary") Slice inputExpression, @SqlType(value="boolean") boolean failOnError) {
        InputStreamReader reader = new InputStreamReader((InputStream)inputExpression.getInput(), StandardCharsets.UTF_16LE);
        return JsonInputFunctions.toJson(reader, failOnError);
    }

    @ScalarFunction(value="$varbinary_utf32_to_json", hidden=true)
    @SqlType(value="json2016")
    public static JsonNode varbinaryUtf32ToJson(@SqlType(value="varbinary") Slice inputExpression, @SqlType(value="boolean") boolean failOnError) {
        InputStreamReader reader = new InputStreamReader((InputStream)inputExpression.getInput(), UTF_32LE);
        return JsonInputFunctions.toJson(reader, failOnError);
    }

    private static JsonNode toJson(Reader reader, boolean failOnError) {
        try {
            return MAPPER.readTree(reader);
        }
        catch (JsonProcessingException e) {
            if (failOnError) {
                throw new JsonInputConversionException(e);
            }
            return JsonInputErrorNode.JSON_ERROR;
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }
}

