/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security.oauth2;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.units.DataSize;
import io.trino.server.security.oauth2.ForOAuth2;
import io.trino.server.security.oauth2.ForRefreshTokens;
import io.trino.server.security.oauth2.JweTokenSerializerModule;
import io.trino.server.security.oauth2.NimbusAirliftHttpClient;
import io.trino.server.security.oauth2.NimbusHttpClient;
import io.trino.server.security.oauth2.NimbusOAuth2Client;
import io.trino.server.security.oauth2.OAuth2CallbackResource;
import io.trino.server.security.oauth2.OAuth2Client;
import io.trino.server.security.oauth2.OAuth2Config;
import io.trino.server.security.oauth2.OAuth2ServerConfigProvider;
import io.trino.server.security.oauth2.OAuth2Service;
import io.trino.server.security.oauth2.OAuth2TokenExchange;
import io.trino.server.security.oauth2.OAuth2TokenHandler;
import io.trino.server.security.oauth2.OidcDiscovery;
import io.trino.server.security.oauth2.OidcDiscoveryConfig;
import io.trino.server.security.oauth2.StaticConfigurationProvider;
import io.trino.server.security.oauth2.StaticOAuth2ServerConfig;
import io.trino.server.security.oauth2.TokenPairSerializer;
import io.trino.server.security.oauth2.TokenRefresher;
import io.trino.server.ui.OAuth2WebUiInstalled;
import java.time.Duration;

public class OAuth2ServiceModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(OAuth2CallbackResource.class);
        OptionalBinder.newOptionalBinder((Binder)binder, OAuth2WebUiInstalled.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(OAuth2Config.class);
        binder.bind(OAuth2Service.class).in(Scopes.SINGLETON);
        binder.bind(OAuth2TokenHandler.class).to(OAuth2TokenExchange.class).in(Scopes.SINGLETON);
        binder.bind(NimbusHttpClient.class).to(NimbusAirliftHttpClient.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, OAuth2Client.class).setDefault().to(NimbusOAuth2Client.class).in(Scopes.SINGLETON);
        this.install(ConditionalModule.conditionalModule(OAuth2Config.class, OAuth2Config::isEnableDiscovery, this::bindOidcDiscovery, this::bindStaticConfiguration));
        this.install(ConditionalModule.conditionalModule(OAuth2Config.class, OAuth2Config::isEnableRefreshTokens, this::enableRefreshTokens, this::disableRefreshTokens));
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("oauth2-jwk", ForOAuth2.class).withConfigDefaults(clientConfig -> clientConfig.setRequestBufferSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.KILOBYTE)).setResponseBufferSize(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.KILOBYTE)));
    }

    private void enableRefreshTokens(Binder binder) {
        this.install((Module)new JweTokenSerializerModule());
    }

    private void disableRefreshTokens(Binder binder) {
        binder.bind(TokenPairSerializer.class).toInstance((Object)TokenPairSerializer.ACCESS_TOKEN_ONLY_SERIALIZER);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Duration.class, ForRefreshTokens.class));
    }

    @Singleton
    @Provides
    @Inject
    public TokenRefresher getTokenRefresher(TokenPairSerializer tokenAssembler, OAuth2TokenHandler tokenHandler, OAuth2Client oAuth2Client) {
        return new TokenRefresher(tokenAssembler, tokenHandler, oAuth2Client);
    }

    private void bindStaticConfiguration(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(StaticOAuth2ServerConfig.class);
        binder.bind(OAuth2ServerConfigProvider.class).to(StaticConfigurationProvider.class).in(Scopes.SINGLETON);
    }

    private void bindOidcDiscovery(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(OidcDiscoveryConfig.class);
        binder.bind(OAuth2ServerConfigProvider.class).to(OidcDiscovery.class).in(Scopes.SINGLETON);
    }

    public int hashCode() {
        return OAuth2ServiceModule.class.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof OAuth2ServiceModule;
    }
}

