/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.ImmutableLongArray;
import io.trino.cost.BaseStatsCalculatorTest;
import io.trino.cost.PlanNodeStatsEstimate;
import io.trino.cost.RuntimeInfoProvider;
import io.trino.cost.StaticRuntimeInfoProvider;
import io.trino.cost.StatsAndCosts;
import io.trino.cost.SymbolStatsEstimate;
import io.trino.execution.scheduler.faulttolerant.OutputStatsEstimator;
import io.trino.operator.RetryPolicy;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.testing.TestingHandles;
import io.trino.testing.TestingMetadata;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestRemoteSourceStatsRule
extends BaseStatsCalculatorTest {
    @Test
    public void testStatsRule() {
        this.assertRemoteSourceStats(0.1, 3325.333333);
    }

    @Test
    public void testStatsRuleWithNaNNullFraction() {
        this.assertRemoteSourceStats(Double.NaN, 2992.0);
    }

    private void assertRemoteSourceStats(double nullFraction, double avgRowSize) {
        StatsAndCosts statsAndCosts = this.createStatsAndCosts(nullFraction);
        this.tester().assertStatsFor(pb -> pb.remoteSource((List<PlanFragmentId>)ImmutableList.of((Object)new PlanFragmentId("fragment")), (List<Symbol>)ImmutableList.of((Object)pb.symbol("col_a", (Type)VarcharType.VARCHAR), (Object)pb.symbol("col_b", (Type)VarcharType.VARCHAR), (Object)pb.symbol("col_c", (Type)BigintType.BIGINT), (Object)pb.symbol("col_d", (Type)DoubleType.DOUBLE)), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK)).withRuntimeInfoProvider(this.createRuntimeInfoProvider(statsAndCosts)).check(check -> check.outputRowsCount(1000000.0).symbolStats(new Symbol((Type)VarcharType.VARCHAR, "col_a"), assertion -> assertion.averageRowSize(avgRowSize).distinctValuesCount(100.0).nullsFraction(nullFraction).lowValueUnknown().highValueUnknown()).symbolStats(new Symbol((Type)VarcharType.VARCHAR, "col_b"), assertion -> assertion.averageRowSize(avgRowSize).distinctValuesCount(233.0).nullsFraction(nullFraction).lowValueUnknown().highValueUnknown()).symbolStats(new Symbol((Type)BigintType.BIGINT, "col_c"), assertion -> assertion.averageRowSize(Double.NaN).distinctValuesCount(98.0).nullsFraction(nullFraction).highValue(100.0).lowValue(3.0)).symbolStats(new Symbol((Type)DoubleType.DOUBLE, "col_d"), assertion -> assertion.averageRowSize(Double.NaN).distinctValuesCount(300.0).nullsFraction(nullFraction).highValue(100.0).lowValue(3.0)));
    }

    private RuntimeInfoProvider createRuntimeInfoProvider(StatsAndCosts statsAndCosts) {
        PlanFragment planFragment = this.createPlanFragment(statsAndCosts);
        return new StaticRuntimeInfoProvider((Map)ImmutableMap.of((Object)planFragment.getId(), (Object)this.createRuntimeOutputStatsEstimate()), (Map)ImmutableMap.of((Object)planFragment.getId(), (Object)planFragment));
    }

    private OutputStatsEstimator.OutputStatsEstimateResult createRuntimeOutputStatsEstimate() {
        return new OutputStatsEstimator.OutputStatsEstimateResult(ImmutableLongArray.of((long)1000000000L, (long)2000000000L, (long)3000000000L), 1000000L, "FINISHED", true);
    }

    private PlanFragment createPlanFragment(StatsAndCosts statsAndCosts) {
        return new PlanFragment(new PlanFragmentId("fragment"), (PlanNode)new TableScanNode(new PlanNodeId("plan_id"), TestingHandles.TEST_TABLE_HANDLE, (List)ImmutableList.of((Object)new Symbol((Type)VarcharType.VARCHAR, "col_a"), (Object)new Symbol((Type)VarcharType.VARCHAR, "col_b"), (Object)new Symbol((Type)BigintType.BIGINT, "col_c"), (Object)new Symbol((Type)DoubleType.DOUBLE, "col_d")), (Map)ImmutableMap.of((Object)new Symbol((Type)VarcharType.VARCHAR, "col_a"), (Object)new TestingMetadata.TestingColumnHandle("col_a", 0, (Type)VarcharType.VARCHAR), (Object)new Symbol((Type)VarcharType.VARCHAR, "col_b"), (Object)new TestingMetadata.TestingColumnHandle("col_b", 1, (Type)VarcharType.VARCHAR), (Object)new Symbol((Type)BigintType.BIGINT, "col_c"), (Object)new TestingMetadata.TestingColumnHandle("col_c", 2, (Type)BigintType.BIGINT), (Object)new Symbol((Type)DoubleType.DOUBLE, "col_d"), (Object)new TestingMetadata.TestingColumnHandle("col_d", 3, (Type)DoubleType.DOUBLE)), TupleDomain.all(), Optional.empty(), false, Optional.empty()), (Set)ImmutableSet.of((Object)new Symbol((Type)VarcharType.VARCHAR, "col_a"), (Object)new Symbol((Type)VarcharType.VARCHAR, "col_b"), (Object)new Symbol((Type)BigintType.BIGINT, "col_c"), (Object)new Symbol((Type)DoubleType.DOUBLE, "col_d")), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of((Object)new PlanNodeId("plan_id")), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "col_c"))), statsAndCosts, (List)ImmutableList.of(), (Map)ImmutableMap.of(), Optional.empty());
    }

    private StatsAndCosts createStatsAndCosts(double nullFraction) {
        PlanNodeStatsEstimate symbolEstimate = new PlanNodeStatsEstimate(10000.0, (Map)ImmutableMap.of((Object)new Symbol((Type)VarcharType.VARCHAR, "col_a"), (Object)SymbolStatsEstimate.builder().setNullsFraction(nullFraction).setDistinctValuesCount(100.0).build(), (Object)new Symbol((Type)VarcharType.VARCHAR, "col_b"), (Object)SymbolStatsEstimate.builder().setNullsFraction(nullFraction).setDistinctValuesCount(233.0).build(), (Object)new Symbol((Type)BigintType.BIGINT, "col_c"), (Object)SymbolStatsEstimate.builder().setNullsFraction(nullFraction).setDistinctValuesCount(98.0).setHighValue(100.0).setLowValue(3.0).build(), (Object)new Symbol((Type)DoubleType.DOUBLE, "col_d"), (Object)SymbolStatsEstimate.builder().setNullsFraction(nullFraction).setDistinctValuesCount(300.0).setHighValue(100.0).setLowValue(3.0).build()));
        return new StatsAndCosts((Map)ImmutableMap.of((Object)new PlanNodeId("plan_id"), (Object)symbolEstimate), (Map)ImmutableMap.of());
    }
}

