/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import io.trino.spi.type.BigintType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Function;

public class BenchmarkDataGenerator {
    public static final int MAX_STRING = 19;
    public static final int LONG_DECIMAL_PRECISION = 30;
    public static final int LONG_DECIMAL_SCALE = 5;

    private BenchmarkDataGenerator() {
    }

    public static <T> Iterator<T> createValues(int size, Function<Random, T> valueGenerator, double nullChance) {
        Random random = new Random(0L);
        ArrayList<T> values = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            if (BenchmarkDataGenerator.randomNullChance(random) >= nullChance) {
                values.add(valueGenerator.apply(random));
                continue;
            }
            values.add(null);
        }
        return values.iterator();
    }

    private static double randomNullChance(Random random) {
        double value = 0.0;
        while (value == 0.0) {
            value = random.nextDouble();
        }
        return value;
    }

    public static String randomAsciiString(Random random) {
        return BenchmarkDataGenerator.randomAsciiString(19, random);
    }

    public static String randomAsciiString(int maxLength, Random random) {
        char[] value = new char[random.nextInt(maxLength)];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (char)random.nextInt(127);
        }
        return new String(value);
    }

    public static SqlDecimal randomLongDecimal(Random random) {
        return new SqlDecimal(new BigInteger(96, random), 30, 5);
    }

    public static LongTimestamp randomTimestamp(Random random) {
        return new LongTimestamp(random.nextLong(), random.nextInt(1000000));
    }

    public static short randomShort(Random random) {
        return (short)random.nextInt();
    }

    public static byte randomByte(Random random) {
        return (byte)random.nextInt();
    }

    public static List<Object> randomRow(List<Type> fieldTypes, Random random) {
        ArrayList<Object> row = new ArrayList<Object>(fieldTypes.size());
        for (Type type : fieldTypes) {
            if (type == VarcharType.VARCHAR) {
                row.add(BenchmarkDataGenerator.randomAsciiString(random));
                continue;
            }
            if (type == BigintType.BIGINT) {
                row.add(random.nextLong());
                continue;
            }
            if (type instanceof DecimalType) {
                row.add(BenchmarkDataGenerator.randomLongDecimal(random));
                continue;
            }
            throw new UnsupportedOperationException(String.format("The %s is not supported", type));
        }
        return row;
    }
}

