/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.airlift.slice.SizeOf;
import io.trino.spi.exchange.ExchangeSourceHandle;
import java.util.Objects;

public class TestingExchangeSourceHandle
implements ExchangeSourceHandle {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(TestingExchangeSourceHandle.class);
    private final int id;
    private final int partitionId;
    private final long sizeInBytes;

    @JsonCreator
    public TestingExchangeSourceHandle(@JsonProperty(value="id") int id, @JsonProperty(value="partitionId") int partitionId, @JsonProperty(value="sizeInBytes") long sizeInBytes) {
        this.id = id;
        this.partitionId = partitionId;
        this.sizeInBytes = sizeInBytes;
    }

    @JsonProperty
    public int getId() {
        return this.id;
    }

    @JsonProperty
    public int getPartitionId() {
        return this.partitionId;
    }

    @JsonProperty(value="sizeInBytes")
    public long getDataSizeInBytes() {
        return this.sizeInBytes;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestingExchangeSourceHandle that = (TestingExchangeSourceHandle)o;
        return this.id == that.id && this.partitionId == that.partitionId && this.sizeInBytes == that.sizeInBytes;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.partitionId, this.sizeInBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("partitionId", this.partitionId).add("sizeInBytes", this.sizeInBytes).toString();
    }
}

