/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.FeaturesConfig;
import io.trino.client.NodeVersion;
import io.trino.execution.QueryManager;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.CatalogTableFunctions;
import io.trino.metadata.DisabledSystemSecurityMetadata;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.metadata.LanguageFunctionEngineManager;
import io.trino.metadata.LanguageFunctionManager;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.SystemFunctionBundle;
import io.trino.metadata.SystemSecurityMetadata;
import io.trino.metadata.TableFunctionRegistry;
import io.trino.security.AccessControl;
import io.trino.security.AllowAllAccessControl;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.parser.SqlParser;
import io.trino.testing.NotImplementedQueryManager;
import io.trino.transaction.InMemoryTransactionManager;
import io.trino.transaction.TransactionManager;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import java.util.Collection;
import java.util.Objects;

public final class TestMetadataManager {
    private TestMetadataManager() {
    }

    public static MetadataManager createTestMetadataManager() {
        return TestMetadataManager.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TransactionManager transactionManager;
        private TypeManager typeManager = InternalTypeManager.TESTING_TYPE_MANAGER;
        private GlobalFunctionCatalog globalFunctionCatalog;
        private LanguageFunctionManager languageFunctionManager;

        private Builder() {
        }

        public Builder withTransactionManager(TransactionManager transactionManager) {
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder withTypeManager(TypeManager typeManager) {
            this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
            return this;
        }

        public Builder withGlobalFunctionCatalog(GlobalFunctionCatalog globalFunctionCatalog) {
            this.globalFunctionCatalog = globalFunctionCatalog;
            return this;
        }

        public Builder withLanguageFunctionManager(LanguageFunctionManager languageFunctionManager) {
            this.languageFunctionManager = languageFunctionManager;
            return this;
        }

        public MetadataManager build() {
            GlobalFunctionCatalog globalFunctionCatalog;
            TransactionManager transactionManager = this.transactionManager;
            if (transactionManager == null) {
                transactionManager = InMemoryTransactionManager.createTestTransactionManager();
            }
            if ((globalFunctionCatalog = this.globalFunctionCatalog) == null) {
                globalFunctionCatalog = new GlobalFunctionCatalog(() -> {
                    throw new UnsupportedOperationException();
                }, () -> {
                    throw new UnsupportedOperationException();
                }, () -> {
                    throw new UnsupportedOperationException();
                });
                TypeOperators typeOperators = new TypeOperators();
                globalFunctionCatalog.addFunctions(SystemFunctionBundle.create((FeaturesConfig)new FeaturesConfig(), (TypeOperators)typeOperators, (BlockTypeOperators)new BlockTypeOperators(typeOperators), (NodeVersion)NodeVersion.UNKNOWN));
            }
            if (this.languageFunctionManager == null) {
                InternalBlockEncodingSerde blockEncodingSerde = new InternalBlockEncodingSerde(new BlockEncodingManager(), this.typeManager);
                LanguageFunctionEngineManager engineManager = new LanguageFunctionEngineManager();
                this.languageFunctionManager = new LanguageFunctionManager(new SqlParser(), this.typeManager, string -> ImmutableSet.of(), (BlockEncodingSerde)blockEncodingSerde, engineManager);
            }
            TableFunctionRegistry tableFunctionRegistry = new TableFunctionRegistry(catalogHandle -> new CatalogTableFunctions((Collection)ImmutableList.of()));
            return new MetadataManager((AccessControl)new AllowAllAccessControl(), (SystemSecurityMetadata)new DisabledSystemSecurityMetadata(), transactionManager, globalFunctionCatalog, this.languageFunctionManager, tableFunctionRegistry, this.typeManager, (QueryManager)new NotImplementedQueryManager());
        }
    }
}

