/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.operator.FlatHashStrategy;
import io.trino.operator.FlatHashStrategyCompiler;
import io.trino.operator.PageAssertions;
import io.trino.operator.scalar.CombineHashFunction;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingSession;
import io.trino.type.IpAddressType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestFlatHashStrategy {
    private static final int FIXED_CHUNK_OFFSET = 11;
    private static final int VARIABLE_CHUNK_OFFSET = 17;
    private final TypeOperators typeOperators = new TypeOperators();
    private final FlatHashStrategyCompiler compiler = new FlatHashStrategyCompiler(this.typeOperators);

    TestFlatHashStrategy() {
    }

    @Test
    void test() {
        List<Type> bigTypeSet = TestFlatHashStrategy.createTestingTypes(this.typeOperators);
        for (int typeCount : List.of(Integer.valueOf(1), Integer.valueOf(500), Integer.valueOf(501), Integer.valueOf(999), Integer.valueOf(1000), Integer.valueOf(1001), Integer.valueOf(2000), Integer.valueOf(2001))) {
            List<Type> types = bigTypeSet.subList(0, typeCount);
            FlatHashStrategy flatHashStrategy = this.compiler.getFlatHashStrategy(types);
            Assertions.assertThat((boolean)flatHashStrategy.isAnyVariableWidth()).isEqualTo(types.stream().anyMatch(Type::isFlatVariableWidth));
            int flatFixedLength = flatHashStrategy.getTotalFlatFixedLength();
            Assertions.assertThat((int)flatFixedLength).isEqualTo(types.stream().mapToInt(Type::getFlatFixedSize).sum() + types.size());
            Block[] blocks = TestFlatHashStrategy.createRandomData(types, 10, 0.0f);
            for (int position : List.of(Integer.valueOf(0), Integer.valueOf(5), Integer.valueOf(9))) {
                int variableWidth = flatHashStrategy.getTotalVariableWidth(blocks, position);
                Assertions.assertThat((int)variableWidth).isEqualTo(TestFlatHashStrategy.manualGetTotalVariableWidth(types, blocks, position));
                Assertions.assertThat((long)flatHashStrategy.hash(blocks, position)).isEqualTo(this.manualHash(types, blocks, position));
                byte[] fixedChunk = new byte[flatFixedLength + 11];
                byte[] variableChunk = new byte[variableWidth + 17];
                flatHashStrategy.writeFlat(blocks, position, fixedChunk, 11, variableChunk, 17);
                Assertions.assertThat((byte[])fixedChunk).startsWith(new byte[11]);
                Assertions.assertThat((byte[])variableChunk).startsWith(new byte[17]);
                Assertions.assertThat((long)flatHashStrategy.hash(fixedChunk, 11, variableChunk)).isEqualTo(this.manualHash(types, blocks, position));
                Assertions.assertThat((boolean)flatHashStrategy.valueIdentical(fixedChunk, 11, variableChunk, blocks, position)).isTrue();
                Assertions.assertThat((boolean)flatHashStrategy.valueIdentical(fixedChunk, 11, variableChunk, blocks, 3)).isFalse();
                BlockBuilder[] blockBuilders = (BlockBuilder[])types.stream().map(type -> type.createBlockBuilder(null, 1)).toArray(BlockBuilder[]::new);
                flatHashStrategy.readFlat(fixedChunk, 11, variableChunk, blockBuilders);
                List<Block> output = Arrays.stream(blockBuilders).map(BlockBuilder::build).toList();
                Page actualPage = new Page((Block[])output.toArray(Block[]::new));
                Page expectedPage = new Page(blocks).getSingleValuePage(position);
                PageAssertions.assertPageEquals(types, actualPage, expectedPage);
            }
        }
    }

    @Test
    void testBatchedRawHashesZeroLength() {
        List<Type> types = TestFlatHashStrategy.createTestingTypes(this.typeOperators);
        FlatHashStrategy flatHashStrategy = this.compiler.getFlatHashStrategy(types);
        int positionCount = 10;
        Assertions.assertThatCode(() -> flatHashStrategy.hashBlocksBatched(new Block[types.size()], new long[positionCount], 0, 0)).doesNotThrowAnyException();
    }

    @Test
    void testBatchedRawHashesMatchSinglePositionHashes() {
        List<Type> types = TestFlatHashStrategy.createTestingTypes(this.typeOperators);
        FlatHashStrategy flatHashStrategy = this.compiler.getFlatHashStrategy(types);
        int positionCount = 1024;
        Block[] blocks = TestFlatHashStrategy.createRandomData(types, positionCount, 0.25f);
        long[] hashes = new long[positionCount];
        flatHashStrategy.hashBlocksBatched(blocks, hashes, 0, positionCount);
        this.assertHashesEqual(types, blocks, hashes, flatHashStrategy);
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = RunLengthEncodedBlock.create((Block)blocks[i].getSingleValueBlock(0), (int)positionCount);
        }
        flatHashStrategy.hashBlocksBatched(blocks, hashes, 0, positionCount);
        this.assertHashesEqual(types, blocks, hashes, flatHashStrategy);
        Assertions.assertThat((String)TestFlatHashStrategy.singleRowTypesAndValues(types, blocks, 0)).isNotNull();
    }

    private void assertHashesEqual(List<Type> types, Block[] blocks, long[] batchedHashes, FlatHashStrategy flatHashStrategy) {
        for (int position = 0; position < batchedHashes.length; ++position) {
            long manualRowHash = this.manualHash(types, blocks, position);
            long singleRowHash = flatHashStrategy.hash(blocks, position);
            Assertions.assertThat((long)singleRowHash).isEqualTo(manualRowHash);
            Assertions.assertThat((long)singleRowHash).isEqualTo(batchedHashes[position]);
        }
    }

    private static Block[] createRandomData(List<Type> types, int positionCount, float nullRate) {
        Block[] blocks = new Block[types.size()];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = BlockAssertions.createRandomBlockForType(types.get(i), positionCount, nullRate);
        }
        return blocks;
    }

    private static long manualGetTotalVariableWidth(List<Type> types, Block[] blocks, int position) {
        long totalVariableWidth = 0L;
        for (int i = 0; i < types.size(); ++i) {
            Type type = types.get(i);
            Block block = blocks[i];
            if (!type.isFlatVariableWidth() || block.isNull(position)) continue;
            totalVariableWidth += (long)type.getFlatVariableWidthSize(block, position);
        }
        return totalVariableWidth;
    }

    private long manualHash(List<Type> types, Block[] blocks, int position) {
        long manualRowHash = 0L;
        for (int i = 0; i < types.size(); ++i) {
            Type type = types.get(i);
            Block block = blocks[i];
            try {
                long fieldHash = 0L;
                if (!block.isNull(position)) {
                    fieldHash = this.typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION})).invoke(block, position);
                }
                manualRowHash = CombineHashFunction.getHash((long)manualRowHash, (long)fieldHash);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("Error hashing field " + String.valueOf(type), e);
            }
        }
        return manualRowHash;
    }

    private static List<Type> createTestingTypes(TypeOperators typeOperators) {
        List<Type> baseTypes = List.of(BigintType.BIGINT, BooleanType.BOOLEAN, CharType.createCharType((int)5), DecimalType.createDecimalType((int)18), DecimalType.createDecimalType((int)38), DoubleType.DOUBLE, IntegerType.INTEGER, IpAddressType.IPADDRESS, RealType.REAL, TimestampType.TIMESTAMP_SECONDS, TimestampType.TIMESTAMP_MILLIS, TimestampType.TIMESTAMP_MICROS, TimestampType.TIMESTAMP_NANOS, TimestampType.TIMESTAMP_PICOS, UuidType.UUID, VarbinaryType.VARBINARY, VarcharType.VARCHAR);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(baseTypes);
        builder.add((Object)RowType.anonymous(baseTypes));
        for (Type baseType : baseTypes) {
            builder.add((Object)new ArrayType(baseType));
            builder.add((Object)new MapType(baseType, baseType, typeOperators));
        }
        return Collections.nCopies(500, builder.build()).stream().flatMap(Collection::stream).limit(2001L).toList();
    }

    private static String singleRowTypesAndValues(List<Type> types, Block[] blocks, int position) {
        ConnectorSession connectorSession = TestingSession.testSessionBuilder().build().toConnectorSession();
        StringBuilder builder = new StringBuilder();
        int column = 0;
        for (Type type : types) {
            builder.append("\n\t");
            builder.append(type);
            builder.append(": ");
            builder.append(type.getObjectValue(connectorSession, blocks[column], position));
            ++column;
        }
        return builder.toString();
    }
}

