/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.AbstractTestDecimalAverageAggregation;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Type;
import java.math.BigDecimal;
import java.util.List;

public class TestLongDecimalAverageAggregation
extends AbstractTestDecimalAverageAggregation {
    private static final DecimalType LONG_DECIMAL_TYPE = DecimalType.createDecimalType((int)19, (int)2);

    @Override
    protected DecimalType getDecimalType() {
        return LONG_DECIMAL_TYPE;
    }

    @Override
    protected DecimalType getExpectedType() {
        return LONG_DECIMAL_TYPE;
    }

    @Override
    protected void writeDecimalToBlock(BigDecimal decimal, BlockBuilder blockBuilder) {
        LONG_DECIMAL_TYPE.writeObject(blockBuilder, (Object)Decimals.valueOf((BigDecimal)decimal));
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)LONG_DECIMAL_TYPE);
    }
}

