/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.join;

import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.block.BlockAssertions;
import io.trino.operator.DriverContext;
import io.trino.operator.TaskContext;
import io.trino.operator.join.JoinBridge;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.NestedLoopBuildOperator;
import io.trino.operator.join.NestedLoopJoinBridge;
import io.trino.operator.join.NestedLoopJoinPages;
import io.trino.operator.join.NestedLoopJoinPagesSupplier;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.testing.TestingTaskContext;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestNestedLoopBuildOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeAll
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-scheduledExecutor-%s")));
    }

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testNestedLoopBuild() throws Exception {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of((Object)BigintType.BIGINT);
        JoinBridgeManager nestedLoopJoinBridgeManager = new JoinBridgeManager(false, (JoinBridge)new NestedLoopJoinPagesSupplier(), (List)buildTypes);
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinBridgeManager);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        NestedLoopBuildOperator nestedLoopBuildOperator = (NestedLoopBuildOperator)nestedLoopBuildOperatorFactory.createOperator(driverContext);
        NestedLoopJoinBridge nestedLoopJoinBridge = (NestedLoopJoinBridge)nestedLoopJoinBridgeManager.getJoinBridge();
        Assertions.assertThat((boolean)nestedLoopJoinBridge.getPagesFuture().isDone()).isFalse();
        Page buildPage1 = new Page(3, new Block[]{BlockAssertions.createLongSequenceBlock(11, 14)});
        Page buildPageEmpty = new Page(0);
        Page buildPage2 = new Page(3000, new Block[]{BlockAssertions.createLongSequenceBlock(4000, 7000)});
        nestedLoopBuildOperator.addInput(buildPage1);
        nestedLoopBuildOperator.addInput(buildPageEmpty);
        nestedLoopBuildOperator.addInput(buildPage2);
        nestedLoopBuildOperator.finish();
        Assertions.assertThat((boolean)nestedLoopJoinBridge.getPagesFuture().isDone()).isTrue();
        List buildPages = ((NestedLoopJoinPages)nestedLoopJoinBridge.getPagesFuture().get()).getPages();
        Assertions.assertThat((Object)((Page)buildPages.get(0))).isEqualTo((Object)buildPage1);
        Assertions.assertThat((Object)((Page)buildPages.get(1))).isEqualTo((Object)buildPage2);
        Assertions.assertThat((List)buildPages).hasSize(2);
    }

    @Test
    public void testNestedLoopBuildNoBlock() throws Exception {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of();
        JoinBridgeManager nestedLoopJoinBridgeManager = new JoinBridgeManager(false, (JoinBridge)new NestedLoopJoinPagesSupplier(), (List)buildTypes);
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinBridgeManager);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        NestedLoopBuildOperator nestedLoopBuildOperator = (NestedLoopBuildOperator)nestedLoopBuildOperatorFactory.createOperator(driverContext);
        NestedLoopJoinBridge nestedLoopJoinBridge = (NestedLoopJoinBridge)nestedLoopJoinBridgeManager.getJoinBridge();
        Assertions.assertThat((boolean)nestedLoopJoinBridge.getPagesFuture().isDone()).isFalse();
        Page buildPage1 = new Page(3);
        Page buildPageEmpty = new Page(0);
        Page buildPage2 = new Page(3000);
        nestedLoopBuildOperator.addInput(buildPage1);
        nestedLoopBuildOperator.addInput(buildPageEmpty);
        nestedLoopBuildOperator.addInput(buildPage2);
        nestedLoopBuildOperator.finish();
        Assertions.assertThat((boolean)nestedLoopJoinBridge.getPagesFuture().isDone()).isTrue();
        List buildPages = ((NestedLoopJoinPages)nestedLoopJoinBridge.getPagesFuture().get()).getPages();
        Assertions.assertThat((List)buildPages).hasSize(1);
        Assertions.assertThat((int)((Page)buildPages.get(0)).getPositionCount()).isEqualTo(3003);
    }

    @Test
    public void testNestedLoopNoBlocksMaxSizeLimit() throws Exception {
        TaskContext taskContext = this.createTaskContext();
        ImmutableList buildTypes = ImmutableList.of();
        JoinBridgeManager nestedLoopJoinBridgeManager = new JoinBridgeManager(false, (JoinBridge)new NestedLoopJoinPagesSupplier(), (List)buildTypes);
        NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(3, new PlanNodeId("test"), nestedLoopJoinBridgeManager);
        DriverContext driverContext = taskContext.addPipelineContext(0, true, true, false).addDriverContext();
        NestedLoopBuildOperator nestedLoopBuildOperator = (NestedLoopBuildOperator)nestedLoopBuildOperatorFactory.createOperator(driverContext);
        NestedLoopJoinBridge nestedLoopJoinBridge = (NestedLoopJoinBridge)nestedLoopJoinBridgeManager.getJoinBridge();
        Assertions.assertThat((boolean)nestedLoopJoinBridge.getPagesFuture().isDone()).isFalse();
        Page massivePage = new Page(8292);
        nestedLoopBuildOperator.addInput(massivePage);
        nestedLoopBuildOperator.finish();
        Assertions.assertThat((boolean)nestedLoopJoinBridge.getPagesFuture().isDone()).isTrue();
        List buildPages = ((NestedLoopJoinPages)nestedLoopJoinBridge.getPagesFuture().get()).getPages();
        Assertions.assertThat((List)buildPages).hasSize(2);
        Assertions.assertThat((int)((Page)buildPages.get(0)).getPositionCount()).isEqualTo(8192);
        Assertions.assertThat((int)((Page)buildPages.get(1)).getPositionCount()).isEqualTo(100);
    }

    private TaskContext createTaskContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION);
    }
}

