/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.block.BlockAssertions;
import io.trino.jmh.Benchmarks;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.SqlFunction;
import io.trino.metadata.SqlScalarFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.scalar.ChoicesSpecializedSqlScalarFunction;
import io.trino.operator.scalar.SpecializedSqlScalarFunction;
import io.trino.spi.Page;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.gen.ExpressionCompiler;
import io.trino.sql.planner.Symbol;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.relational.LambdaDefinitionExpression;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import io.trino.sql.relational.VariableReferenceExpression;
import io.trino.testing.TestingConnectorSession;
import io.trino.type.FunctionType;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArrayFilter {
    private static final int POSITIONS = 100000;
    private static final int ARRAY_SIZE = 4;
    private static final int NUM_TYPES = 1;
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private static final List<Type> ROW_TYPES = ImmutableList.of((Object)RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE)));

    @Benchmark
    @OperationsPerInvocation(value=400000)
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    @Benchmark
    @OperationsPerInvocation(value=400000)
    public List<Optional<Page>> benchmarkObject(RowBenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    public static void main(String[] args) throws Exception {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        BenchmarkArrayFilter benchmarkArrayFilter = new BenchmarkArrayFilter();
        benchmarkArrayFilter.benchmark(data);
        RowBenchmarkData rowData = new RowBenchmarkData();
        rowData.setup();
        benchmarkArrayFilter.benchmarkObject(rowData);
        Benchmarks.benchmark(BenchmarkArrayFilter.class).withOptions(optionsBuilder -> optionsBuilder.jvmArgs(new String[]{"-Xmx4g"})).run();
    }

    static {
        Verify.verify((1 == TYPES.size() ? 1 : 0) != 0);
        Verify.verify((1 == ROW_TYPES.size() ? 1 : 0) != 0);
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"filter", "exact_filter"})
        private String name = "filter";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            TestingFunctionResolution functionResolution = new TestingFunctionResolution((FunctionBundle)InternalFunctionBundle.builder().function((SqlFunction)ExactArrayFilterFunction.EXACT_ARRAY_FILTER_FUNCTION).build());
            ExpressionCompiler compiler = functionResolution.getExpressionCompiler();
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            Block[] blocks = new Block[TYPES.size()];
            for (int i = 0; i < TYPES.size(); ++i) {
                Type elementType = TYPES.get(i);
                ArrayType arrayType = new ArrayType(elementType);
                ResolvedFunction resolvedFunction = functionResolution.resolveFunction(this.name, TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType, new FunctionType((List)ImmutableList.of((Object)BigintType.BIGINT), (Type)BooleanType.BOOLEAN)}));
                ResolvedFunction lessThan = functionResolution.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
                projectionsBuilder.add((Object)new CallExpression(resolvedFunction, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)arrayType), (Object)new LambdaDefinitionExpression((List)ImmutableList.of((Object)new Symbol((Type)BigintType.BIGINT, "x")), (RowExpression)new CallExpression(lessThan, (List)ImmutableList.of((Object)Expressions.constant((Object)0L, (Type)BigintType.BIGINT), (Object)new VariableReferenceExpression("x", (Type)BigintType.BIGINT)))))));
                blocks[i] = BenchmarkData.createChannel(100000, 4, arrayType);
            }
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(blocks);
        }

        private static Block createChannel(int positionCount, int arraySize, ArrayType arrayType) {
            ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                blockBuilder.buildEntry(elementBuilder -> {
                    for (int i = 0; i < arraySize; ++i) {
                        if (arrayType.getElementType().getJavaType() != Long.TYPE) {
                            throw new UnsupportedOperationException();
                        }
                        arrayType.getElementType().writeLong(elementBuilder, ThreadLocalRandom.current().nextLong());
                    }
                });
            }
            return blockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }

    @State(value=Scope.Thread)
    public static class RowBenchmarkData {
        @Param(value={"filter", "exact_filter"})
        private String name = "filter";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            TestingFunctionResolution functionResolution = new TestingFunctionResolution((FunctionBundle)InternalFunctionBundle.builder().function((SqlFunction)ExactArrayFilterObjectFunction.EXACT_ARRAY_FILTER_OBJECT_FUNCTION).build());
            ExpressionCompiler compiler = functionResolution.getExpressionCompiler();
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            Block[] blocks = new Block[ROW_TYPES.size()];
            for (int i = 0; i < ROW_TYPES.size(); ++i) {
                Type elementType = ROW_TYPES.get(i);
                ArrayType arrayType = new ArrayType(elementType);
                ResolvedFunction resolvedFunction = functionResolution.resolveFunction(this.name, TypeSignatureProvider.fromTypes((Type[])new Type[]{arrayType, new FunctionType(ROW_TYPES, (Type)BooleanType.BOOLEAN)}));
                ResolvedFunction lessThan = functionResolution.resolveOperator(OperatorType.LESS_THAN, (List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)BigintType.BIGINT));
                projectionsBuilder.add((Object)new CallExpression(resolvedFunction, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)arrayType), (Object)new LambdaDefinitionExpression((List)ImmutableList.of((Object)new Symbol(elementType, "x")), (RowExpression)new CallExpression(lessThan, (List)ImmutableList.of((Object)Expressions.constant((Object)0L, (Type)BigintType.BIGINT), (Object)new SpecialForm(SpecialForm.Form.DEREFERENCE, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)new VariableReferenceExpression("x", elementType), (Object)Expressions.constant((Object)0, (Type)IntegerType.INTEGER)), (List)ImmutableList.of())))))));
                blocks[i] = RowBenchmarkData.createChannel(100000, arrayType);
            }
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(blocks);
        }

        private static Block createChannel(int positionCount, ArrayType arrayType) {
            return BlockAssertions.createRandomBlockForType((Type)arrayType, positionCount, 0.2f);
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }

    public static final class ExactArrayFilterObjectFunction
    extends SqlScalarFunction {
        public static final ExactArrayFilterObjectFunction EXACT_ARRAY_FILTER_OBJECT_FUNCTION = new ExactArrayFilterObjectFunction();
        private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ExactArrayFilterObjectFunction.class, (String)"filterObject", (Class[])new Class[]{Type.class, Block.class, MethodHandle.class});

        private ExactArrayFilterObjectFunction() {
            super(FunctionMetadata.scalarBuilder((String)"exact_filter").signature(Signature.builder().typeVariable("T").returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{BooleanType.BOOLEAN.getTypeSignature()})).build()).nondeterministic().description("return array containing elements that match the given predicate").build());
        }

        protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
            Type type = ((ArrayType)boundSignature.getReturnType()).getElementType();
            return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), METHOD_HANDLE.bindTo(type));
        }

        public static Block filterObject(Type type, Block block, MethodHandle function) {
            int positionCount = block.getPositionCount();
            BlockBuilder resultBuilder = type.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                Boolean keep;
                Object input = type.getObject(block, position);
                try {
                    keep = function.invokeExact(input);
                }
                catch (Throwable t) {
                    Throwables.throwIfUnchecked((Throwable)t);
                    throw new RuntimeException(t);
                }
                if (!Boolean.TRUE.equals(keep)) continue;
                type.appendTo(block, position, resultBuilder);
            }
            return resultBuilder.build();
        }
    }

    public static final class ExactArrayFilterFunction
    extends SqlScalarFunction {
        public static final ExactArrayFilterFunction EXACT_ARRAY_FILTER_FUNCTION = new ExactArrayFilterFunction();
        private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ExactArrayFilterFunction.class, (String)"filter", (Class[])new Class[]{Type.class, Block.class, MethodHandle.class});

        private ExactArrayFilterFunction() {
            super(FunctionMetadata.scalarBuilder((String)"exact_filter").signature(Signature.builder().typeVariable("T").returnType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(TypeSignature.arrayType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]))).argumentType(TypeSignature.functionType((TypeSignature)new TypeSignature("T", new TypeSignatureParameter[0]), (TypeSignature[])new TypeSignature[]{BooleanType.BOOLEAN.getTypeSignature()})).build()).nondeterministic().description("return array containing elements that match the given predicate").build());
        }

        protected SpecializedSqlScalarFunction specialize(BoundSignature boundSignature) {
            Type type = ((ArrayType)boundSignature.getReturnType()).getElementType();
            return new ChoicesSpecializedSqlScalarFunction(boundSignature, InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL, (Object)InvocationConvention.InvocationArgumentConvention.NEVER_NULL), METHOD_HANDLE.bindTo(type));
        }

        public static Block filter(Type type, Block block, MethodHandle function) {
            int positionCount = block.getPositionCount();
            BlockBuilder resultBuilder = type.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                Boolean keep;
                Long input = (Long)TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
                try {
                    keep = function.invokeExact(input);
                }
                catch (Throwable t) {
                    Throwables.throwIfUnchecked((Throwable)t);
                    throw new RuntimeException(t);
                }
                if (!Boolean.TRUE.equals(keep)) continue;
                type.appendTo(block, position, resultBuilder);
            }
            return resultBuilder.build();
        }
    }
}

