/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.trino.SessionTestUtils;
import io.trino.block.BlockAssertions;
import io.trino.client.Column;
import io.trino.client.QueryDataDecoder;
import io.trino.client.Row;
import io.trino.client.spooling.DataAttributes;
import io.trino.client.spooling.encoding.JsonQueryDataDecoder;
import io.trino.server.protocol.OutputColumn;
import io.trino.server.protocol.ProtocolUtil;
import io.trino.server.protocol.spooling.QueryDataEncoder;
import io.trino.server.protocol.spooling.encoding.JsonQueryDataEncoder;
import io.trino.spi.Page;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJsonEncodingUtils {
    protected QueryDataDecoder createDecoder(List<Column> columns) {
        return new JsonQueryDataDecoder.Factory().create(columns, DataAttributes.empty());
    }

    protected QueryDataEncoder createEncoder(List<OutputColumn> columns) {
        return new JsonQueryDataEncoder.Factory().create(SessionTestUtils.TEST_SESSION, columns);
    }

    @Test
    public void testInvalidJson() throws IOException {
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)BigintType.BIGINT));
        this.assertInvalidJson((List<TypedColumn>)columns, "invalid", "Unrecognized token 'invalid'");
        this.assertInvalidJson((List<TypedColumn>)columns, "", "Expected start of an array, but got null");
        this.assertInvalidJson((List<TypedColumn>)columns, "[[]", "Unexpected token END_ARRAY");
        this.assertInvalidJson((List<TypedColumn>)columns, "[[", "Unexpected end-of-input");
        this.assertInvalidJson((List<TypedColumn>)columns, "[[5", "Unexpected end-of-input");
        this.assertInvalidJson((List<TypedColumn>)columns, "[[5]", "Unexpected end-of-input");
        this.assertInvalidJson((List<TypedColumn>)columns, "[[5],]", "Unexpected character (']' (code 93))");
        this.assertInvalidJson((List<TypedColumn>)columns, "[[5][]", "Unexpected character ('[' (code 91))");
        Assertions.assertThat(this.parseJson((List<TypedColumn>)columns, "[[5]]")).isEqualTo(List.of(List.of(Long.valueOf(5L))));
    }

    @Test
    public void testBigintSerialization() throws IOException {
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)BigintType.BIGINT));
        Page page = TestJsonEncodingUtils.page(new Block[]{BlockAssertions.createTypedLongsBlock((Type)BigintType.BIGINT, 1L, 2L, 3L, 4L)});
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[1],[2],[3],[4]]")).isEqualTo(TestJsonEncodingUtils.column(1L, 2L, 3L, 4L));
    }

    @Test
    public void testBigintArraySerialization() throws IOException {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)arrayType));
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 10);
        blockBuilder.buildEntry(builder -> {
            for (int i = 0; i < 10; ++i) {
                BigintType.BIGINT.writeLong(builder, (long)i);
            }
        });
        Page page = TestJsonEncodingUtils.page(blockBuilder.build());
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[[0,1,2,3,4,5,6,7,8,9]]]")).isEqualTo(TestJsonEncodingUtils.column(List.of(Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(4L), Long.valueOf(5L), Long.valueOf(6L), Long.valueOf(7L), Long.valueOf(8L), Long.valueOf(9L))));
    }

    @Test
    public void testIntegerSerialization() throws IOException {
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)IntegerType.INTEGER));
        Page page = TestJsonEncodingUtils.page(new Block[]{BlockAssertions.createIntsBlock(1, 2, 3, 4)});
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[1],[2],[3],[4]]")).isEqualTo(TestJsonEncodingUtils.column(1, 2, 3, 4));
    }

    @Test
    public void testIntegerArraySerialization() throws IOException {
        ArrayType arrayType = new ArrayType((Type)IntegerType.INTEGER);
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)arrayType));
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 10);
        blockBuilder.buildEntry(builder -> {
            for (int i = 0; i < 10; ++i) {
                IntegerType.INTEGER.writeLong(builder, (long)i);
            }
        });
        Page page = TestJsonEncodingUtils.page(blockBuilder.build());
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[[0,1,2,3,4,5,6,7,8,9]]]")).isEqualTo(TestJsonEncodingUtils.column(List.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7), Integer.valueOf(8), Integer.valueOf(9))));
    }

    @Test
    public void testTinyintSerialization() throws IOException {
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)TinyintType.TINYINT));
        Page page = TestJsonEncodingUtils.page(new Block[]{BlockAssertions.createTinyintsBlock(1, 2, 3, 4)});
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[1],[2],[3],[4]]")).isEqualTo(TestJsonEncodingUtils.column((byte)1, (byte)2, (byte)3, (byte)4));
    }

    @Test
    public void testTinyintArraySerialization() throws IOException {
        ArrayType arrayType = new ArrayType((Type)TinyintType.TINYINT);
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)arrayType));
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 5);
        blockBuilder.buildEntry(builder -> {
            for (int i = 0; i < 5; ++i) {
                TinyintType.TINYINT.writeLong(builder, (long)i);
            }
            builder.appendNull();
        });
        Page page = TestJsonEncodingUtils.page(blockBuilder.build());
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[[0,1,2,3,4,null]]]")).isEqualTo(TestJsonEncodingUtils.column(TestJsonEncodingUtils.array((byte)0, (byte)1, (byte)2, (byte)3, (byte)4, null)));
    }

    @Test
    public void testSmallintSerialization() throws IOException {
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)SmallintType.SMALLINT));
        Page page = TestJsonEncodingUtils.page(new Block[]{BlockAssertions.createSmallintsBlock(1, 2, 3, 4)});
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[1],[2],[3],[4]]")).isEqualTo(TestJsonEncodingUtils.column((short)1, (short)2, (short)3, (short)4));
    }

    @Test
    public void testSmallintArraySerialization() throws IOException {
        ArrayType arrayType = new ArrayType((Type)SmallintType.SMALLINT);
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)arrayType));
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 5);
        blockBuilder.buildEntry(builder -> {
            for (int i = 0; i < 5; ++i) {
                SmallintType.SMALLINT.writeLong(builder, (long)i);
            }
            builder.appendNull();
        });
        Page page = TestJsonEncodingUtils.page(blockBuilder.build());
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[[0,1,2,3,4,null]]]")).isEqualTo(TestJsonEncodingUtils.column(TestJsonEncodingUtils.array((short)0, (short)1, (short)2, (short)3, (short)4, null)));
    }

    @Test
    public void testDoubleSerialization() throws IOException {
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)DoubleType.DOUBLE));
        Page page = TestJsonEncodingUtils.page(new Block[]{BlockAssertions.createDoublesBlock(1.0, 2.11, 3.11, 4.13, Double.NaN)});
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[1.0],[2.11],[3.11],[4.13],[\"NaN\"]]")).isEqualTo(TestJsonEncodingUtils.column(1.0, 2.11, 3.11, 4.13, Double.NaN));
    }

    @Test
    public void testDoubleArraySerialization() throws IOException {
        ArrayType arrayType = new ArrayType((Type)DoubleType.DOUBLE);
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)arrayType));
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 5);
        blockBuilder.buildEntry(builder -> {
            for (int i = 0; i < 5; ++i) {
                DoubleType.DOUBLE.writeDouble(builder, (double)i);
            }
            builder.appendNull();
        });
        Page page = TestJsonEncodingUtils.page(blockBuilder.build());
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[[0.0,1.0,2.0,3.0,4.0,null]]]")).isEqualTo(TestJsonEncodingUtils.column(TestJsonEncodingUtils.array(0.0, 1.0, 2.0, 3.0, 4.0, null)));
    }

    @Test
    public void testRealSerialization() throws IOException {
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)RealType.REAL));
        Page page = TestJsonEncodingUtils.page(new Block[]{BlockAssertions.createBlockOfReals(Float.valueOf(1.0f), Float.valueOf(2.11f), Float.valueOf(3.11f), Float.valueOf(4.13f), Float.valueOf(Float.NaN))});
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[1.0],[2.11],[3.11],[4.13],[\"NaN\"]]")).isEqualTo(TestJsonEncodingUtils.column(Float.valueOf(1.0f), Float.valueOf(2.11f), Float.valueOf(3.11f), Float.valueOf(4.13f), Float.valueOf(Float.NaN)));
    }

    @Test
    public void testRealArraySerialization() throws IOException {
        ArrayType arrayType = new ArrayType((Type)RealType.REAL);
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)arrayType));
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 7);
        blockBuilder.buildEntry(builder -> {
            for (int i = 0; i < 5; ++i) {
                RealType.REAL.writeFloat(builder, (float)i);
            }
            builder.appendNull();
            RealType.REAL.writeFloat(builder, Float.NaN);
        });
        Page page = TestJsonEncodingUtils.page(blockBuilder.build());
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[[0.0,1.0,2.0,3.0,4.0,null,\"NaN\"]]]").getFirst()).containsExactly(new Object[]{TestJsonEncodingUtils.array(Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), null, Float.valueOf(Float.NaN))});
    }

    @Test
    public void testVarcharSerialization() throws IOException {
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)VarcharType.VARCHAR));
        Page page = TestJsonEncodingUtils.page(new Block[]{BlockAssertions.createStringsBlock("ala", "ma", "kota", "a", "kot", "ma", "ale", "", null)});
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[\"ala\"],[\"ma\"],[\"kota\"],[\"a\"],[\"kot\"],[\"ma\"],[\"ale\"],[\"\"],[null]]")).isEqualTo(TestJsonEncodingUtils.column("ala", "ma", "kota", "a", "kot", "ma", "ale", "", null));
    }

    @Test
    public void testVarcharUtf8Serialization() throws IOException {
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)VarcharType.VARCHAR));
        Page page = TestJsonEncodingUtils.page(new Block[]{BlockAssertions.createStringsBlock("\u6570\u636e\u5e94\u7528", "\"quoted\"", "za\u017c\u00f3\u0142\u0107 g\u0119\u015bl\u0105 ja\u017a\u0144", "\u0000\u0000\u0000", "\r\t\n", "\ud83e\udd83")});
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[\"\u6570\u636e\u5e94\u7528\"],[\"\\\"quoted\\\"\"],[\"za\u017c\u00f3\u0142\u0107 g\u0119\u015bl\u0105 ja\u017a\u0144\"],[\"\\u0000\\u0000\\u0000\"],[\"\\r\\t\\n\"],[\"\ud83e\udd83\"]]")).isEqualTo(TestJsonEncodingUtils.column("\u6570\u636e\u5e94\u7528", "\"quoted\"", "za\u017c\u00f3\u0142\u0107 g\u0119\u015bl\u0105 ja\u017a\u0144", "\u0000\u0000\u0000", "\r\t\n", "\ud83e\udd83"));
    }

    @Test
    public void testVarcharArraySerialization() throws IOException {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)arrayType));
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 6);
        blockBuilder.buildEntry(builder -> {
            for (int i = 0; i < 5; ++i) {
                VarcharType.VARCHAR.writeSlice(builder, Slices.utf8Slice((String)("kot" + i)));
            }
            builder.appendNull();
        });
        Page page = TestJsonEncodingUtils.page(blockBuilder.build());
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[[\"kot0\",\"kot1\",\"kot2\",\"kot3\",\"kot4\",null]]]").getFirst()).containsExactly(new Object[]{TestJsonEncodingUtils.array("kot0", "kot1", "kot2", "kot3", "kot4", null)});
    }

    @Test
    public void testCharSerialization() throws IOException {
        CharType charType = CharType.createCharType((int)5);
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)charType));
        Page page = TestJsonEncodingUtils.page(new Block[]{BlockAssertions.createCharsBlock(charType, List.of("ala", "ma", "kota"))});
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[\"ala  \"],[\"ma   \"],[\"kota \"]]")).isEqualTo(TestJsonEncodingUtils.column("ala  ", "ma   ", "kota "));
    }

    @Test
    public void testCharArraySerialization() throws IOException {
        CharType charType = CharType.createCharType((int)5);
        ArrayType arrayType = new ArrayType((Type)charType);
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)arrayType));
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 6);
        blockBuilder.buildEntry(builder -> {
            for (int i = 0; i < 5; ++i) {
                VarcharType.VARCHAR.writeSlice(builder, Slices.utf8Slice((String)("kot" + i)));
            }
            builder.appendNull();
        });
        Page page = TestJsonEncodingUtils.page(blockBuilder.build());
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[[\"kot0 \",\"kot1 \",\"kot2 \",\"kot3 \",\"kot4 \",null]]]").getFirst()).containsExactly(new Object[]{TestJsonEncodingUtils.array("kot0 ", "kot1 ", "kot2 ", "kot3 ", "kot4 ", null)});
    }

    @Test
    public void testBooleanSerialization() throws IOException {
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)BooleanType.BOOLEAN));
        Page page = TestJsonEncodingUtils.page(new Block[]{BlockAssertions.createBooleansBlock(true, true, true, false, false, true)});
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[true],[true],[true],[false],[false],[true]]")).isEqualTo(TestJsonEncodingUtils.column(true, true, true, false, false, true));
    }

    @Test
    public void testBooleanArraySerialization() throws IOException {
        ArrayType arrayType = new ArrayType((Type)BooleanType.BOOLEAN);
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)arrayType));
        ArrayBlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 6);
        blockBuilder.buildEntry(builder -> {
            for (int i = 0; i < 5; ++i) {
                BooleanType.BOOLEAN.writeBoolean(builder, i % 2 == 0);
            }
            builder.appendNull();
        });
        Page page = TestJsonEncodingUtils.page(blockBuilder.build());
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[[true,false,true,false,true,null]]]").getFirst()).containsExactly(new Object[]{TestJsonEncodingUtils.array(true, false, true, false, true, null)});
    }

    @Test
    public void testMapSerialization() throws IOException {
        MapType mapType = new MapType((Type)RealType.REAL, (Type)DoubleType.DOUBLE, new TypeOperators());
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)mapType));
        MapBlockBuilder blockBuilder = mapType.createBlockBuilder(null, 6);
        blockBuilder.buildEntry((keyBuilder, valueBuilder) -> {
            RealType.REAL.writeFloat(keyBuilder, 0.0f);
            DoubleType.DOUBLE.writeDouble(valueBuilder, 0.0);
            RealType.REAL.writeFloat(keyBuilder, 1.0f);
            DoubleType.DOUBLE.writeDouble(valueBuilder, 1.0);
            RealType.REAL.writeFloat(keyBuilder, 2.0f);
            DoubleType.DOUBLE.writeDouble(valueBuilder, 2.0);
            RealType.REAL.writeFloat(keyBuilder, 3.0f);
            DoubleType.DOUBLE.writeDouble(valueBuilder, 3.0);
            RealType.REAL.writeFloat(keyBuilder, 4.0f);
            DoubleType.DOUBLE.writeDouble(valueBuilder, 4.0);
            RealType.REAL.writeFloat(keyBuilder, 5.0f);
            valueBuilder.appendNull();
        });
        Page page = TestJsonEncodingUtils.page(blockBuilder.build());
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[{\"0.0\":0.0,\"1.0\":1.0,\"2.0\":2.0,\"3.0\":3.0,\"4.0\":4.0,\"5.0\":null}]]").getFirst()).containsExactly(new Object[]{TestJsonEncodingUtils.map(TestJsonEncodingUtils.entry(Float.valueOf(0.0f), 0.0), TestJsonEncodingUtils.entry(Float.valueOf(1.0f), 1.0), TestJsonEncodingUtils.entry(Float.valueOf(2.0f), 2.0), TestJsonEncodingUtils.entry(Float.valueOf(3.0f), 3.0), TestJsonEncodingUtils.entry(Float.valueOf(4.0f), 4.0), TestJsonEncodingUtils.entry(Float.valueOf(5.0f), null))});
    }

    @Test
    public void testMapOfVarbinaryKeysSerialization() throws IOException {
        MapType mapType = new MapType((Type)VarbinaryType.VARBINARY, (Type)DoubleType.DOUBLE, new TypeOperators());
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)mapType));
        MapBlockBuilder blockBuilder = mapType.createBlockBuilder(null, 6);
        blockBuilder.buildEntry((keyBuilder, valueBuilder) -> {
            VarbinaryType.VARBINARY.writeSlice(keyBuilder, Slices.utf8Slice((String)"value"));
            DoubleType.DOUBLE.writeDouble(valueBuilder, 0.0);
            VarbinaryType.VARBINARY.writeSlice(keyBuilder, Slices.utf8Slice((String)"value2"));
            valueBuilder.appendNull();
        });
        Page page = TestJsonEncodingUtils.page(blockBuilder.build());
        List<Object> values = this.roundTrip((List<TypedColumn>)columns, page, "[[{\"dmFsdWU=\":0.0,\"dmFsdWUy\":null}]]").getFirst();
        Assertions.assertThat((Object)values.getFirst()).isInstanceOf(Map.class);
        Map valuesMap = (Map)values.getFirst();
        Assertions.assertThat((Collection)((Collection)valuesMap.keySet().stream().map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).collect(ImmutableSet.toImmutableSet()))).containsExactlyInAnyOrder((Object[])new String[]{"value", "value2"});
    }

    @Test
    public void testRowSerialization() throws IOException {
        RowType rowType = RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"a", (Type)BigintType.BIGINT), RowType.field((String)"b", (Type)VarcharType.VARCHAR), RowType.field((String)"c", (Type)BooleanType.BOOLEAN)});
        ImmutableList columns = ImmutableList.of((Object)TypedColumn.typed("col0", (Type)rowType));
        RowBlockBuilder blockBuilder = rowType.createBlockBuilder(null, 2);
        blockBuilder.buildEntry(builders -> {
            BigintType.BIGINT.writeLong((BlockBuilder)builders.get(0), 1L);
            VarcharType.VARCHAR.writeSlice((BlockBuilder)builders.get(1), Slices.utf8Slice((String)"ala"));
            BooleanType.BOOLEAN.writeBoolean((BlockBuilder)builders.get(2), true);
        });
        blockBuilder.buildEntry(builders -> {
            ((BlockBuilder)builders.get(0)).appendNull();
            ((BlockBuilder)builders.get(1)).appendNull();
            ((BlockBuilder)builders.get(2)).appendNull();
        });
        Page page = TestJsonEncodingUtils.page(blockBuilder.build());
        Assertions.assertThat(this.roundTrip((List<TypedColumn>)columns, page, "[[[1,\"ala\",true]],[[null,null,null]]]")).containsExactly((Object[])new List[]{List.of(Row.builderWithExpectedSize((int)3).addField("a", (Object)1L).addField("b", (Object)"ala").addField("c", (Object)true).build()), List.of(Row.builderWithExpectedSize((int)3).addField("a", null).addField("b", null).addField("c", null).build())});
    }

    protected List<List<Object>> roundTrip(List<TypedColumn> columns, Page page, String expectedJson) throws IOException {
        QueryDataEncoder encoder = this.newEncoder(columns);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        encoder.encodeTo((OutputStream)output, List.of(page));
        Assertions.assertThat((String)output.toString(StandardCharsets.UTF_8)).isEqualTo(expectedJson);
        return ImmutableList.copyOf(this.parseJson(columns, output.toByteArray()));
    }

    protected void assertInvalidJson(List<TypedColumn> columns, String json, String expectedError) {
        Assertions.assertThatThrownBy(() -> this.parseJson(columns, json)).hasMessageContaining(expectedError);
    }

    protected List<List<Object>> parseJson(List<TypedColumn> columns, String json) throws IOException {
        return this.parseJson(columns, json.getBytes(StandardCharsets.UTF_8));
    }

    protected List<List<Object>> parseJson(List<TypedColumn> columns, byte[] json) throws IOException {
        QueryDataDecoder decoder = this.newDecoder(columns);
        return ImmutableList.copyOf((Iterator)decoder.decode((InputStream)new ByteArrayInputStream(json), null));
    }

    private QueryDataEncoder newEncoder(List<TypedColumn> types) {
        ImmutableList.Builder columns = ImmutableList.builderWithExpectedSize((int)types.size());
        for (int i = 0; i < types.size(); ++i) {
            TypedColumn typedColumn = types.get(i);
            columns.add((Object)new OutputColumn(i, typedColumn.name(), typedColumn.type()));
        }
        return this.createEncoder((List<OutputColumn>)columns.build());
    }

    private QueryDataDecoder newDecoder(List<TypedColumn> types) {
        ImmutableList.Builder columns = ImmutableList.builderWithExpectedSize((int)types.size());
        for (TypedColumn typedColumn : types) {
            columns.add((Object)ProtocolUtil.createColumn((String)typedColumn.name(), (Type)typedColumn.type(), (boolean)true));
        }
        return this.createDecoder((List<Column>)columns.build());
    }

    private static Page page(Block ... blocks) {
        return new Page(blocks);
    }

    private static <T> List<List<T>> column(T ... values) {
        return Arrays.stream(values).map(value -> {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            return list;
        }).collect(Collectors.toList());
    }

    private static <T> List<T> array(T ... values) {
        return Arrays.asList(values);
    }

    private static <K, V> Map<K, V> map(Entry<K, V> ... entries) {
        HashMap<K, V> values = new HashMap<K, V>();
        for (Entry<K, V> entry : entries) {
            values.put(entry.key(), entry.value());
        }
        return values;
    }

    static <K, V> Entry<K, V> entry(K key, V value) {
        return new Entry<K, V>(key, value);
    }

    record TypedColumn(String name, Type type) {
        public TypedColumn {
            Objects.requireNonNull(name, "name is null");
            Objects.requireNonNull(type, "type is null");
        }

        public static TypedColumn typed(String name, Type type) {
            return new TypedColumn(name, type);
        }
    }

    record Entry<K, V>(K key, V value) {
    }
}

