/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol.spooling;

import io.trino.server.protocol.spooling.PreferredQueryDataEncoderSelector;
import io.trino.server.protocol.spooling.QueryDataEncoders;
import io.trino.server.protocol.spooling.QueryDataEncodingConfig;
import io.trino.server.protocol.spooling.SpoolingEnabledConfig;
import io.trino.server.protocol.spooling.encoding.JsonQueryDataEncoder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TestPreferredQueryDataEncoderSelector {
    TestPreferredQueryDataEncoderSelector() {
    }

    @Test
    public void testNoEncoderWhenNoneIsMatching() {
        PreferredQueryDataEncoderSelector selector = new PreferredQueryDataEncoderSelector(new QueryDataEncoders(new SpoolingEnabledConfig().setEnabled(true), Set.of(new JsonQueryDataEncoder.Factory())));
        Assertions.assertThat((Optional)selector.select(List.of())).isEmpty();
        Assertions.assertThat((Optional)selector.select(List.of("json+zstd"))).isEmpty();
    }

    @Test
    public void testNoEncoder() {
        PreferredQueryDataEncoderSelector selector = new PreferredQueryDataEncoderSelector(new QueryDataEncoders(new SpoolingEnabledConfig().setEnabled(true), Set.of()));
        Assertions.assertThat((Optional)selector.select(List.of())).isEmpty();
        Assertions.assertThat((Optional)selector.select(List.of("json"))).isEmpty();
    }

    @Test
    public void testSingleMatchingEncoderIsPicked() {
        JsonQueryDataEncoder.Factory factory = new JsonQueryDataEncoder.Factory();
        PreferredQueryDataEncoderSelector selector = new PreferredQueryDataEncoderSelector(new QueryDataEncoders(new SpoolingEnabledConfig().setEnabled(true), Set.of(factory)));
        Assertions.assertThat((Optional)selector.select(List.of("json+zstd", "json"))).hasValue((Object)factory);
    }

    @Test
    public void testSingleMatchingEncoderFromMultipleIsPicked() {
        JsonQueryDataEncoder.Factory factory = new JsonQueryDataEncoder.Factory();
        PreferredQueryDataEncoderSelector selector = new PreferredQueryDataEncoderSelector(new QueryDataEncoders(new SpoolingEnabledConfig().setEnabled(true), Set.of(factory, new JsonQueryDataEncoder.ZstdFactory(new QueryDataEncodingConfig()))));
        Assertions.assertThat((Optional)selector.select(List.of("protobuf", "json", "json+zstd"))).hasValue((Object)factory);
    }

    @Test
    public void testSingleMatchingEncoderFromMultipleIsPickedInOrder() {
        JsonQueryDataEncoder.Factory factory = new JsonQueryDataEncoder.Factory();
        JsonQueryDataEncoder.ZstdFactory zstdFactory = new JsonQueryDataEncoder.ZstdFactory(new QueryDataEncodingConfig());
        PreferredQueryDataEncoderSelector selector = new PreferredQueryDataEncoderSelector(new QueryDataEncoders(new SpoolingEnabledConfig().setEnabled(true), Set.of(factory, zstdFactory)));
        Assertions.assertThat((Optional)selector.select(List.of("protobuf", "json+zstd", "json"))).hasValue((Object)zstdFactory);
    }
}

