/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.testing.ValidationAssertions;
import io.trino.sql.SqlEnvironmentConfig;
import jakarta.validation.constraints.AssertTrue;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestSqlEnvironmentConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((SqlEnvironmentConfig)ConfigAssertions.recordDefaults(SqlEnvironmentConfig.class)).setPath("").setDefaultCatalog(null).setDefaultSchema(null).setDefaultFunctionCatalog(null).setDefaultFunctionSchema(null).setForcedSessionTimeZone(null));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"sql.path", (Object)"a.b, c.d, memory.functions").put((Object)"sql.default-catalog", (Object)"some-catalog").put((Object)"sql.default-schema", (Object)"some-schema").put((Object)"sql.default-function-catalog", (Object)"memory").put((Object)"sql.default-function-schema", (Object)"functions").put((Object)"sql.forced-session-time-zone", (Object)"UTC").buildOrThrow();
        SqlEnvironmentConfig expected = new SqlEnvironmentConfig().setPath("a.b, c.d, memory.functions").setDefaultCatalog("some-catalog").setDefaultSchema("some-schema").setDefaultFunctionCatalog("memory").setDefaultFunctionSchema("functions").setForcedSessionTimeZone("UTC");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test
    public void testInvalidPath() {
        ValidationAssertions.assertFailsValidation((Object)new SqlEnvironmentConfig().setPath("too.many.parts"), (String)"sqlPathValid", (String)"sql.path must be a valid SQL path", AssertTrue.class);
    }

    @Test
    public void testFunctionCatalogSetWithoutSchema() {
        ValidationAssertions.assertFailsValidation((Object)new SqlEnvironmentConfig().setDefaultFunctionCatalog("memory"), (String)"bothFunctionCatalogAndSchemaSet", (String)"sql.default-function-catalog and sql.default-function-schema must be set together", AssertTrue.class);
    }

    @Test
    public void testFunctionSchemaSetWithoutCatalog() {
        ValidationAssertions.assertFailsValidation((Object)new SqlEnvironmentConfig().setDefaultFunctionSchema("functions"), (String)"bothFunctionCatalogAndSchemaSet", (String)"sql.default-function-catalog and sql.default-function-schema must be set together", AssertTrue.class);
    }

    @Test
    public void testFunctionSchemaNotInSqlPath() {
        ValidationAssertions.assertFailsValidation((Object)new SqlEnvironmentConfig().setDefaultFunctionCatalog("memory").setDefaultFunctionSchema("functions"), (String)"functionSchemaInSqlPath", (String)"default function schema must be in the default SQL path", AssertTrue.class);
    }
}

