/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.FullConnectorSession;
import io.trino.jmh.Benchmarks;
import io.trino.operator.project.SelectedPositions;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeUtils;
import io.trino.sql.gen.columnar.FilterEvaluator;
import io.trino.testing.TestingSession;
import io.trino.util.DynamicFiltersTestUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=2)
@Warmup(iterations=5, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkDynamicPageFilter {
    private static final int MAX_ROWS = 200000;
    private static final FullConnectorSession FULL_CONNECTOR_SESSION = new FullConnectorSession(TestingSession.testSessionBuilder().build(), ConnectorIdentity.ofUser((String)"test"));
    @Param(value={"0.05"})
    public double inputNullChance = 0.05;
    @Param(value={"0.2"})
    public double nonNullsSelectivity = 0.2;
    @Param(value={"100", "1000", "5000"})
    public int filterSize = 100;
    @Param(value={"false"})
    public boolean nullsAllowed;
    @Param(value={"INT32_RANDOM", "INT64_RANDOM", "INT64_FIXED_32K", "REAL_RANDOM"})
    public DataSet inputDataSet;
    private List<Page> inputData;
    private FilterEvaluator filterEvaluator;

    @Setup
    public void setup() {
        TupleDomain<ColumnHandle> filterPredicate = this.inputDataSet.createFilterTupleDomain(this.filterSize, this.nullsAllowed);
        this.inputData = this.inputDataSet.createInputTestData(filterPredicate, this.inputNullChance, this.nonNullsSelectivity, 200000L);
        this.filterEvaluator = DynamicFiltersTestUtil.createDynamicFilterEvaluator(filterPredicate, (Map<ColumnHandle, Integer>)ImmutableMap.of((Object)new TestingColumnHandle("dummy"), (Object)0), 1.0);
    }

    @Benchmark
    public double filterPages() {
        long rowsProcessed = 0L;
        long rowsFiltered = 0L;
        for (Page page : this.inputData) {
            FilterEvaluator.SelectionResult result = this.filterEvaluator.evaluate((ConnectorSession)FULL_CONNECTOR_SESSION, SelectedPositions.positionsRange((int)0, (int)page.getPositionCount()), page);
            SelectedPositions selectedPositions = result.selectedPositions();
            int selectedPositionCount = selectedPositions.size();
            rowsProcessed += (long)page.getPositionCount();
            rowsFiltered += (long)(page.getPositionCount() - selectedPositionCount);
        }
        return (double)rowsFiltered / (double)rowsProcessed * 100.0;
    }

    private static List<Page> createSingleColumnData(ValueWriter valueWriter, Type type, double nullChance, long rows) {
        ImmutableList.Builder pages = ImmutableList.builder();
        Random random = new Random(32167L);
        int batchSize = 1;
        BlockBuilder blockBuilder = type.createBlockBuilder(null, batchSize);
        int i = 0;
        while ((long)i < rows) {
            if (BenchmarkDynamicPageFilter.isTrue(random, nullChance)) {
                blockBuilder.appendNull();
            } else {
                valueWriter.write(blockBuilder, random);
            }
            if (blockBuilder.getPositionCount() >= batchSize) {
                Block block = blockBuilder.build();
                pages.add((Object)new Page(new Block[]{new LazyBlock(block.getPositionCount(), () -> block)}));
                batchSize = Math.min(1024, batchSize * 2);
                blockBuilder = type.createBlockBuilder(null, batchSize);
            }
            ++i;
        }
        if (blockBuilder.getPositionCount() > 0) {
            Block block = blockBuilder.build();
            pages.add((Object)new Page(new Block[]{new LazyBlock(block.getPositionCount(), () -> block)}));
        }
        return pages.build();
    }

    private static boolean isTrue(Random random, double chance) {
        double value = 0.0;
        while (value == 0.0) {
            value = random.nextDouble();
        }
        return value < chance;
    }

    public static void main(String[] args) throws Throwable {
        Benchmarks.benchmark(BenchmarkDynamicPageFilter.class, (WarmupMode)WarmupMode.BULK).withOptions(optionsBuilder -> optionsBuilder.jvmArgsAppend(new String[]{"-Xmx4g", "-Xms4g"})).run();
    }

    public static enum DataSet {
        INT32_RANDOM((Type)IntegerType.INTEGER, (block, r) -> IntegerType.INTEGER.writeLong(block, (long)r.nextInt())),
        INT64_RANDOM((Type)BigintType.BIGINT, (block, r) -> BigintType.BIGINT.writeLong(block, r.nextLong())),
        INT64_FIXED_32K((Type)BigintType.BIGINT, (block, r) -> BigintType.BIGINT.writeLong(block, r.nextLong() % 32768L)),
        REAL_RANDOM((Type)RealType.REAL, (block, r) -> RealType.REAL.writeLong(block, (long)Float.floatToIntBits(r.nextFloat())));

        private final Type type;
        private final ValueWriter valueWriter;

        private DataSet(Type type, ValueWriter valueWriter) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.valueWriter = Objects.requireNonNull(valueWriter, "valueWriter is null");
        }

        public TupleDomain<ColumnHandle> createFilterTupleDomain(int filterSize, boolean nullsAllowed) {
            List<Page> filterValues = BenchmarkDynamicPageFilter.createSingleColumnData(this.valueWriter, this.type, 0.0, filterSize);
            ImmutableList.Builder valuesBuilder = ImmutableList.builder();
            for (Page page : filterValues) {
                Block block = page.getBlock(0).getLoadedBlock();
                for (int position = 0; position < block.getPositionCount(); ++position) {
                    valuesBuilder.add(TypeUtils.readNativeValue((Type)this.type, (Block)block, (int)position));
                }
            }
            return TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)new TestingColumnHandle("dummy"), (Object)Domain.create((ValueSet)ValueSet.copyOf((Type)this.type, (Collection)valuesBuilder.build()), (boolean)nullsAllowed)));
        }

        private List<Page> createInputTestData(TupleDomain<ColumnHandle> filter, double inputNullChance, double nonNullsSelectivity, long inputRows) {
            List nonNullValues = (List)((Map)filter.getDomains().orElseThrow()).values().stream().flatMap(domain -> {
                Domain.DiscreteSet nullableDiscreteSet = domain.getNullableDiscreteSet();
                return nullableDiscreteSet.getNonNullValues().stream();
            }).collect(ImmutableList.toImmutableList());
            return BenchmarkDynamicPageFilter.createSingleColumnData((block, r) -> {
                if (BenchmarkDynamicPageFilter.isTrue(r, nonNullsSelectivity)) {
                    Object value = nonNullValues.get(r.nextInt(nonNullValues.size()));
                    TypeUtils.writeNativeValue((Type)this.type, (BlockBuilder)block, value);
                    return;
                }
                this.valueWriter.write(block, r);
            }, this.type, inputNullChance, inputRows);
        }
    }

    @FunctionalInterface
    private static interface ValueWriter {
        public void write(BlockBuilder var1, Random var2);
    }
}

