/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.ir.optimizer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.ir.Call;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.ir.optimizer.rule.EvaluateCallWithNullInput;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEvaluateCallWithNullInput {
    @Test
    void test() {
        ResolvedFunction strpos = new TestingFunctionResolution().resolveFunction("strpos", TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR}));
        Assertions.assertThat(this.optimize((Expression)new Call(strpos, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "x"), (Object)new Constant((Type)VarcharType.VARCHAR, null))))).isEqualTo(Optional.of(new Constant((Type)BigintType.BIGINT, null)));
        Assertions.assertThat(this.optimize((Expression)new Call(strpos, (List)ImmutableList.of((Object)new Reference((Type)VarcharType.VARCHAR, "x"), (Object)new Reference((Type)VarcharType.VARCHAR, "y"))))).isEqualTo(Optional.empty());
    }

    private Optional<Expression> optimize(Expression expression) {
        return new EvaluateCallWithNullInput().apply(expression, TestingSession.testSession(), (Map)ImmutableMap.of());
    }
}

