/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import io.trino.Session;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.ir.Comparison;
import io.trino.sql.ir.Constant;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import org.junit.jupiter.api.Test;

public class TestRemoveDuplicatePredicates
extends BasePlanTest {
    @Test
    public void testAnd() {
        this.assertPlan("SELECT * FROM (VALUES 1) t(a) WHERE a = 1 AND 1 = a AND a = 1", this.disablePushFilterIntoValues(), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "A"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), PlanMatchPattern.values("A"))));
    }

    @Test
    public void testOr() {
        this.assertPlan("SELECT * FROM (VALUES 1) t(a) WHERE a = 1 OR 1 = a OR a = 1", this.disablePushFilterIntoValues(), PlanMatchPattern.anyTree(PlanMatchPattern.filter((Expression)new Comparison(Comparison.Operator.EQUAL, (Expression)new Reference((Type)IntegerType.INTEGER, "A"), (Expression)new Constant((Type)IntegerType.INTEGER, (Object)1L)), PlanMatchPattern.values("A"))));
    }

    private Session disablePushFilterIntoValues() {
        return Session.builder((Session)this.getPlanTester().getDefaultSession()).setSystemProperty("push_filter_into_values_max_row_count", "0").build();
    }
}

