/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.AggregationMatcher;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.GroupIdNode;
import io.trino.sql.planner.plan.PlanNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class GroupIdMatcher
implements Matcher {
    private final List<List<String>> groupingSets;
    private final Map<String, String> groupingColumns;
    private final List<String> aggregationArguments;
    private final String groupIdSymbol;

    public GroupIdMatcher(List<List<String>> groupingSets, Map<String, String> groupingColumns, List<String> aggregationArguments, String groupIdSymbol) {
        this.groupingSets = groupingSets;
        this.groupingColumns = ImmutableMap.copyOf(groupingColumns);
        this.aggregationArguments = aggregationArguments;
        this.groupIdSymbol = groupIdSymbol;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof GroupIdNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        GroupIdNode groupIdNode = (GroupIdNode)node;
        List actualGroupingSets = groupIdNode.getGroupingSets();
        List actualAggregationArguments = groupIdNode.getAggregationArguments();
        if (actualGroupingSets.size() != this.groupingSets.size()) {
            return MatchResult.NO_MATCH;
        }
        SymbolAliases.Builder newAliases = SymbolAliases.builder().put(this.groupIdSymbol, groupIdNode.getGroupIdSymbol().toSymbolReference());
        for (int i = 0; i < actualGroupingSets.size(); ++i) {
            List<String> expectedGroupingSet = this.groupingSets.get(i);
            List actualGroupingSet = (List)actualGroupingSets.get(i);
            if (!AggregationMatcher.matches((Collection)expectedGroupingSet.stream().map(symbol -> this.groupingColumns.getOrDefault(symbol, (String)symbol)).collect(ImmutableList.toImmutableList()), (Collection)actualGroupingSet.stream().map(symbol -> groupIdNode.getGroupingColumns().getOrDefault(symbol, symbol)).collect(ImmutableList.toImmutableList()), symbolAliases)) {
                return MatchResult.NO_MATCH;
            }
            for (int j = 0; j < expectedGroupingSet.size(); ++j) {
                String expectedGroupingSetSymbol = expectedGroupingSet.get(j);
                if (this.groupingColumns.getOrDefault(expectedGroupingSetSymbol, expectedGroupingSetSymbol).equals(expectedGroupingSetSymbol)) continue;
                newAliases.put(expectedGroupingSetSymbol, ((Symbol)actualGroupingSet.get(j)).toSymbolReference());
            }
        }
        if (!AggregationMatcher.matches(this.aggregationArguments, actualAggregationArguments, symbolAliases)) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match(newAliases.build());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("groupingSets", this.groupingSets).add("aggregationArguments", this.aggregationArguments).add("groupIdSymbol", (Object)this.groupIdSymbol).toString();
    }
}

