/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.assertions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.cost.StatsProvider;
import io.trino.metadata.Metadata;
import io.trino.sql.ir.Expression;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.MatchResult;
import io.trino.sql.planner.assertions.Matcher;
import io.trino.sql.planner.assertions.SymbolAliases;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableExecuteNode;
import java.util.List;

public class TableExecuteMatcher
implements Matcher {
    private final List<String> columns;
    private final List<String> columnNames;

    public TableExecuteMatcher(List<String> columns, List<String> columnNames) {
        this.columns = columns;
        this.columnNames = columnNames;
    }

    @Override
    public boolean shapeMatches(PlanNode node) {
        return node instanceof TableExecuteNode;
    }

    @Override
    public MatchResult detailMatches(PlanNode node, StatsProvider stats, Session session, Metadata metadata, SymbolAliases symbolAliases) {
        Preconditions.checkState((boolean)this.shapeMatches(node), (String)"Plan testing framework error: shapeMatches returned false in detailMatches in %s", (Object)this.getClass().getName());
        TableExecuteNode tableExecuteNode = (TableExecuteNode)node;
        if (!tableExecuteNode.getColumnNames().equals(this.columnNames)) {
            return MatchResult.NO_MATCH;
        }
        if (!((ImmutableList)this.columns.stream().map(symbol -> Symbol.from((Expression)symbolAliases.get((String)symbol))).collect(ImmutableList.toImmutableList())).equals((Object)tableExecuteNode.getColumns())) {
            return MatchResult.NO_MATCH;
        }
        return MatchResult.match();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columns", this.columns).add("columnNames", this.columnNames).toString();
    }
}

