/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.session.PropertyMetadata;
import io.trino.sql.query.QueryAssertions;
import io.trino.sql.query.TestInlineFunctions;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestInlineSession {
    private static final String MOCK_CATALOG = "mock";
    private final QueryAssertions assertions;

    public TestInlineSession() {
        Session session = TestingSession.testSessionBuilder().setCatalog("test_catalog").setSchema("tiny").build();
        StandaloneQueryRunner runner = new StandaloneQueryRunner(session);
        MockConnectorPlugin mockConnectorPlugin = new MockConnectorPlugin(MockConnectorFactory.builder().withSessionProperty(PropertyMetadata.stringProperty((String)"catalog_property", (String)"Test catalog property", (String)"", (boolean)false)).build());
        runner.installPlugin((Plugin)mockConnectorPlugin);
        runner.createCatalog(MOCK_CATALOG, MOCK_CATALOG, (Map)ImmutableMap.of());
        runner.installPlugin((Plugin)new TpchPlugin());
        runner.createCatalog("test_catalog", "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        runner.installPlugin((Plugin)new TestInlineFunctions.TestingLanguageEnginePlugin());
        this.assertions = new QueryAssertions((QueryRunner)runner);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    public void testInlineSession() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH SESSION time_zone_id = 'Europe/Wonderland' SELECT current_timezone()"))).failure().hasMessageContaining("Time zone not supported: Europe/Wonderland");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH SESSION time_zone_id = 'Europe/Warsaw' SELECT current_timezone()"))).matches("VALUES CAST('Europe/Warsaw' AS varchar)");
        Session session = this.assertions.sessionBuilder().setSystemProperty("time_zone_id", "America/Los_Angeles").build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query(session, "WITH SESSION time_zone_id = 'Europe/Warsaw' SELECT current_timezone()"))).matches("VALUES CAST('Europe/Warsaw' AS varchar)");
    }

    @Test
    public void testInlineSessionAndSqlFunctions() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH\n  SESSION time_zone_id = 'Europe/Warsaw'\nWITH\n  FUNCTION foo() RETURNS varchar RETURN current_timezone()\nSELECT foo()\n"))).matches("VALUES CAST('Europe/Warsaw' AS varchar)");
    }

    @Test
    void testValidSystemSessionProperties() {
        Assertions.assertThat((Map)this.assertions.execute("WITH SESSION query_max_total_memory = '10GB' SELECT 1").getSession().getSystemProperties()).isEqualTo(Map.of("query_max_total_memory", "10GB"));
        Assertions.assertThat((Map)this.assertions.execute("WITH SESSION query_max_total_memory = CAST('10GB' AS VARCHAR) SELECT 1").getSession().getSystemProperties()).isEqualTo(Map.of("query_max_total_memory", "10GB"));
    }

    @Test
    void testValidCatalogSessionProperty() {
        Assertions.assertThat((Map)this.assertions.execute("WITH SESSION mock.catalog_property = 'true' SELECT 1").getSession().getCatalogProperties(MOCK_CATALOG)).isEqualTo(Map.of("catalog_property", "true"));
        Assertions.assertThat((Map)this.assertions.execute("WITH SESSION mock.catalog_property = CAST(true AS varchar) SELECT 1").getSession().getCatalogProperties(MOCK_CATALOG)).isEqualTo(Map.of("catalog_property", "true"));
    }

    @Test
    void testInvalidSessionProperty() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH SESSION test.schema.invalid_key = 'invalid_value' SELECT 1"))).failure().hasMessageContaining("line 1:14: Invalid session property 'test.schema.invalid_key'");
    }

    @Test
    void testInvalidSystemSessionProperties() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH SESSION invalid_key = 'invalid_value' SELECT 1"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_SESSION_PROPERTY}).hasMessageContaining("line 1:28: Session property 'invalid_key' does not exist");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH SESSION query_max_total_memory = 'invalid_value' SELECT 1"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_SESSION_PROPERTY}).hasMessageContaining("line 1:39: size is not a valid data size string: invalid_value");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH SESSION query_max_total_memory = '10GB', query_max_total_memory = '16GB' SELECT 1"))).failure().hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_SESSION_PROPERTY}).hasMessageContaining("line 1:47: Session property 'query_max_total_memory' already set");
    }

    @Test
    void testInvalidCatalogSessionProperties() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH SESSION mock.invalid_key = 'invalid_value' SELECT 1"))).failure().hasMessageContaining("line 1:33: Session property 'mock.invalid_key' does not exist");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH SESSION mock.catalog_property = true SELECT 1"))).failure().hasMessageContaining("Unable to set session property 'mock.catalog_property' to 'true': Cannot cast type boolean to varchar");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("WITH SESSION mock.catalog_property = 'true', mock.catalog_property = 'false' SELECT 1"))).failure().hasMessageContaining("line 1:46: Session property 'mock.catalog_property' already set");
    }
}

