/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import io.trino.sql.query.QueryAssertions;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestWindow {
    private final QueryAssertions assertions = new QueryAssertions();

    @AfterAll
    public void teardown() {
        this.assertions.close();
    }

    @Test
    @Timeout(value=10L)
    public void testManyFunctionsWithSameWindow() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT\n          SUM(a) OVER w,\n          COUNT(a) OVER w,\n          MIN(a) OVER w,\n          MAX(a) OVER w,\n          SUM(b) OVER w,\n          COUNT(b) OVER w,\n          MIN(b) OVER w,\n          MAX(b) OVER w,\n          SUM(c) OVER w,\n          COUNT(c) OVER w,\n          MIN(c) OVER w,\n          MAX(c) OVER w,\n          SUM(d) OVER w,\n          COUNT(d) OVER w,\n          MIN(d) OVER w,\n          MAX(d) OVER w,\n          SUM(e) OVER w,\n          COUNT(e) OVER w,\n          MIN(e) OVER w,\n          MAX(e) OVER w,\n          SUM(f) OVER w,\n          COUNT(f) OVER w,\n          MIN(f) OVER w,\n          MAX(f) OVER w\n        FROM (\n            VALUES (1, 1, 1, 1, 1, 1, 1)\n        ) AS t(k, a, b, c, d, e, f)\n        WINDOW w AS (ORDER BY k ROWS BETWEEN 2 PRECEDING AND CURRENT ROW)\n"))).matches("VALUES (BIGINT '1', BIGINT '1', 1, 1, BIGINT '1', BIGINT '1', 1, 1, BIGINT '1', BIGINT '1', 1, 1, BIGINT '1', BIGINT '1', 1, 1, BIGINT '1', BIGINT '1', 1, 1, BIGINT '1', BIGINT '1', 1, 1)");
    }

    @Test
    public void testWindowWithOrderBy() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, ARRAY_AGG(c ORDER BY c) OVER w\nFROM (\n    VALUES (1, 1, 1), (1, 2, 2), (1, 3, 3), (1, 4, 4), (1, 4, 7), (1, 5, 5),\n           (2, 1, 1), (2, 2, 3), (2, 3, 2), (2, 4, 1)) AS t(a, b, c)\nWINDOW w AS (PARTITION BY a ORDER BY b)\n"))).matches("VALUES\n    (1, ARRAY[1]),\n    (1, ARRAY[1, 2]),\n    (1, ARRAY[1, 2, 3]),\n    (1, ARRAY[1, 2, 3, 4, 7]),\n    (1, ARRAY[1, 2, 3, 4, 7]),\n    (1, ARRAY[1, 2, 3, 4, 5, 7]),\n    (2, ARRAY[1]),\n    (2, ARRAY[1, 3]),\n    (2, ARRAY[1, 2, 3]),\n    (2, ARRAY[1, 1, 2, 3])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, ARRAY_AGG(c ORDER BY c DESC) OVER w\nFROM (\n    VALUES (1, 1, 1), (1, 2, 2), (1, 3, 3), (1, 4, 4), (1, 4, 7), (1, 5, 5),\n           (2, 1, 1), (2, 2, 3), (2, 3, 2), (2, 4, 1)) AS t(a, b, c)\nWINDOW w AS (PARTITION BY a ORDER BY b)\n"))).matches("VALUES\n    (1, ARRAY[1]),\n    (1, ARRAY[2, 1]),\n    (1, ARRAY[3, 2, 1]),\n    (1, ARRAY[7, 4, 3, 2, 1]),\n    (1, ARRAY[7, 4, 3, 2, 1]),\n    (1, ARRAY[7, 5, 4, 3, 2, 1]),\n    (2, ARRAY[1]),\n    (2, ARRAY[3, 1]),\n    (2, ARRAY[3, 2, 1]),\n    (2, ARRAY[3, 2, 1, 1])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, ARRAY_AGG(c ORDER BY d) OVER w\nFROM (\n    VALUES (1, 1, 1, 5), (1, 2, 2, 4), (1, 3, 3, 1), (1, 4, 4, 2), (1, 4, 7, 6), (1, 5, 5, 3),\n           (2, 1, 1, 4), (2, 2, 3, 3), (2, 3, 2, 2), (2, 4, 1, 1)) AS t(a, b, c, d)\nWINDOW w AS (PARTITION BY a ORDER BY b)\n"))).matches("VALUES\n    (1, ARRAY[1]),\n    (1, ARRAY[2, 1]),\n    (1, ARRAY[3, 2, 1]),\n    (1, ARRAY[3, 4, 2, 1, 7]),\n    (1, ARRAY[3, 4, 2, 1, 7]),\n    (1, ARRAY[3, 4, 5, 2, 1, 7]),\n    (2, ARRAY[1]),\n    (2, ARRAY[3, 1]),\n    (2, ARRAY[2, 3, 1]),\n    (2, ARRAY[1, 2, 3, 1])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, ARRAY_AGG(c ORDER BY b) OVER w\nFROM (\n    VALUES (1, 1, 1), (1, 2, 2), (1, 3, 3), (1, 4, 4), (1, 5, 5),\n           (2, 1, 1), (2, 2, 3), (2, 3, 2), (2, 4, 1)) AS t(a, b, c)\nWINDOW w AS (PARTITION BY a ORDER BY b)\n"))).matches("VALUES\n    (1, ARRAY[1]),\n    (1, ARRAY[1, 2]),\n    (1, ARRAY[1, 2, 3]),\n    (1, ARRAY[1, 2, 3, 4]),\n    (1, ARRAY[1, 2, 3, 4, 5]),\n    (2, ARRAY[1]),\n    (2, ARRAY[1, 3]),\n    (2, ARRAY[1, 3, 2]),\n    (2, ARRAY[1, 3, 2, 1])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, ARRAY_AGG(c ORDER BY b DESC) OVER w\nFROM (\n    VALUES (1, 1, 1), (1, 2, 2), (1, 3, 3), (1, 4, 4), (1, 5, 5),\n           (2, 1, 1), (2, 2, 3), (2, 3, 2), (2, 4, 1)) AS t(a, b, c)\nWINDOW w AS (PARTITION BY a ORDER BY b)\n"))).matches("VALUES\n    (1, ARRAY[1]),\n    (1, ARRAY[2, 1]),\n    (1, ARRAY[3, 2, 1]),\n    (1, ARRAY[4, 3, 2, 1]),\n    (1, ARRAY[5, 4, 3, 2, 1]),\n    (2, ARRAY[1]),\n    (2, ARRAY[3, 1]),\n    (2, ARRAY[2, 3, 1]),\n    (2, ARRAY[1, 2, 3, 1])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, ARRAY_AGG(c ORDER BY d, c) OVER w\nFROM (\n    VALUES (1, 1, 1, 5), (1, 2, 2, 4), (1, 3, 3, 4), (1, 4, 4, 5), (1, 4, 7, 1), (1, 5, 5, 2)) AS t(a, b, c, d)\nWINDOW w AS (PARTITION BY a ORDER BY b)\n"))).matches("VALUES\n    (1, ARRAY[1]),\n    (1, ARRAY[2, 1]),\n    (1, ARRAY[2, 3, 1]),\n    (1, ARRAY[7, 2, 3, 1, 4]),\n    (1, ARRAY[7, 2, 3, 1, 4]),\n    (1, ARRAY[7, 5, 2, 3, 1, 4])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, ARRAY_AGG(c ORDER BY d, c DESC) OVER w\nFROM (\n    VALUES (1, 1, 1, 5), (1, 2, 2, 4), (1, 3, 3, 4), (1, 4, 4, 5), (1, 4, 7, 1), (1, 5, 5, 2)) AS t(a, b, c, d)\nWINDOW w AS (PARTITION BY a ORDER BY b)\n"))).matches("VALUES\n    (1, ARRAY[1]),\n    (1, ARRAY[2, 1]),\n    (1, ARRAY[3, 2, 1]),\n    (1, ARRAY[7, 3, 2, 4, 1]),\n    (1, ARRAY[7, 3, 2, 4, 1]),\n    (1, ARRAY[7, 5, 3, 2, 4, 1])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a,\n       ARRAY_AGG(c ORDER BY c) OVER w,\n       ARRAY_AGG(c ORDER BY c DESC) OVER w,\n       ARRAY_AGG(c ORDER BY d) OVER w\nFROM (\n    VALUES (1, 1, 1, 5), (1, 2, 2, 4), (1, 3, 3, 1), (1, 4, 4, 2), (1, 4, 7, 6), (1, 5, 5, 3),\n           (2, 1, 1, 4), (2, 2, 3, 3), (2, 3, 2, 2), (2, 4, 1, 1)) AS t(a, b, c, d)\nWINDOW w AS (PARTITION BY a ORDER BY b)\n"))).matches("VALUES\n    (1, ARRAY[1], ARRAY[1], ARRAY[1]),\n    (1, ARRAY[1, 2], ARRAY[2, 1], ARRAY[2, 1]),\n    (1, ARRAY[1, 2, 3], ARRAY[3, 2, 1], ARRAY[3, 2, 1]),\n    (1, ARRAY[1, 2, 3, 4, 7], ARRAY[7, 4, 3, 2, 1], ARRAY[3, 4, 2, 1, 7]),\n    (1, ARRAY[1, 2, 3, 4, 7], ARRAY[7, 4, 3, 2, 1], ARRAY[3, 4, 2, 1, 7]),\n    (1, ARRAY[1, 2, 3, 4, 5, 7], ARRAY[7, 5, 4, 3, 2, 1], ARRAY[3, 4, 5, 2, 1, 7]),\n    (2, ARRAY[1], ARRAY[1], ARRAY[1]),\n    (2, ARRAY[1, 3], ARRAY[3, 1], ARRAY[3, 1]),\n    (2, ARRAY[1, 2, 3], ARRAY[3, 2, 1], ARRAY[2, 3, 1]),\n    (2, ARRAY[1, 1, 2, 3], ARRAY[3, 2, 1, 1], ARRAY[1, 2, 3, 1])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, ARRAY_AGG(c ORDER BY b DESC) OVER w\nFROM (\n    VALUES (1, 1, 1), (1, 2, 2), (1, 3, 3), (1, 4, 4), (1, 5, 5)) t(a, b, c)\nWINDOW w AS (PARTITION BY a ORDER BY b GROUPS BETWEEN 1 FOLLOWING AND 2 FOLLOWING)\n"))).matches("VALUES\n    (1, ARRAY[3, 2]),\n    (1, ARRAY[4, 3]),\n    (1, ARRAY[5, 4]),\n    (1, ARRAY[5]),\n    (1, NULL)\n");
    }

    @Test
    public void testWindowWithDistinct() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, ARRAY_AGG(DISTINCT c) OVER w\nFROM (\n    VALUES (1, 1, 1), (1, 2, 2), (1, 3, 1), (1, 4, 4), (1, 4, 2), (1, 5, 5),\n           (2, 1, 1), (2, 2, 3), (2, 3, 2), (2, 4, 3)) AS t(a, b, c)\nWINDOW w AS (PARTITION BY a ORDER BY b)\n"))).matches("VALUES\n    (1, ARRAY[1]),\n    (1, ARRAY[1, 2]),\n    (1, ARRAY[1, 2]),\n    (1, ARRAY[1, 2, 4]),\n    (1, ARRAY[1, 2, 4]),\n    (1, ARRAY[1, 2, 4, 5]),\n    (2, ARRAY[1]),\n    (2, ARRAY[1, 3]),\n    (2, ARRAY[1, 3, 2]),\n    (2, ARRAY[1, 3, 2])\n");
        ((QueryAssertions.QueryAssert)Assertions.assertThat(this.assertions.query("SELECT a, ARRAY_AGG(DISTINCT c ORDER BY c DESC) OVER w\nFROM (\n    VALUES (1, 1, 1), (1, 2, 2), (1, 3, 1), (1, 4, 4), (1, 4, 2), (1, 5, 5),\n           (2, 1, 1), (2, 2, 3), (2, 3, 2), (2, 4, 3)) AS t(a, b, c)\nWINDOW w AS (PARTITION BY a ORDER BY b)\n"))).matches("VALUES\n    (1, ARRAY[1]),\n    (1, ARRAY[2, 1]),\n    (1, ARRAY[2, 1]),\n    (1, ARRAY[4, 2, 1]),\n    (1, ARRAY[4, 2, 1]),\n    (1, ARRAY[5, 4, 2, 1]),\n    (2, ARRAY[1]),\n    (2, ARRAY[3, 1]),\n    (2, ARRAY[3, 2, 1]),\n    (2, ARRAY[3, 2, 1])\n");
    }
}

